/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Command line implementation of iEventObservers
//

#ifndef ICLEVENTOBSERVER_H
#define ICLEVENTOBSERVER_H


#include "ieventobserver.h"


class iclProgressEventObserver : public iProgressEventObserver
{
	
	friend class iShellFactory;

public:
	
	virtual void PreStarted();
	virtual void PostFinished();

protected:

	iclProgressEventObserver(iViewModule *vm);
	virtual ~iclProgressEventObserver();

	virtual void ChildStarted();
	virtual void ChildFinished();
	virtual bool CheckAbort();
	virtual void SetProgressBody(float fraction);
};


class iclAbortRenderEventObserver : public iAbortRenderEventObserver
{
	
	friend class iShellFactory;

public:
	
	virtual void Started();
	virtual void Finished();
	virtual bool CheckAbort();
	virtual void PostFinished();

protected:

	iclAbortRenderEventObserver(iViewModule *vm);
	virtual ~iclAbortRenderEventObserver();

	bool mStarted;
	int wSymbol;
};


class iclPickEventObserver : public iPickEventObserver
{
	
	friend class iShellFactory;

public:
	
	virtual void Started();
	virtual void Finished(const iPicker *);

protected:

	iclPickEventObserver(iViewModule *vm) : iPickEventObserver(vm){}
};


class iclRecordEventObserver : public iRecordEventObserver
{
	
	friend class iShellFactory;

public:
	
	virtual void UpdateInteraction();

protected:

	iclRecordEventObserver(iViewModule *vm) : iRecordEventObserver(vm){}
};


class iclParallelUpdateEventObserver : public iParallelUpdateEventObserver
{
	
	friend class iShellFactory;

public:
	
	virtual void UpdateInformation();

protected:

	iclParallelUpdateEventObserver(iControlModule *cm) : iParallelUpdateEventObserver(cm){}
};


class iclAnimatorEventObserver : public iAnimatorEventObserver
{
	
	friend class iShellFactory;

public:
	
	virtual void OnCameraPath(int){}

protected:

	iclAnimatorEventObserver(iViewModule *vm) : iAnimatorEventObserver(vm){}
};

#endif // ICLEVENTOBSERVER_H

