/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat Software
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_IM_CONTEXT_IIIM_H__
#define __GTK_IM_CONTEXT_IIIM_H__

#include <config.h>
#include <gtk/gtkimcontext.h>
#include <gtk/gtk.h>
#include <iiimcf.h>

G_BEGIN_DECLS

#ifdef ENABLE_NLS
#include<libintl.h>
#define _(String) dgettext(GETTEXT_PACKAGE,String)
#ifdef gettext_noop
#define N_(String) gettext_noop(String)
#else
#define N_(String) (String)
#endif
#else /* NLS is disabled */
#define _(String) (String)
#define N_(String) (String)
#define textdomain(String) (String)
#define gettext(String) (String)
#define dgettext(Domain,String) (String)
#define dcgettext(Domain,String,Type) (String)
#define bindtextdomain(Domain,Directory) (Domain) 
#endif

extern GType gtk_type_im_context_iiim;

#define GTK_TYPE_IM_CONTEXT_IIIM              gtk_type_im_context_iiim
#define GTK_IM_CONTEXT_IIIM(obj)              (GTK_CHECK_CAST ((obj), GTK_TYPE_IM_CONTEXT_IIIM, GtkIMContextIIIM))
#define GTK_IM_CONTEXT_IIIM_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_IM_CONTEXT_IIIM, GtkIMContextIIIMClass))
#define GTK_IS_IM_CONTEXT_IIIM(obj)           (GTK_CHECK_TYPE ((obj), GTK_TYPE_IM_CONTEXT_IIIM))
#define GTK_IS_IM_CONTEXT_IIIM_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IM_CONTEXT_IIIM))
#define GTK_IM_CONTEXT_IIIM_GET_CLASS(obj)    (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_IM_CONTEXT_IIIM, GtkIMContextIIIMClass))

typedef struct _GtkIMContextIIIM       GtkIMContextIIIM;
typedef struct _GtkIMContextIIIMClass  GtkIMContextIIIMClass;

typedef struct _GtkIIIMInfo GtkIIIMInfo;

typedef struct _SwitcherInfo SwitcherInfo;
typedef struct _SwitcherContext SwitcherContext;
typedef struct _StatusWindow StatusWindow;

struct _GtkIMContextIIIM
{
  GtkIMContext object;

  GtkIIIMInfo *iiim_info;
  GdkWindow *client_window;
  GtkWidget *client_widget;

  /* The status window for this input context; we claim the
   * status window when we are focused and have created an XIC
   */
  StatusWindow *status_window;

  SwitcherContext *switcher_context; /* per context */

  gchar *current_language;

  IIIMCF_context context;
  IIIMCF_lookup_choice lookup_choice;

  GtkWidget *candidate;
  GdkRectangle cursor;
  GSList *keylist;

  guint candidate_start :1;
  guint use_preedit : 1;
  guint finalizing : 1;
  guint in_toplevel : 1;
  guint has_focus : 1;

  struct _aux *aux;
};

struct _GtkIMContextIIIMClass
{
  GtkIMContextClass parent_class;
};

void im_context_iiim_register_type (GTypeModule *type_module);
GtkIMContext *im_context_iiim_new (void);

void im_context_iiim_shutdown (void);

extern void im_context_initialize_with_input_language (GtkIMContextIIIM *context_iiim,
						       gchar *new_lang);
extern void im_context_change_conversion_mode (GtkIMContextIIIM *context_iiim,
					       gchar *conv_mode);
extern SwitcherInfo* im_info_get_switcher_info (GtkIIIMInfo *info);
extern void im_info_set_switcher_info (GtkIIIMInfo *info, SwitcherInfo *sw_info);
extern GdkScreen *im_info_get_screen (GtkIIIMInfo *info);
extern IIIMCF_handle im_info_get_handle (GtkIIIMInfo *info);

extern void im_context_aux_set_values (GtkIMContextIIIM *context_iiim,
				       IIIMCF_event ev);
extern void im_context_aux_get_values (GtkIMContextIIIM *context_iiim,
				       IIIMCF_event ev);
G_END_DECLS

#endif

/* Local Variables: */
/* c-file-style: "gnu" */
/* End: */
