#ifndef IMSCHEDULER_HH_
#define IMSCHEDULER_HH_
#include <config.h>
#include <stdio.h>
#include "basictype.hh"

class IMProtocol;

struct IMScheduler_send_handler {
    int fd;
    virtual void send() = 0;
};

class IMScheduler
{
    // singleton
    static IMScheduler *pimscheduler;
  protected:
    IMProtocol *pimp;
    void register_singleton()
    { pimscheduler = this; }
  public:
    static IMScheduler *get_instance()
    {
	ASSERT(pimscheduler);
	return pimscheduler;
    }
    void set_improtocol(IMProtocol *x_pimp) { pimp = x_pimp; }
    virtual void send_request(IMScheduler_send_handler*) = 0;
    
    virtual int start() = 0;
    virtual int stop() = 0;
    IMScheduler() { pimp = NULL; }
};

#endif /* not IMSCHEDULER_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
