#ifndef IMSIGNAL_HH_
#define IMSIGNAL_HH_

#include <config.h>
#include <map>
#include "basictype.hh"

class IMSvr;

class IMSignal;

typedef RETSIGTYPE (IMSignal::*IMSignal_handler)();

extern "C" RETSIGTYPE signal_handler(int);

typedef map<int, IMSignal_handler> IMSignalHandlerMap;

/* singlton class */
class IMSignal
{
    static IMSignal *psinst;
    IMSvr *psvr;
    IMSignalHandlerMap hmap;

    void sighup();
    void term();

    IMSignal_handler getfunc(int);

    void add(
	int signum,
	IMSignal_handler h
    );
    void ignore(
	int signum
    );
    IMSignal(
	IMSvr *pimsvr
    );
  public:
    static IMSignal* get_instance()
    { return psinst; }
    static IMSignal* construct(
	IMSvr *pimsvr
    );
    static void cleanup()
    {
	if (psinst) delete psinst;
	psinst = NULL;
    }

  friend void signal_handler(int);
};

#endif /* not IMSIGNAL_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */

