/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "IMTriggerKeyList.hh"

IMTriggerKeyList::~IMTriggerKeyList() {
  int n = count();
  for (int i = 1; i <= n; i++) {
    IMTriggerKey *keyp =&(getKey(i));
    delete keyp;
  }
  keylist.destroy();
}

IMTriggerKeyList::IMTriggerKeyList(const char *keystring) {
  add(keystring);
}

IMTriggerKeyList::IMTriggerKeyList(unsigned int keysym,
				   unsigned int modifier,
				   unsigned int modifier_mask) {
  add(keysym, modifier, modifier_mask);
}

int
IMTriggerKeyList::count() const {
  return keylist.getSize();
}

IMTriggerKeyList&
IMTriggerKeyList::operator=(const IMTriggerKeyList& a) {
  keylist.destroy();
  int n = a.count();
  for (int i = 1; i <= n; i++) {
    IMTriggerKey keyp = a.getKey(i);
    IMTriggerKey *key = new IMTriggerKey(keyp.get_keyCode(),
					 keyp.get_modifier(),
					 keyp.get_modifier_mask());
    keylist.addItem(key);
  }
  return *this;
}

void
IMTriggerKeyList::add(unsigned int keysym, unsigned int modifier,
		      unsigned int modifier_mask) {
  IMTriggerKey *key = new IMTriggerKey(keysym, modifier,
				       modifier_mask);
  keylist.addItem(key);
}

IMTriggerKey&
IMTriggerKeyList::getKey(unsigned int index) const {
  return keylist.getItem(index);
}

