/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _iiimpclient_hh
#define _iiimpclient_hh

#include "IMList.hh"
#include "CompoundString.hh"

#include "IIIMProtocol.hh"

struct IMCommitCBStruct;
struct IMForwardEventCBStruct;
struct IMPreeditCBStruct;
struct IMStatusCBStruct;
struct IMLookupCBStruct;
struct IMAuxCBStruct;
struct IMConvStateCBStruct;

class IIIMProtocol;
class IMThread;
class InputContext;
class IMTransAccept;
union IMProtocolStruct;
struct ICAttribute;
struct IMAttr;
typedef struct _FrameMgr *FrameMgr;
typedef struct _XimFrame *XimFrame;

struct IIimpProtoHdr {
  unsigned char opcode;
  unsigned char length[3];
};

class IIIMPClient {
 public:
  IIIMPClient(IIIMProtocol*, IMTransAccept*);
  ~IIIMPClient();

  const CompoundString& getUser() const {return username;}

  // CLIENT DESCRIPTOR
  const CompoundString& getApplicationName() const {return application_name;}
  const CompoundString& getOSName() const {return os_name;}
  const CompoundString& getOSArch() const {return os_arch;}
  const CompoundString& getOSVersion() const {return os_version;}
  // Client Display Info
  const CompoundString& getXDisplayString() const {return xDisplayName;}
  const CompoundString& getXServerVendor() const {return xServerVendor;}

  int commit_string(IMCommitCBStruct *commit);
  int forward_event(IMForwardEventCBStruct *commit);

  int preedit_start(IMPreeditCBStruct *preedit);
  int preedit_draw(IMPreeditCBStruct *preedit);
  int preedit_caret(IMPreeditCBStruct *preedit);
  int preedit_done(IMPreeditCBStruct *preedit);

  int status_start(IMStatusCBStruct *status);
  int status_draw(IMStatusCBStruct *status);
  int status_done(IMStatusCBStruct *status);

  int lookup_start(IMLookupCBStruct *lookup);
  int lookup_draw(IMLookupCBStruct *lookup);
  int lookup_process(IMLookupCBStruct *lookup);
  int lookup_done(IMLookupCBStruct *lookup);

  int auxiliary_start(IMAuxCBStruct *auxiliary);
  int auxiliary_draw(IMAuxCBStruct *auxiliary);
  int auxiliary_done(IMAuxCBStruct *auxiliary);

  int conversion_start(IMConvStateCBStruct *state);
  int conversion_end(IMConvStateCBStruct *state);

  void register_triggerkeys();

  static void *socket_listener(void* data);

  int getICID(InputContext *ic) {
    return input_context_list.getIndex(ic);
  }
 private:
  void SetStringToFrame(FrameMgr fm, UTFCHAR* utf_str, int char_length);

  void SetStringToFrame(FrameMgr fm, char* str, int length);

  void send_message(int, CompoundString&, int);
#if !defined(USE_FRAMEMGR_ALWAYS)
#else /* USE_FRAMEMGR_ALWAYS */
  void send_message(int, int, XimFrame, int);
#endif /* USE_FRAMEMGR_ALWAYS */
  void send_message(int, int, int);
  void send_message(int, char *, int);
  void send_imvalues_message(int, int, ICAttribute*, int);

  unsigned char *create_ccdef_object_frame(IMObjectDescriptorStruct *,
					   char *, int, unsigned int *);
  unsigned char *create_jarfile_object_frame(IMObjectDescriptorStruct *,
					     char *, int, unsigned int *);
  unsigned char *create_binfile_object_frame(IMObjectDescriptorStruct *,
					     unsigned int *);
  enum PREDEFINED_IMATTRIBID {
    INPUT_METHOD_LIST = 0x1001,
    OBJECT_DESCRIPTOR_LIST = 0x1010,
    CLIENT_DESCRIPTOR = 0x1011,
    CHARACTER_CONVERSION_DEFINITION_RULE = 0x1030,
    JAR_GUI_OBJECT = 0x1031,
    JAR_LWE_OBJECT = 0x1032,
    BIN_GUI_OBJECT = 0x1033,
    BIN_LWE_OBJECT = 0x1034,
    SCRIPT_GUI_OBJECT = 0x1035,
    SCRIPT_LWE_OBJECT = 0x1036
  };

  //
  // Basic Protocol number
  //
  enum IIIM_PROTOCOL {
    IM_CONNECT = 1, IM_CONNECT_REPLY = 2,
    IM_DISCONNECT = 3, IM_DISCONNECT_REPLY = 4,
    IM_REGISTER_TRIGGER_KEYS  = 5,
    IM_TRIGGER_NOTIFY = 6, IM_TRIGGER_NOTIFY_REPLY = 7,
    IM_SETIMVALUES = 8, IM_SETIMVALUES_REPLY = 9,
    IM_GETIMVALUES = 10, IM_GETIMVALUES_REPLY = 11,
    IM_FORWARD_EVENT = 12, IM_FORWARD_EVENT_REPLY = 13,
    IM_COMMIT_STRING = 14,

    IM_CREATEIC = 20, IM_CREATEIC_REPLY = 21,
    IM_DESTROYIC = 22, IM_DESTROYIC_REPLY = 23,
    IM_SETICVALUES = 24, IM_SETICVALUES_REPLY = 25,
    IM_GETICVALUES = 26, IM_GETICVALUES_REPLY = 27,
    IM_SETICFOCUS = 28, IM_SETICFOCUS_REPLY = 29,
    IM_UNSETICFOCUS = 30, IM_UNSETICFOCUS_REPLY = 31,
    IM_RESETIC = 32, IM_RESETIC_REPLY = 33,

    IM_PREEDIT_START = 40, IM_PREEDIT_START_REPLY = 41,
    IM_PREEDIT_DRAW = 42, IM_PREEDIT_DRAW_REPLY = 43,
    IM_PREEDIT_CARET = 44, IM_PREEDIT_CARET_REPLY = 45,
    IM_PREEDIT_DONE = 46, IM_PREEDIT_DONE_REPLY = 47,

    IM_STATUS_START = 50, IM_STATUS_START_REPLY = 51,
    IM_STATUS_DRAW = 52, IM_STATUS_DRAW_REPLY = 53,
    IM_STATUS_DONE = 54, IM_STATUS_DONE_REPLY = 55,

    IM_LOOKUP_START = 70, IM_LOOKUP_START_REPLY = 71,
    IM_LOOKUP_DRAW = 72, IM_LOOKUP_DRAW_REPLY = 73,
    IM_LOOKUP_DONE = 74, IM_LOOKUP_DONE_REPLY = 75,
    IM_LOOKUP_PROCESS = 76, IM_LOOKUP_PROCESS_REPLY = 77,

    IM_AUX_START = 90, IM_AUX_START_REPLY = 91,
    IM_AUX_DRAW = 92, IM_AUX_DRAW_REPLY = 93,
    IM_AUX_DONE = 94, IM_AUX_DONE_REPLY = 95,
    IM_AUX_SETVALUES = 96, IM_AUX_SETVALUES_REPLY = 97,

    IM_ERROR = 99
  };

  IIIMProtocol *iiim_protocol;
  CompoundString username;

  // CLIENTDESCRIPTOR
  CompoundString application_name;
  CompoundString os_name;
  CompoundString os_arch;
  CompoundString os_version;

  CompoundString xDisplayName;
  CompoundString xServerVendor;

  ICAttribute *imAttribute_list; // IMAttribute_list
  int alloc_attr;
  int active_attr;

  char	byteOrder;

#if !defined(USE_FRAMEMGR_ALWAYS)
  CompoundString *authorization_list;
  int alloc_auth;
#else /* USE_FRAMEMGR_ALWAYS */
  CompoundString authorization;
#endif /* USE_FRAMEMGR_ALWAYS */

  int need_swap;
  /*
    '?': initial value
    'B': for Big-Endian
    'l': for little-endian
  */
  IMTransAccept *accept_fd;
  unsigned int im_id;		// copy of accept_fd->connection_id();
				// initialized at IM_CREATE_IC

  IMThread *thread;

  IMList<InputContext>  input_context_list;

  unsigned char* get_content(char*, int);
  unsigned char* get_amessage();
  unsigned char* get_im_connect();

  int read_data(const char *buf, const int len) const;
  int write_data(const char *buf, const int len) const;

  void dispatch(unsigned char*, int&);

  int Select();

#if !defined(USE_FRAMEMGR_ALWAYS)
  void change_icvalues(char *, IMProtocolStruct*);
#else /* USE_FRAMEMGR_ALWAYS */
  void change_icvalues(FrameMgr, int, IMProtocolStruct*);
#endif /* USE_FRAMEMGR_ALWAYS */
  void free_icvalues(IMProtocolStruct*);

  ICAttribute *get_icattr(unsigned short*, int);

  int preedit_state(IMConvStateCBStruct*);
  int preedit_erase_text(IMPreeditCBStruct*);
  int preedit_draw_text(IMPreeditCBStruct*);
  int status_draw_string(IMStatusCBStruct*);
  int status_draw_text(IMStatusCBStruct*);

  // Protocol message procedure
  void connect(IMProtocolStruct *, unsigned char *);
  void dis_connect(IMProtocolStruct *, unsigned char *);
  void set_imvalues(IMProtocolStruct *, unsigned char *);
  void get_imvalues(IMProtocolStruct *, unsigned char *);
  void create_ic(IMProtocolStruct *, unsigned char *);
  void set_icvalues(IMProtocolStruct *, unsigned char *);
  void get_icvalues(IMProtocolStruct *, unsigned char *);
  void set_icfocus(IMProtocolStruct *, unsigned char *);
  void unset_icfocus(IMProtocolStruct *, unsigned char *);
  void destroy_ic(IMProtocolStruct *, unsigned char *);
  void reset_ic(IMProtocolStruct *, unsigned char *);
  void forward_string(IMProtocolStruct *, unsigned char *) {}
  void forward_text(IMProtocolStruct *, unsigned char *) {}
  void forward_keyevent(IMProtocolStruct *, unsigned char *);
  void forward_event(IMProtocolStruct *, unsigned char *);
  void trigger_notify(IMProtocolStruct *, unsigned char *);
  void preedit_start_reply(IMProtocolStruct *, unsigned char *);
  void preedit_caret_reply(IMProtocolStruct *, unsigned char *);
  void aux_set_values(IMProtocolStruct *, unsigned char *);

  void set_card(ICAttribute*, char*, IMAttr*, int);
  int read_icvalue(unsigned short, int, void *p, ICAttribute*);
  int read_imvalue(unsigned short, int, void *p, ICAttribute*);

#if !defined(USE_FRAMEMGR_ALWAYS)
  int	imtext_size(IMText *text);
  char *req_put_imtext(char * ptr, IMText * text);
  char *req_put_imtext_s(char * ptr, IMText * text);
  int	utf16_string_size(int len);
  char *req_put_utf16_string(char * ptr, UTFCHAR * string, int length);
  char *req_put_utf16_string_s(char * ptr, UTFCHAR * string, int length);
  int	ascii_string_size(char * string);
  char *req_put_ascii_string(char * ptr, char * string);
  char *req_put_ascii_string_s(char * ptr, char * string);
  char *req_get_ascii_string(char * ptr, char ** string,
			     int * size_ret, int * buf_size_ret);
  char *req_get_ascii_string_s(char * ptr, char ** string,
			       int * size_ret, int * buf_size_ret);
  int	string_list_count(char *p);
  int	string_list_count2(char *p, int str_list_size);
  int	icattr_list_count(char * p);
  int	icattr_size(ICAttribute * icattr);
  char *req_put_icattr_list(char * ptr, ICAttribute * icattr, int num);
  char *req_put_icattr_list_s(char * ptr, ICAttribute * icattr, int num);
#else /* USE_FRAMEMGR_ALWAYS */
#endif /* USE_FRAMEMGR_ALWAYS */

  enum Msg { MAX_RW_DATA_LEN = 32768};

  enum ATTR { MAX_ATTRNUM = 10};

  enum ForwardEventType {
    FORWARD_STRING = 0,
    FORWARD_TEXT,
    FORWARD_KEYEVENT
  };

  // mark true if this client is being deleted
  int being_deleted;

  // mark true if this client can respond keep alive protocol
  int respond_keepalive;
};

#if !defined(USE_FRAMEMGR_ALWAYS)
typedef unsigned int   CARD32;
typedef unsigned short CARD16;
typedef unsigned char  CARD8;
#else /* USE_FRAMEMGR_ALWAYS */
#endif /* USE_FRAMEMGR_ALWAYS */

#define req_put8(p, d)		(*((CARD8 *)(p))  = (d), (p) += 1)
#define req_put16(p, d)		(*((CARD16 *)(p)) = (d), (p) += 2)
#define req_put32(p, d)		(*((CARD32 *)(p)) = (d), (p) += 4)

#define req_put8s(p, d)		(*((CARD8 *)(p))  = (d), (p) += 1)
#define req_put16s(p, d)	(*((CARD16 *)(p)) = req_swap16(d), (p) += 2)
#define req_put32s(p, d)	(*((CARD32 *)(p)) = req_swap32(d), (p) += 4)

#define req_get8(p, d)		((d) = *((CARD8 *)(p)), (p) += 1)
#define req_get16(p, d)		((d) = *((CARD16 *)(p)), (p) += 2)
#define req_get32(p, d)		((d) = *((CARD32 *)(p)), (p) += 4)

#define req_get8s(p, d)		((d) = *((CARD8 *)(p)), (p) += 1)
#define req_get16s(p, d)	((d) = req_swap16(*((CARD16 *)(p))), (p) += 2)
#define req_get32s(p, d)	((d) = req_swap32(*((CARD32 *)(p))), (p) += 4)

#define req_swap16(n)	((((n) <<  8) & 0x0000ff00) |	\
			 (((n) >>  8) & 0x000000ff))
#define req_swap32(n)	((((n) << 24) & 0xff000000) |	\
			 (((n) <<  8) & 0x00ff0000) |	\
			 (((n) >>  8) & 0x0000ff00) |	\
			 (((n) >> 24) & 0x000000ff))

#endif
