/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _improtocol_hh
#define _improtocol_hh

#include "IMLanguageList.hh"
#include "IMTriggerKeyList.hh"
#include "IMObjectDescriptorList.hh"
#include "IMEditorDescriptorList.hh"
#include "IMArg.h"
#include "IMTrans.hh"

class IMProtoHandler;

class IMProtocol {
 public:
  enum IM_Attribute {
    ServerName = 1,		// "htt"
    TransportAddress = 2,	// "tcp/<hostname>:9010" for iiim,
    				// not used for ximp40
    VendorName = 3,		// "SunMicroSystems", optional
    PrimaryInputLocale = 4,
    LanguageList = 5,
    ConversionOnKeys = 6,
    ConversionOffKeys = 7,
    ProtocolHandler = 8,
    ObjectDescriptors = 9,
    IMEDescriptors = 10,
    DisplayConnection = 11,
    IFName = 12,
    AppName = 13,
    DisableStatusArea = 14,
    DefaultFontName = 15
  };

  virtual int set_values(IMArg*, int);
  int get_values(IMArg*, int);

  virtual int run()=0;

  int countOnKeys() const;
  int countOffKeys() const;

  IMTriggerKey &getOnKey(unsigned int index) const;
  IMTriggerKey &getOffKey(unsigned int index) const;

  int countLanguages() const;
  CompoundString &getLang(unsigned int index) const;

  int countObjectDescriptors() const;
  IMObjectDescriptorStruct &getObjectDescriptor(unsigned int index) const;
  IMObjectDescriptorStruct &getFirstObjectDescriptor();
  IMObjectDescriptorStruct &getNextObjectDescriptor();

  int countIME() const;
  IMEditorStruct &getIME(unsigned int index) const;
  IMEditorStruct &getFirstIME();
  IMEditorStruct &getNextIME();

  const CompoundString &getPrimaryLocale() const;

  IMTransAccept* getIMTransAccept(IMTransListen *trans_listen) const;

  IMProtoHandler *proto_handler; // ProtocolHandler

 protected:
  IMProtocol(IMArg*, int);
  virtual ~IMProtocol();

  CompoundString protocol_name;	// ProtocolName
  CompoundString im_name;		// ServerName
  CompoundString im_address;		// TransportAddress
  CompoundString input_locale;	// PrimaryInputLocale
  CompoundString vendor_name;		// VendorName
  IMLanguageList lang_list;	// LanguageList
  IMTriggerKeyList on_keys;	// ConversionOnKeys
  IMTriggerKeyList off_keys;	// ConversionOffKeys

  IMObjectDescriptorList od_list; // ObjectDescriptors

  IMEditorDescriptorList ime_list; // IMEDescriptors

  enum MODE {
    OPEN, SET, GET
  };
 private:
  int parseArgs(int mode, IMArg *args, int n);
};

#endif
