/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

#include <Xm/XmAll.h>
#include <Xm/MwmUtil.h>

#include "trace_message.h"

#include "xaux_common.h"
#include "xaux_ext_common.h"

#include "sampleja3_xaux.h"

/* Definer Aux class */
xaux_class_t xaux_class = {
    "com.sun.sampleja3.PaletteAux", 1,
    (Window) 0, (Window) 0,
    (Atom) 0, (Atom) 0, (Atom) 0, (Atom) 0, (Atom) 0,
    NULL,
};

Widget toplevel;
Widget aux;
Widget button_text;

static xaux_class_t *xc_ = 0;
static int im_ = 0;
static int ic_ = 0;

void xt_ext_event_handler(Widget, XtPointer, XEvent *, Boolean * b);

/* Event Handler */
void
xt_ext_event_handler(
		     Widget w,
		     XtPointer client_data,
		     XEvent * event,
		     Boolean * b)
{

    switch (event->type) {
	case ClientMessage:
	xaux_ext_process_client_message(XtDisplay(w),
				     (XClientMessageEvent *) event);
	break;
    default:
	break;
    }

    return;
}

/* Method - Start */
Bool
xaux_ext_Start(
	       xaux_class_t * xc,
	       aux_ext_data_t * aux_ext_data)
{
    return True;
}

/* Method - Draw */
Bool
xaux_ext_Draw(
	      xaux_class_t * xc,
	      aux_ext_data_t * aux_ext_data)
{
    size_t i;
    char *sp;
    Bool rv = True;
    char buf[256];

    strncpy(buf, (const char *) aux_ext_data->aux_name,
	    aux_ext_data->aux_name_length);

    printf("ext_Draw[%s] im:0x%x, ic:0x%x\n",
	   buf, aux_ext_data->im, aux_ext_data->ic);


    for (i = 0; i < aux_ext_data->integer_count; i++) {
	printf("\tiv[%02d]=%d\n", i, aux_ext_data->integer_list[i]);
    }

    for (i = 0; i < aux_ext_data->string_count; i++) {
	printf("\tsv[%02d]=%s\n", i,
	       aux_ext_data->string_list[i].ptr);
    }

    im_ = aux_ext_data->im;
    ic_ = aux_ext_data->ic;
    xc_ = xc;

    if (aux_ext_data->integer_count == 1) {
	switch (aux_ext_data->integer_list[0]) {
	case SAMPLEJA3_AUXPALETTE_CONVON:
	    XtVaSetValues(button_text,
			  XtVaTypedArg, XmNlabelString,
	    XmRString, "conversion ON", strlen("conversion ON") + 1,
			  NULL);
	    break;
	case SAMPLEJA3_AUXPALETTE_CONVOFF:
	    XtVaSetValues(button_text,
			  XtVaTypedArg, XmNlabelString,
			  XmRString, "conversion OFF", strlen("conversion OFF") + 1,
			  NULL);
	    break;
	}
    }
    return True;
}

/* Method - Done */
Bool
xaux_ext_Done(
	      xaux_class_t * xc,
	      aux_ext_data_t * aux_ext_data)
{
    int i;
    char buf[256];

    strncpy(buf, (const char *) aux_ext_data->aux_name,
	    aux_ext_data->aux_name_length);

    printf("ext_Done[%s] im:0x%x, ic_id:0x%x\n",
	   buf, aux_ext_data->im, aux_ext_data->ic);

    return True;
}

void
ButtonCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    int integers[5];
    char *strings[5];

    integers[0] = 1;
    integers[1] = 2;
    integers[2] = 3;
    integers[3] = 4;
    strings[0] = "test_string1";
    strings[1] = "test_string2";
    strings[2] = "test_string3";
    strings[3] = "test_string4";
    ReturnToEngine(4, integers, 4, strings);

HelpInvoke("a.html");

    return;
}

int
main(int argc, char **argv)
{
    XtAppContext app;
    Display *display;
    int narg;
    Arg args[10];
Widget textfield;

    TRACE_MESSAGE_INIT("TRACE_AUX_EXT");

    setlocale(LC_ALL, NULL);
    XtSetLanguageProc(NULL, NULL, NULL);

    narg = 0;
    XtSetArg(args[narg], XmNmwmFunctions, MWM_FUNC_MOVE | MWM_FUNC_RESIZE); narg++;
    XtSetArg(args[narg], XmNx, 10); narg++;
    XtSetArg(args[narg], XmNy, 10); narg++;
    XtSetArg(args[narg], XmNtitle, "Motif Palette"); narg++;


    toplevel = XtAppInitialize(&app, "aux", NULL, 0,
			       &argc, argv, NULL, args, narg);

    display = XtDisplay(toplevel);

    aux = XtVaCreateManagedWidget("aux", xmRowColumnWidgetClass,
				  toplevel, NULL, 0);

    button_text = XtCreateManagedWidget("button", xmPushButtonWidgetClass,
					aux, NULL, 0);
    XtVaSetValues(button_text,
		  XtVaTypedArg, XmNlabelString,
	          XmRString, "Test", strlen("Test") + 1,
		  NULL);

    XtAddCallback(button_text, XmNarmCallback, ButtonCallback, NULL);

	narg = 0;
        XtSetArg(args[narg], XmNcolumns, 30);  ++narg;

    textfield = XmCreateTextField(aux, "textfield", args, narg);
	XtManageChild(textfield);

    XtRealizeWidget(toplevel);

    /* Register aux class */
    if (xaux_ext_init_classes(XtDisplay(toplevel),
			&xaux_class, XtWindow(toplevel)) == False) {
	return 2;
    }

    /* Register event handler */
    XtAddEventHandler(toplevel, PropertyChangeMask, False,
		      xt_ext_event_handler, NULL);

    XtAddEventHandler(toplevel, NoEventMask, True,
		      xt_ext_event_handler, NULL);

    XtAppMainLoop(app);

    return 0;
}

ReturnToEngine(
	       int integer_count,
	       int *integers,
	       int string_count,
	       char **strings
)
{
    int i;

    aux_ext_data_t *aux_data;

    if (!im_ || !ic_ || !xc_)
	return;

    if (!integer_count && !string_count)
	return;

    aux_data = (aux_ext_data_t *) calloc(1, sizeof(aux_ext_data_t));

    aux_data->im = im_;
    aux_data->ic = ic_;
    aux_data->integer_count = integer_count;
    aux_data->string_count = string_count;

    if (aux_data->integer_count) {
	aux_data->integer_list = (int *) calloc(1, sizeof(int) * aux_data->integer_count);
	for (i = 0; i < aux_data->integer_count; i++) {
	    aux_data->integer_list[i] = integers[i];
	}
    }
    if (aux_data->string_count) {
	aux_data->string_list = (aux_ext_string_t *) calloc(1,
		 sizeof(aux_ext_string_t) * aux_data->string_count);
	for (i = 0; i < aux_data->string_count; i++) {
	    aux_ext_string_t *p = &aux_data->string_list[i];
	    p->length = strlen(strings[i]);
	    p->ptr = (unsigned char *) strdup(strings[i]);
	}
    }
    xaux_ext_SetValue(XtDisplay(toplevel), xc_, aux_data);

    if (aux_data->integer_list)
	free(aux_data->integer_list);
    if (aux_data->string_list) {
	for (i = 0; i < aux_data->string_count; i++) {
	    aux_ext_string_t *p = &aux_data->string_list[i];
	    if (p && p->ptr)
		free(p->ptr);
	}
	free(aux_data->string_list);
    }
    free(aux_data);
}
