/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <locale.h>

#include "encode.h"
#include "UtilityConfig.h"

#define MAX_LINE_LEN 		256
#define UTILITY_FILE_NAME	"utilities.cfg"

#define LABEL_STR		"LABEL"
#define COMMAND_STR		"COMMAND"

char *normal_utilities_name_CN[NORMAL_UTILITIES_NUM] = {
	"输入法选择",
	"输入法选项设置",
	"查找表",
};

char *normal_utilities_name_TW[NORMAL_UTILITIES_NUM] = {
	"輸入法選擇",
	"輸入法選項設置",
	"查找表",
};

int 	gUtilitiesNum = 0;
Utility_Item *gUtilitiesItem[MAX_UTILITIES_NUM];

static int  nLocaleID;

void get_utility_line(FILE *fd, char *line);
int read_utility_config_file(char *file_name);
int get_normal_utilities_item(char *locale_name);
void set_utility_item_label(Utility_Item *pUtilItem, char *label_str);
int Utilities_Print();

Utility_Item *UtilityItem_Malloc()
{
	Utility_Item *pUtilItem;

	pUtilItem = (Utility_Item *)calloc(1, sizeof(Utility_Item));

	if (pUtilItem == NULL) return(NULL);

	pUtilItem->ename_str = NULL;
	pUtilItem->label_str = NULL;
	pUtilItem->command_str = NULL;

	return(pUtilItem);
}

void UtilityItem_Free(Utility_Item *pUtilItem)
{
	if (pUtilItem == NULL) return;

	if (pUtilItem->ename_str) 
		free((char *)pUtilItem->ename_str);
	if (pUtilItem->label_str) 
		free((char *)pUtilItem->label_str);
	if (pUtilItem->command_str) 
		free((char *)pUtilItem->command_str);

	free((char *)pUtilItem);
}

int Utilities_Init()
{
	int i;
	char file_name[256], *lang_name, *locale_name;

	gUtilitiesNum = 0;

	for (i=0; i<MAX_UTILITIES_NUM; i++)
		gUtilitiesItem[i] = NULL;

	locale_name = setlocale(LC_CTYPE, NULL);
	nLocaleID = get_encodeid_from_locale(locale_name);

/*
	get_normal_utilities_item(locale_name);
*/

	lang_name = (char *)get_langname_from_locale(locale_name);
	DEBUG_printf("lang_name:%s\n", lang_name);

	sprintf(file_name, "/usr/lib/im/locale/%s/%s", lang_name, UTILITY_FILE_NAME);
	DEBUG_printf("file_name:%s\n", file_name);

	read_utility_config_file(file_name);

	Utilities_Print();
}

int Utilities_Done()
{
	int i;

	for (i=0; i<gUtilitiesNum; i++) {
		UtilityItem_Free(gUtilitiesItem[i]);
	}
}

int Utilities_Print()
{
	int i;

	DEBUG_printf("gUtilitiesNum: %d\n", gUtilitiesNum);
	for (i=0; i<gUtilitiesNum; i++) {
		if (gUtilitiesItem[i] == NULL) continue;

		if (gUtilitiesItem[i]->ename_str) 
			DEBUG_printf("ename_str:%s\n",gUtilitiesItem[i]->ename_str);
		if (gUtilitiesItem[i]->label_str) 
			DEBUG_printf("label_str:%s\n",gUtilitiesItem[i]->label_str);
		if (gUtilitiesItem[i]->command_str) 
			DEBUG_printf("command_str:%s\n",gUtilitiesItem[i]->command_str);
	}
}

void get_utility_line(FILE *fd, char *line)
{
	int line_ptr;
	char line_buf[256], *ptr;

	line_ptr = 0;
	line[0] = '\0';

	/* get line with no space */
 	while(fgets(line_buf, 255, fd) != NULL) {
		ptr = line_buf;

		/* skip space keys */
		while(*ptr && isspace(*ptr)) ptr++;

		/* if is space line, get new line */
		if (*ptr == '\n' || *ptr == '\0')
			continue;

		while(*ptr != '\n' && *ptr != '\0' && line_ptr < MAX_LINE_LEN) 
			line[line_ptr++] = *ptr++;

		while (isspace(line[line_ptr-1])) line_ptr--;
		line[line_ptr] = '\0';

		/* if the line end with '\', then continue read the next line */
		if (line[line_ptr-1] == '\\') {
			line_ptr--;
			line[line_ptr] = '\0';
			continue;
		}

		break;
	}
}

/* 
utilities.cfg file format as follow:
this file must be writen in UTF-8 encoding.

[ utility item english name ]
LABEL   Chinese name
COMMAND execute string
*/
int read_utility_config_file(char *file_name)
{
	char	line[MAX_LINE_LEN];
	char 	*ptr, *ename_str;
	FILE 	*fd;
	Utility_Item *pUtilItem;
	int 	need_alloc_new_item;
	int 	len;

	fd = fopen(file_name, "r");
	if (!fd) {
		DEBUG_printf("Can not open the file:%s\n", file_name);
		return(-1);
	}

	do {
		if (gUtilitiesNum >= MAX_UTILITIES_NUM) break;

		get_utility_line(fd, line);

		if (line[0] == '\0') break;
		if (line[0] == '#') continue;

		len = strlen(line);
		if (line[0] == '[' && line[len-1] == ']') {
			/* Check the previous item is a formal item */
			need_alloc_new_item = 1;
			if (gUtilitiesNum > 0) {
				pUtilItem = gUtilitiesItem[gUtilitiesNum-1];
				if (pUtilItem != NULL) {
					if (pUtilItem->label_str == NULL)
						need_alloc_new_item = 0;
				}
			}

			if (need_alloc_new_item == 1) {
				pUtilItem = (Utility_Item *)UtilityItem_Malloc();
				if (pUtilItem == NULL) {
					DEBUG_printf("No memory \n");
					break;
				}

				gUtilitiesItem[gUtilitiesNum] = pUtilItem;
				gUtilitiesNum ++;
			}
			
			/* get english name of the item */
			ptr = line + 1;
			while(isspace(*ptr)) ptr++;
			ename_str = ptr;

			ptr = line + len - 2;
			while(isspace(*ptr)) ptr--;
			*(ptr+1) = '\0';

			if (*ename_str) {
				if (pUtilItem->ename_str) free((char *)pUtilItem->ename_str);
				pUtilItem->ename_str = (char *)strdup(ename_str);
			}
			continue;
		}
		
		if (!(strncasecmp(line, LABEL_STR, strlen(LABEL_STR)))) {
			ptr = line + strlen(LABEL_STR);
			while(*ptr && isspace(*ptr)) ptr++;
			if (*ptr) {
				if (pUtilItem->label_str) free((char *)pUtilItem->label_str);
				set_utility_item_label(pUtilItem, ptr);
			}
		}

		if (!(strncasecmp(line, COMMAND_STR, strlen(COMMAND_STR)))) {
			ptr = line + strlen(COMMAND_STR);
			while(*ptr && isspace(*ptr)) ptr++;
			if (*ptr) {
				if (pUtilItem->command_str) free((char *)pUtilItem->command_str);
				pUtilItem->command_str = (char *)strdup(ptr);
			}
		}

	} while (1);

	fclose(fd);
	return(0);
}

int get_normal_utilities_item(char *locale_name)
{
	int i, lang_id;
	Utility_Item *pUtilItem;
	char **utilities_names;

	lang_id = get_langid_from_locale(locale_name);

	utilities_names = normal_utilities_name_CN;
	if (lang_id == LANG_ZH_CN)
		utilities_names = normal_utilities_name_CN;
	else if (lang_id == LANG_ZH_TW || lang_id == LANG_ZH_HK)
		utilities_names = normal_utilities_name_TW;
	  
	for (i=0; i<NORMAL_UTILITIES_NUM; i++) {
		pUtilItem = (Utility_Item *)UtilityItem_Malloc();
		if (pUtilItem == NULL) {
			DEBUG_printf("No memory \n");
			continue;
		}

		set_utility_item_label(pUtilItem, utilities_names[i]);

		gUtilitiesItem[gUtilitiesNum] = pUtilItem;
		gUtilitiesNum ++;
	}
	return(0);
}

void set_utility_item_label(Utility_Item *pUtilItem, char *label_str)
{
	if (!label_str || !*label_str) return;

	pUtilItem->label_str = (char *)strdup(label_str);
}

