/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "dayi_symbol.h"

int DayiSymbolList_Init(TDayiSymbolList *pDayiSymbolList)
{
	pDayiSymbolList->nNum_Symbols = 0;
	pDayiSymbolList->nNum_Symbols_Alloced = 0;
	pDayiSymbolList->pSymbols = NULL;

	return(DAYI_SYMBOL_OK);
}

int DayiSymbolList_Free(TDayiSymbolList *pDayiSymbolList)
{
	int i;

	if (pDayiSymbolList->pSymbols == NULL) {
		return(0);
	}

	for(i=0; i<pDayiSymbolList->nNum_Symbols_Alloced; i++) {
		if (pDayiSymbolList->pSymbols[i]== NULL)
			continue;

		if (pDayiSymbolList->pSymbols[i]->pList) {
			free((char *)pDayiSymbolList->pSymbols[i]->pList);
		}

		free((char *)pDayiSymbolList->pSymbols[i]);
	}

	free((char *)pDayiSymbolList->pSymbols);

	pDayiSymbolList->nNum_Symbols = 0;
	pDayiSymbolList->nNum_Symbols_Alloced = 0;
	pDayiSymbolList->pSymbols = NULL;

	return(DAYI_SYMBOL_OK);
}

int DayiSymbolList_Alloc(TDayiSymbolList *pDayiSymbolList, int nNum_Alloced)
{
	int i;

	pDayiSymbolList->nNum_Symbols_Alloced = 0;
	pDayiSymbolList->pSymbols = (PDayiSymbol*)malloc(nNum_Alloced*sizeof(PDayiSymbol));
	if (pDayiSymbolList->pSymbols == NULL) {
		return(DAYI_SYMBOL_ERROR);
	}

	for (i=0; i<nNum_Alloced; i++)
		pDayiSymbolList->pSymbols[i] = NULL;

	pDayiSymbolList->nNum_Symbols_Alloced = nNum_Alloced;

	return(DAYI_SYMBOL_OK);
}

int DayiSymbolList_ReAlloc(TDayiSymbolList *pDayiSymbolList, int nNum_ReAlloced)
{
	int i;

	pDayiSymbolList->pSymbols = (PDayiSymbol*)realloc(pDayiSymbolList->pSymbols,
					nNum_ReAlloced * sizeof(PDayiSymbol));
	if (pDayiSymbolList->pSymbols == NULL) {
		pDayiSymbolList->nNum_Symbols = 0;
		pDayiSymbolList->nNum_Symbols_Alloced = 0;
		return(DAYI_SYMBOL_ERROR);
	}

	for (i=pDayiSymbolList->nNum_Symbols_Alloced; i<nNum_ReAlloced; i++)
		pDayiSymbolList->pSymbols[i] = NULL;

	pDayiSymbolList->nNum_Symbols_Alloced = nNum_ReAlloced;

	return(DAYI_SYMBOL_OK);
}

int DayiSymbolList_Print(TDayiSymbolList *pDayiSymbolList)
{
	int nSymbol_ID;

	printf("nNum_Symbols: %d\n", pDayiSymbolList->nNum_Symbols);
	for(nSymbol_ID = 0; nSymbol_ID < pDayiSymbolList->nNum_Symbols; nSymbol_ID ++) {
		if (pDayiSymbolList->pSymbols[nSymbol_ID] == NULL) {
			return(DAYI_SYMBOL_ERROR);
		}

		if (pDayiSymbolList->pSymbols[nSymbol_ID]->pList == NULL) {
			return(DAYI_SYMBOL_ERROR);
		}

		printf("%c\t%s\n", 
				pDayiSymbolList->pSymbols[nSymbol_ID]->key,
				pDayiSymbolList->pSymbols[nSymbol_ID]->pList);
	}

	return(DAYI_SYMBOL_OK);
}

unsigned char *DayiSymbolList_Get_SymbolList(TDayiSymbolList *pDayiSymbolList, int key)
{
	int i;

	for (i=0; i<pDayiSymbolList->nNum_Symbols; i++) {
		if (pDayiSymbolList->pSymbols[i]== NULL)
			continue;

		if (pDayiSymbolList->pSymbols[i]->key == key) {
			return(pDayiSymbolList->pSymbols[i]->pList);
		}
	}
	return(NULL);
}

int DayiSymbolList_CheckIfValidKey(TDayiSymbolList *pDayiSymbolList, int key)
{
	unsigned char *pList = DayiSymbolList_Get_SymbolList(pDayiSymbolList, key);
	if (pList != NULL) {
		return(1);
	} else {
		return(0);
	}
}

int DayiSymbolList_Item_Prepare(TDayiSymbolList *pDayiSymbolList, int nSymbol_ID)
{
	int ret;

	if (nSymbol_ID < 0 || nSymbol_ID >= pDayiSymbolList->nNum_Symbols_Alloced + NUM_SYMBOLS_ALLOC)
		return(DAYI_SYMBOL_ERROR);

	if (pDayiSymbolList->nNum_Symbols_Alloced == 0) {
		ret = DayiSymbolList_Alloc(pDayiSymbolList, NUM_SYMBOLS_ALLOC);
		if (ret == DAYI_SYMBOL_ERROR)
			return(DAYI_SYMBOL_ERROR);
	}

	if (nSymbol_ID >= pDayiSymbolList->nNum_Symbols_Alloced) {
		int nNum_Alloc = pDayiSymbolList->nNum_Symbols_Alloced + NUM_SYMBOLS_ALLOC;
		ret = DayiSymbolList_ReAlloc(pDayiSymbolList, nNum_Alloc);
		if (ret == DAYI_SYMBOL_ERROR)
			return(DAYI_SYMBOL_ERROR);
	}

	if (pDayiSymbolList->pSymbols[nSymbol_ID] == NULL) {
		pDayiSymbolList->pSymbols[nSymbol_ID] = (TDayiSymbol *)calloc(1, sizeof(TDayiSymbol));
		if (pDayiSymbolList->pSymbols[nSymbol_ID] == NULL)
			return(DAYI_SYMBOL_ERROR);
	}

	if (pDayiSymbolList->pSymbols[nSymbol_ID]->pList != NULL) {
		free((char *)pDayiSymbolList->pSymbols[nSymbol_ID]->pList);
		pDayiSymbolList->pSymbols[nSymbol_ID]->pList = NULL;
	}

	return(DAYI_SYMBOL_OK);
}

int DayiSymbolList_Item_Set_SymbolList(TDayiSymbolList *pDayiSymbolList, int nSymbol_ID, char key, unsigned char *pList)
{
	if (!pList || !*pList) 
		return(DAYI_SYMBOL_ERROR);

	if (nSymbol_ID < 0 || nSymbol_ID >= pDayiSymbolList->nNum_Symbols_Alloced)
		return(DAYI_SYMBOL_ERROR);

	if (pDayiSymbolList->pSymbols[nSymbol_ID] == NULL)
		return(DAYI_SYMBOL_ERROR);

	if (pDayiSymbolList->pSymbols[nSymbol_ID]->pList != NULL) {
		free((char *)pDayiSymbolList->pSymbols[nSymbol_ID]->pList);
	}

	pDayiSymbolList->pSymbols[nSymbol_ID]->pList = (unsigned char *)strdup(pList);
	if (pDayiSymbolList->pSymbols[nSymbol_ID]->pList == NULL)
		return(DAYI_SYMBOL_ERROR);

	pDayiSymbolList->pSymbols[nSymbol_ID]->key = key;

	return(DAYI_SYMBOL_OK);
}
