/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include  <stdio.h>
#include  <string.h>
#include  <stdlib.h>
#include  "GeneType.h"
#include  "PyStatic.h"
#include  "Ciku.h"

JINT    Big5HzcodeToYjcode(JINT nHzcode);
JINT    GetNextLine(FILE* pfFile, CHAR* szBuf);
VOID    ProcBig5Hz(FILE *out);
VOID    ReadBig5Line(VOID);
VOID    CreateBig5HzcodeToYj();
VOID    TestBig5HzcodeToYj();
JINT    FastMatchYinJieStr(CHAR* szPystr);
VOID    Show32To9Int(JUINT *pnHzYj32);

static  UCHAR   szBig5Line[30000][40];
static  JWORD   wBig5Code[30000];
static  JINT    nBig5Yj[30000];
static  JINT    nBig5Line;

JINT    nBig5NumByYj[NUM_YINJIE];
JWORD   wBig5HzByYj[NUM_YINJIE][400];
JINT    nYj[0xFFFF];

FILE * outfp;

VOID ProcBig5Hz(FILE * out)
{
	JINT    i, nTmp, nTmp2, nTmp3;

	outfp = out;
	ReadBig5Line();

	memset (nBig5NumByYj, '\0', NUM_YINJIE * sizeof(JINT));
	for (i = 0; i < NUM_YINJIE; i++)
		memset (wBig5HzByYj[i], '\0', 400 * sizeof(JWORD));

	nTmp2 = nTmp3 = 0;
	nTmp = 0;
	for (i = 0; i < nBig5Line; i++)
	{
		if (nBig5Yj[i] != 0xFFFF)
		{
				wBig5HzByYj[nBig5Yj[i]][nBig5NumByYj[nBig5Yj[i]]] = wBig5Code[i];
				nBig5NumByYj[nBig5Yj[i]] ++;
				nTmp2 ++;
		}
		else
		{
		/*	printf ("!!%s", szBig5Line[i]);  */
			nTmp ++;
		}
	}
	printf ("Total %d Non_Standard Yinjie in < BIG5.txt >\n", nTmp);

	for (i = 0; i < NUM_YINJIE; i++)
	{
		if ((i != 0) && (i % 5 == 0))
			printf ("\n");
		printf("%3d|%-6s[%3d] ", i, YINJIESTR_CSZ[i], nBig5NumByYj[i]);
	}
	printf("\n");
	
	CreateBig5HzcodeToYj();
/*	TestBig5HzcodeToYj(); */
}


VOID ReadBig5Line(VOID)
{
	FILE*   pfBig5;
	CHAR    szBig5Name[] = "../data/BIG5.txt";
	UCHAR   szTmp[40];
	JINT    i, k, m, t2, t3;
	JINT    nTmp, nInvalidNum;

	pfBig5 = fopen (szBig5Name, "rb");
	if (pfBig5 == NULL)
	{
		printf ("Failed to Open File %s\n", szBig5Name);
		exit (FALSE);
	}

	k = 0;
	for (t2 = 1; t2 == 1;  )
	{
		memset(szTmp, '\0', 40);
		t2 = GetNextLine(pfBig5, (CHAR*)szTmp);
		t3 = strlen((CHAR*)szTmp);
		
		if (t3 > 2)
		{
			for (m = 0; m < t3; m++)
				szBig5Line[k][m] = szTmp[m];
			k++;
		}
	}
	
	fclose (pfBig5);
	nBig5Line = k;
	printf("nBig5Line is %d\n", nBig5Line);

	/* Get BIG5 Hanzi Code. */
	memset (wBig5Code, 0, sizeof(JWORD) * 30000);
	for (i = 0; i < nBig5Line; i++)
		wBig5Code[i] = (JWORD)(((JWORD)szBig5Line[i][7] << 8) + szBig5Line[i][8]);

	/* Get BIG5 Yinjie Code. If not a standard Yinjie, use 0xFFFF instead */
	nInvalidNum = 0;
	memset (nBig5Yj, 0, sizeof(JINT) * 30000);
	for (i = 0; i < nBig5Line; i++)
	{
		memset(szTmp, '\0', 40);
		for (k = 10; (szBig5Line[i][k] >= 'a') && (szBig5Line[i][k] <= 'z'); k++)
			szTmp[k - 10] = szBig5Line[i][k];

		nTmp = FastMatchYinJieStr((CHAR*)szTmp);
		if (nTmp == -1)
		{
			nBig5Yj[i] = 0xFFFF;
			nInvalidNum ++;
		printf("YYY: %x____%s\n",wBig5Code,szTmp);
		}
		else
			nBig5Yj[i] = nTmp;
	}

	printf("nInvalidNum in BIG5.txt is %d\n", nInvalidNum);
}


/*
**  Create (JUINT)BIG5HZCODETOYJ[].
**  From 0xA440 to 0xC67E, 0xA940 to 0xF9DC.
**  Notice: Reserved Area I and Reserved Area II are also included
**  In this Array. 
*/
VOID CreateBig5HzcodeToYj()
{
	JINT    i, j, k, w, nTmp, nHzcode;
	JUINT   nHzYj32[32];
	
	/* Init nYj[] Array */
	for (i = 0; i < 0xFFFF; i++)
		nYj[i] = 0x01FF;
	
	/* Fill nYj[] with data come from nBig5Yj[] */
	w = 0;
	for (i = 0; i < nBig5Line; i++)
		if ((nBig5Yj[i] >= 0) && (nBig5Yj[i] < NUM_YINJIE))
		{
			nYj[wBig5Code[i]] = nBig5Yj[i];
			w++;
		}
	printf("Valid Yinjie in nBig5Yj is %d\n", w);
	
	/* I => High, J => Low */

	fprintf(outfp, "\n/*");
	fprintf(outfp, "\n** This Table is for BIG5!!");
	fprintf(outfp, "\n** Each Hz have 9Bits(0~512) to indicates Yinjie Code.");
	fprintf(outfp, "\n** This Table was seperated to 2 party: [0xA440 ~ 0xC67E], [0xC940 ~ 0xF9DC].");
	fprintf(outfp, "\n** Both part include 0x??7F");
	fprintf(outfp, "\n*/");
	fprintf(outfp, "\nstatic unsigned int BIG5HZCODETOYJ[] = {");
	fprintf(outfp, "\n\t/**0xA440 ~ 0xC67F**/\n");

	/* 34 * 157 + 63 */
	w = 0;
	for (k = 0; k < 32; k++)
		nHzYj32[k] = 0x01FF;

	for (i = 0xA4; i <= 0xC6; i++)
	{
		for (j = 0x40; j <= 0x7E; j++)
		{
			nHzcode    = (i << 8) + j;
			nHzYj32[w] = nYj[nHzcode];
			w++;
			if (w == 32)
			{
				Show32To9Int(nHzYj32);
				w = 0;
				for (k = 0; k < 32; k++)
					nHzYj32[k] = 0x01FF;
			}
		}
		if (i != 0xC6)
		for (j = 0xA1; j <= 0xFE; j++)
		{
			nHzcode    = (i << 8) + j;
			nHzYj32[w] = nYj[nHzcode];
			w++;
			if (w == 32)
			{
				Show32To9Int(nHzYj32);
				w = 0;
				for (k = 0; k < 32; k++)
					nHzYj32[k] = 0x01FF;
			}
		}
	}
        if (w != 0)
                Show32To9Int(nHzYj32);

	fprintf(outfp, "\n\t/**0xC940 ~ 0xF9DC**/\n");
	/* 48 * 157 + 93 */
	w = 0;
	for (k = 0; k < 32; k++)
		nHzYj32[k] = 0x01FF;

	for (i = 0xC9; i <= 0xF9; i++)
	{
		for (j = 0x40; j <= 0x7E; j++)
		{
			nHzcode    = (i << 8) + j;
			nHzYj32[w] = nYj[nHzcode];
			w++;
			if (w == 32)
			{
				Show32To9Int(nHzYj32);
				w = 0;
				for (k = 0; k < 32; k++)
					nHzYj32[k] = 0x01FF;
			}
		}
		if (i != 0xF9)
		for (j = 0xA1; j <= 0xFE; j++)
		{
			nHzcode    = (i << 8) + j;
			nHzYj32[w] = nYj[nHzcode];
			w++;
			if (w == 32)
			{
				Show32To9Int(nHzYj32);
				w = 0;
				for (k = 0; k < 32; k++)
					nHzYj32[k] = 0x01FF;
			}
		}
		else
		for (j = 0xA1; j <= 0xDC; j++)
		{
			nHzcode    = (i << 8) + j;
			nHzYj32[w] = nYj[nHzcode];
			w++;
			if (w == 32)
			{
				Show32To9Int(nHzYj32);
				w = 0;
				for (k = 0; k < 32; k++)
					nHzYj32[k] = 0x01FF;
			}
		}
	}

	if (w != 0)
		Show32To9Int(nHzYj32);
	fprintf(outfp, "};\n");
}



/*
**  pnHzYj32 point to a 32 int array which indicates the Yinjie code.
*/
VOID Show32To9Int(JUINT *pnHzYj32)
{
	JUINT   nNine[10];
	JUINT   i, nFrom, nTo, nToMode, nTmp1, nTmp2;

	for (i = 0; i < 10; i++)
		nNine[i] = 0x00000000;

	for (i = 0; i < 32; i++)
	{
		nFrom = (i * 9) / 32;
		nTo   = ((i + 1) * 9) / 32;
		if (nFrom == nTo)
		{
			nToMode = 32 - (((i + 1) * 9) % 32);
			nTmp1   = nNine[nFrom];
			nTmp2   = pnHzYj32[i] << nToMode;
			nTmp2  |= nTmp1;
			nNine[nFrom] |= nTmp2;
		}
		else /* (nTo > nFrom) */
		{
			nToMode = ((i + 1) * 9) % 32;

			nTmp1   = nNine[nFrom];
			nTmp2   = pnHzYj32[i] >> nToMode;
			nTmp2  |= nTmp1;
			nNine[nFrom] |= nTmp2;

			nTmp1   = nNine[nTo];
			nTmp2   = pnHzYj32[i] << (32 - nToMode);
			nTmp2  |= nTmp1;
			nNine[nTo] |= nTmp2;
		}
	}

	fprintf(outfp, "\t");
	for (i = 0; i < 9; i++)
		fprintf(outfp, "0x%08X, ", nNine[i]);
	fprintf(outfp, "\n");
}

/*
VOID TestBig5HzcodeToYj()
{
	UCHAR   chHz[3];
	JINT    nHzcode;
	JINT    nYj;
	JINT    w;

	w = 0;
	chHz[2] = '\0';

	for (nHzcode = 0x2001; nHzcode <= 0x21AC; nHzcode ++) {
		nYj     = Big5HzcodeToYjcode(nHzcode);
		chHz[0] = (DYZLIST[nHzcode - 0x2001] >> 8) & 0x00FF;
		chHz[1] = DYZLIST[nHzcode - 0x2001] & 0x00FF;
		chHz[2] = 0;
		printf("0x%04x %s %s \n", nHzcode, chHz, YINJIESTR_CSZ[nYj]);
	}

	for (chHz[0] = 0xA4; chHz[0] <= 0xC5; chHz[0]++)
	{
		for (chHz[1] = 0x40; chHz[1] <= 0x7E; chHz[1]++)
		{
			nHzcode = ((JINT)chHz[0] << 8) + (JINT)chHz[1];
			nYj     = Big5HzcodeToYjcode(nHzcode);
			printf("0x%02x%02x %s ", (JUINT)chHz[0], (JUINT)chHz[1], chHz);
			if (nYj == 0x01FF)
				printf("[NONE]\n");
			else if ((nYj >= 0) && (nYj < NUM_YINJIE ))
			{
				printf("%s\n", YINJIESTR_CSZ[nYj]);
				w++;
			}
			else
				printf("*Error*\n");
		}
		for (chHz[1] = 0xA1; chHz[1] <= 0xFE; chHz[1]++)
		{
			nHzcode = ((JINT)chHz[0] << 8) + (JINT)chHz[1];
			nYj     = Big5HzcodeToYjcode(nHzcode);
			printf("0x%02x%02x %s ", (JUINT)chHz[0], (JUINT)chHz[1], chHz);
			if (nYj == 0x01FF)
				printf("[NONE]\n");
			else if ((nYj >= 0) && (nYj < NUM_YINJIE ))
			{
				printf("%s\n", YINJIESTR_CSZ[nYj]);
				w++;
			}
			else
				printf("*Error*\n");
		}
	}
	for (chHz[0] = 0xC6; chHz[0] <= 0xC6; chHz[0]++)
	{
		for (chHz[1] = 0x40; chHz[1] <= 0x7E; chHz[1]++)
		{
			nHzcode = ((JINT)chHz[0] << 8) + (JINT)chHz[1];
			nYj     = Big5HzcodeToYjcode(nHzcode);
			printf("0x%02x%02x %s ", (JUINT)chHz[0], (JUINT)chHz[1], chHz);
			if (nYj == 0x01FF)
				printf("[NONE]\n");
			else if ((nYj >= 0) && (nYj < NUM_YINJIE ))
			{
				printf("%s\n", YINJIESTR_CSZ[nYj]);
				w++;
			}
			else
				printf("*Error*\n");
		}

	}
	for (chHz[0] = 0xC9; chHz[0] <= 0xF8; chHz[0]++)
	{
		for (chHz[1] = 0x40; chHz[1] <= 0x7E; chHz[1]++)
		{
			nHzcode = ((JINT)chHz[0] << 8) + (JINT)chHz[1];
			nYj     = Big5HzcodeToYjcode(nHzcode);
			printf("0x%02x%02x %s ", (JUINT)chHz[0], (JUINT)chHz[1], chHz);
			if (nYj == 0x01FF)
				printf("[NONE]\n");
			else if ((nYj >= 0) && (nYj < NUM_YINJIE ))
			{
				printf("%s\n", YINJIESTR_CSZ[nYj]);
				w++;
			}
			else
				printf("*Error*\n");
		}
		for (chHz[1] = 0xA1; chHz[1] <= 0xFE; chHz[1]++)
		{
			nHzcode = ((JINT)chHz[0] << 8) + (JINT)chHz[1];
			nYj     = Big5HzcodeToYjcode(nHzcode);
			printf("0x%02x%02x %s ", (JUINT)chHz[0], (JUINT)chHz[1], chHz);
			if (nYj == 0x01FF)
				printf("[NONE]\n");
			else if ((nYj >= 0) && (nYj < NUM_YINJIE ))
			{
				printf("%s\n", YINJIESTR_CSZ[nYj]);
				w++;
			}
			else
				printf("*Error*\n");
		}
	}
	for (chHz[0] = 0xF9; chHz[0] <= 0xF9; chHz[0]++)
	{
		for (chHz[1] = 0x40; chHz[1] <= 0x7E; chHz[1]++)
		{
			nHzcode = ((JINT)chHz[0] << 8) + (JINT)chHz[1];
			nYj     = Big5HzcodeToYjcode(nHzcode);
			printf("0x%02x%02x %s ", (JUINT)chHz[0], (JUINT)chHz[1], chHz);
			if (nYj == 0x01FF)
				printf("[NONE]\n");
			else if ((nYj >= 0) && (nYj < NUM_YINJIE ))
			{
				printf("%s\n", YINJIESTR_CSZ[nYj]);
				w++;
			}
			else
				printf("*Error*\n");
		}
		for (chHz[1] = 0xA1; chHz[1] <= 0xDC; chHz[1]++)
		{
			nHzcode = ((JINT)chHz[0] << 8) + (JINT)chHz[1];
			nYj     = Big5HzcodeToYjcode(nHzcode);
			printf("0x%02x%02x %s ", (JUINT)chHz[0], (JUINT)chHz[1], chHz);
			if (nYj == 0x01FF)
				printf("[NONE]\n");
			else if ((nYj >= 0) && (nYj < NUM_YINJIE ))
			{
				printf("%s\n", YINJIESTR_CSZ[nYj]);
				w++;
			}
			else
				printf("*Error*\n");
		}
	}
	printf("Valid Yinjie in BIG5HZCODETOYJ[] is %d", w);
}
*/


