#ifndef __UNICHAR_INFO_H__
#define __UNICHAR_INFO_H__

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define UNICHARTABLE_TYPE           (unichartable_get_type ())
#define UNICHARTABLE(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
                                      UNICHARTABLE_TYPE, UniCharTable))
#define UNICHARTABLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                      UNICHARTABLE_TYPE, UniCharTableClass))
#define IS_UNICHARTABLE(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                      UNICCHARTABLE_TYPE))
#define IS_UNICHARTABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
                                      UNICCHARTABLE_TYPE))
				    

typedef struct _UniCharInfo UniCharInfo;
typedef struct _UniCharInfoClass UniCharInfoClass;

struct _UniCharInfo {
  GtkHBox parent;
  GtkWidget *drawing_area;
  GdkPixmap *pixmap;
  GtkWidget *mybutton;

  GtkObject *adjustment;
  gulong adjustment_changed_handler_id;

  gint n_rows, n_cols;
  
  gunichar begin_char;
  gunichar end_char;
  gunichar first_char;
  gunichar previous_first_char;
  gunichar selected_char;
  gunichar previous_selected_char;

  PangoFontMetrics *pango_fm;
  PangoLayout *pango_layout;
  
  
};

struct _UniCharInfoClass {
  GtkHBoxClass parent_class;
  void (* set_active_char) (UniCharInfo *, guint);
};

GType      unicharinfo_get_type (void);
GtkWidget *unicharinfo_new (void);
void charinfo_table_set_current_character (UniCharInfo *, gunichar);
							      
G_END_DECLS

#define UNICHAR_MAX 0xffff

#endif /* #ifndef __UNICHAR_INFO_H__ */
