#ifndef  __VIRTUAL_KEYBOARHD_H__
#define  __VIRTUAL_KEYBOARHD_H__

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "keyboard_config.h"

G_BEGIN_DECLS

#define VIRTUAL_KEYBOARD_TYPE           (virtual_keyboard_get_type ())
#define VIRTUAL_KEYBOARD(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
                                      VIRTUAL_KEYBOARD_TYPE, VirtualKeyboard))
#define VIRTUAL_KEYBOARD_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                      VIRTUAL_KEYBOARD_TYPE, VirtualKeyboardClass))
#define IS_VIRTUAL_KEYBOARD(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                      VIRTUAL_KEYBOARD_TYPE))
#define IS_VIRTUAL_KEYBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
                                      VIRTUAL_KEYBOARD_TYPE))
				    

typedef struct _VirtualKeyboard VirtualKeyboard;
typedef struct _VirtualKeyboardClass VirtualKeyboardClass;

struct _VirtualKeyboard {
  GtkHBox parent;
  GtkWidget *drawing_area;
  GdkPixmap *pixmap;
  GdkRectangle 	buttons[MAX_VK_NUM];
  gint keyboard_layout_count;
  KeyboardLayout **keyboard_layout;

  GtkWidget *popup_menu;
  
  gint width, height;
  gint nKeyboardID;
  gint n_pressed_button_id;

  
  gint nCtrlKey_Status  :2;
  gint nShiftKey_Status :2;
  gint nAltKey_Status   :2;
  gint nCapsLockKey_Status   :2;
  
  PangoLayout *pango_layout;  
  PangoFontMetrics *font_metrics;
};

struct _VirtualKeyboardClass {
  GtkHBoxClass parent_class;
  
};

GType      virtual_keyboard_get_type (void);
GtkWidget *virtual_keyboard_new (void);
GtkWidget *virtual_keyboard_new_with_keyboard_layout (int count, KeyboardLayout **li);
void virtual_keyboard_append_keyboard_layout (VirtualKeyboard *obj, KeyboardLayout *i);

void virtual_keyboard_set_keyboard_layout (VirtualKeyboard *obj, gint i);
G_END_DECLS


#endif /* #ifndef __VIRTUAL_KEYBOARHD_H__ */


