/* $Id: im-connect-reply.c,v 1.1.1.1 2002/08/31 04:18:05 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_connect_reply_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_string *	language_list)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_CONNECT_REPLY;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.connect_reply.language = language_list;
    return m;
}


void
iiimp_connect_reply_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_string_list_delete(data_s, m->v.connect_reply.language);
    free(m);
    return;
}


uchar_t *
iiimp_connect_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_string *	language_list,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;
    size_t		lang_nbyte;
    IIIMP_string *	l;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* byte length of list of language names */
    for (lang_nbyte = 0, l = language_list; NULL != l; l = l->next) {
	lang_nbyte += l->nbyte;
    }
    nbyte += lang_nbyte;	/* client auth protocol names */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_CONNECT_REPLY, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(lang_nbyte, rest, p, data_s->byte_swap);
    iiimp_string_list_pack(data_s, language_list, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_connect_reply_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *		m;
    IIIMP_connect_reply_v *	v;
    size_t			rest;
    const uchar_t *		p;
    int				len;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.connect_reply);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;

    GET16(len, rest, p, data_s->byte_swap);

    if ((len < 0) || (0 != (len & 0x03)) || (rest < len)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    v->language = iiimp_string_list_unpack(data_s, &rest, &p, len);
    if (NULL == v->language) {
	free(m);
	return NULL;
    }

    *nbyte = 0;
    *ptr = p;

    return m;
}


void
iiimp_connect_reply_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, -1);
    (void)fprintf(data_s->print_fp, "\tlanguage_list=(");
    iiimp_string_list_print(data_s, m->v.connect_reply.language);
    (void)fprintf(data_s->print_fp, ")\n");
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
