/* $Id: im-message.c,v 1.1.1.1 2002/08/31 04:18:06 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"
#include "iiimp-message.h"
#include "print-misc.h"


static IIIMP_message_delete_func message_delete_func[] = {
	iiimp_invalid_message_delete,	/* 0 */

	iiimp_connect_delete,		/* IM_CONNECT */
	iiimp_connect_reply_delete,	/* IM_CONNECT_REPLY */
	iiimp_simple_delete,		/* IM_DISCONNECT */
	iiimp_simple_delete,		/* IM_DISCONNECT_REPLY */
	iiimp_register_trigger_keys_delete,
	/* IM_REGISTER_TRIGGER_KEYS */
	iiimp_trigger_notify_delete,	/* IM_TRIGGER_NOTIFY */
	iiimp_simple_delete,		/* IM_TRIGGER_NOTIFY_REPLY */
	iiimp_setimvalues_delete,	/* IM_SETIMVALUES */
	iiimp_simple_delete,		/* IM_SETIMVALUES_REPLY */
	iiimp_getimvalues_delete,	/* IM_GETIMVALUES */
	iiimp_getimvalues_reply_delete,	/* IM_GETIMVALUES_REPLY */

	iiimp_forward_event_delete,	/* IM_FORWARD_EVENT */
	iiimp_simple_delete,		/* IM_FORWARD_EVENT_REPLY */
	iiimp_commit_string_delete,	/* IM_COMMIT_STRING */
	iiimp_forward_event_with_operations_delete,
	/* IM_FORWARD_EVENT_WITH_OPERATIONS */
	iiimp_forward_event_with_operations_reply_delete,
	/* IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY */
	iiimp_register_hotkeys_delete,
	/* IM_REGISTER_HOTKEYS */
	iiimp_hotkey_notify_delete,	/* IM_HOTKEY_NOTIFY */
	iiimp_simple_delete,		/* IM_HOTKEY_NOTIFY_REPLY */

	iiimp_createic_delete,		/* IM_CREATEIC */
	iiimp_simple_delete,		/* IM_CREATEIC_REPLY */
	iiimp_simple_delete,		/* IM_DESTROYIC */
	iiimp_simple_delete,		/* IM_DESTROYIC_REPLY */
	iiimp_seticvalues_delete,	/* IM_SETICVALUES */
	iiimp_simple_delete,		/* IM_SETICVALUES_REPLY */
	iiimp_geticvalues_delete,	/* IM_GETICVALUES */
	iiimp_geticvalues_reply_delete,	/* IM_GETICVALUES_REPLY */
	iiimp_simple_delete,		/* IM_SETICFOCUS */
	iiimp_simple_delete,		/* IM_SETICFOCUS_REPLY */
	iiimp_simple_delete,		/* IM_UNSETICFOCUS */
	iiimp_simple_delete,		/* IM_UNSETICFOCUS_REPLY */
	iiimp_simple_delete,		/* IM_RESETIC */
	iiimp_simple_delete,		/* IM_RESETIC_REPLY */

	iiimp_hotkey_state_notify_delete,	/* IM_HOTKEY_STATE_NOTIFY */
	iiimp_simple_delete,	/* IM_HOTKEY_STATE_NOTIFY_REPLY */
	iiimp_invalid_message_delete,	/* 36 */
	iiimp_invalid_message_delete,	/* 37 */
	iiimp_invalid_message_delete,	/* 38 */
	iiimp_invalid_message_delete,	/* 39 */

	iiimp_simple_delete,		/* IM_PREEDIT_START */
	iiimp_preedit_start_reply_delete,
	/* IM_PREEDIT_START_REPLY */
	iiimp_preedit_draw_delete,	/* IM_PREEDIT_DRAW */
	iiimp_simple_delete,		/* IM_PREEDIT_DRAW_REPLY */
	iiimp_invalid_message_delete,	/* 44 */
	iiimp_invalid_message_delete,	/* 45 */
	iiimp_simple_delete,		/* IM_PREEDIT_DONE */
	iiimp_simple_delete,		/* IM_PREEDIT_DONE_REPLY */

	iiimp_invalid_message_delete,	/* 48 */
	iiimp_invalid_message_delete,	/* 49 */

	iiimp_simple_delete,		/* IM_STATUS_START */
	iiimp_simple_delete,		/* IM_STATUS_START_REPLY */
	iiimp_status_draw_delete,	/* IM_STATUS_DRAW */
	iiimp_simple_delete,		/* IM_STATUS_DRAW_REPLY */
	iiimp_simple_delete,		/* IM_STATUS_DONE */
	iiimp_simple_delete,		/* IM_STATUS_DONE_REPLY */

	iiimp_invalid_message_delete,	/* 56 */
	iiimp_invalid_message_delete,	/* 57 */
	iiimp_invalid_message_delete,	/* 58 */
	iiimp_invalid_message_delete,	/* 59 */
	iiimp_invalid_message_delete,	/* 60 */
	iiimp_invalid_message_delete,	/* 61 */
	iiimp_invalid_message_delete,	/* 62 */
	iiimp_invalid_message_delete,	/* 63 */
	iiimp_invalid_message_delete,	/* 64 */
	iiimp_invalid_message_delete,	/* 65 */
	iiimp_invalid_message_delete,	/* 66 */
	iiimp_invalid_message_delete,	/* 67 */
	iiimp_invalid_message_delete,	/* 68 */
	iiimp_invalid_message_delete,	/* 69 */

	iiimp_lookup_choice_start_delete,
	/* IM_LOOKUP_CHOICE_START */
	iiimp_simple_delete,		/* IM_LOOKUP_CHOICE_START_REPLY */
	iiimp_lookup_choice_draw_delete,/* IM_LOOKUP_CHOICE_DRAW */
	iiimp_simple_delete,		/* IM_LOOKUP_CHOICE_DRAW_REPLY */
	iiimp_simple_delete,		/* IM_LOOKUP_CHOICE_DONE */
	iiimp_simple_delete,		/* IM_LOOKUP_CHOICE_DONE_REPLY */
	iiimp_lookup_choice_process_delete,
	/* IM_LOOKUP_CHOICE_PROCESS */
	iiimp_simple_delete,		/* IM_LOOKUP_CHOICE_PROCESS_REPLY */

	iiimp_invalid_message_delete,	/* 78 */
	iiimp_invalid_message_delete,	/* 79 */
	iiimp_invalid_message_delete,	/* 80 */
	iiimp_invalid_message_delete,	/* 81 */
	iiimp_invalid_message_delete,	/* 82 */
	iiimp_invalid_message_delete,	/* 83 */
	iiimp_invalid_message_delete,	/* 84 */
	iiimp_invalid_message_delete,	/* 85 */
	iiimp_invalid_message_delete,	/* 86 */
	iiimp_invalid_message_delete,	/* 87 */
	iiimp_invalid_message_delete,	/* 88 */
	iiimp_invalid_message_delete,	/* 89 */

	iiimp_aux_simple_delete,	/* IM_AUX_START */
	iiimp_aux_simple_delete,	/* IM_AUX_START_REPLY */
	iiimp_aux_value_delete,		/* IM_AUX_DRAW */
	iiimp_aux_simple_delete,	/* IM_AUX_DRAW_REPLY */
	iiimp_aux_simple_delete,	/* IM_AUX_DONE */
	iiimp_aux_simple_delete,	/* IM_AUX_DONE_REPLY */
	iiimp_aux_value_delete,		/* IM_AUX_SETVALUES */
	iiimp_aux_simple_delete,	/* IM_AUX_SETVALUES_REPLY */
	iiimp_aux_value_delete,		/* IM_AUX_GETVALUES */
	iiimp_aux_value_delete,		/* IM_AUX_GETVALUES_REPLY */

	iiimp_protocol_version_delete,	/* IM_PROTOCOL_VERSION */

	iiimp_invalid_message_delete,	/* 101 */
	iiimp_invalid_message_delete,	/* 102 */
	iiimp_invalid_message_delete,	/* 103 */
	iiimp_invalid_message_delete,	/* 104 */
	iiimp_invalid_message_delete,	/* 105 */
	iiimp_invalid_message_delete,	/* 106 */
	iiimp_invalid_message_delete,	/* 107 */
	iiimp_invalid_message_delete,	/* 108 */
	iiimp_invalid_message_delete,	/* 109 */
	iiimp_invalid_message_delete,	/* 110 */
	iiimp_invalid_message_delete,	/* 111 */
	iiimp_invalid_message_delete,	/* 112 */
	iiimp_invalid_message_delete,	/* 113 */
	iiimp_invalid_message_delete,	/* 114 */
	iiimp_invalid_message_delete,	/* 115 */
	iiimp_invalid_message_delete,	/* 116 */
	iiimp_invalid_message_delete,	/* 117 */
	iiimp_invalid_message_delete,	/* 118 */
	iiimp_invalid_message_delete,	/* 119 */
	iiimp_invalid_message_delete,	/* 120 */
	iiimp_invalid_message_delete,	/* 121 */
	iiimp_invalid_message_delete,	/* 122 */
	iiimp_invalid_message_delete,	/* 123 */
	iiimp_invalid_message_delete,	/* 124 */
	iiimp_invalid_message_delete,	/* 125 */
	iiimp_invalid_message_delete,	/* 126 */
	iiimp_invalid_message_delete	/* 127 */
};


void
iiimp_message_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    (message_delete_func[m->opcode & 0x7f])(data_s, m);
    return;
}


uchar_t *
iiimp_message_pack(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m,
    size_t *		nbyte)
{
    uchar_t *	p;

    switch (m->opcode) {
      case IM_DISCONNECT:
      case IM_DISCONNECT_REPLY:
      case IM_TRIGGER_NOTIFY_REPLY:
      case IM_HOTKEY_NOTIFY_REPLY:
      case IM_SETIMVALUES_REPLY:
      case IM_FORWARD_EVENT_REPLY:
      case IM_CREATEIC_REPLY:
      case IM_DESTROYIC:
      case IM_DESTROYIC_REPLY:
      case IM_SETICVALUES_REPLY:
      case IM_SETICFOCUS:
      case IM_SETICFOCUS_REPLY:
      case IM_UNSETICFOCUS:
      case IM_UNSETICFOCUS_REPLY:
      case IM_RESETIC:
      case IM_RESETIC_REPLY:
      case IM_PREEDIT_START:
      case IM_PREEDIT_DRAW_REPLY:
      case IM_PREEDIT_DONE:
      case IM_PREEDIT_DONE_REPLY:
      case IM_STATUS_START:
      case IM_STATUS_START_REPLY:
      case IM_STATUS_DRAW_REPLY:
      case IM_STATUS_DONE:
      case IM_STATUS_DONE_REPLY:
      case IM_LOOKUP_CHOICE_START_REPLY:
      case IM_LOOKUP_CHOICE_DRAW_REPLY:
      case IM_LOOKUP_CHOICE_DONE:
      case IM_LOOKUP_CHOICE_DONE_REPLY:
      case IM_LOOKUP_CHOICE_PROCESS_REPLY:
       p = iiimp_simple_pack(data_s, m->opcode, m->im_id, m->ic_id, nbyte);
       break;

      case IM_CONNECT:
       p = iiimp_connect_pack(data_s, m->v.connect.user_name,
			      m->v.connect.auth, nbyte);
       break;

      case IM_CONNECT_REPLY:
       p = iiimp_connect_reply_pack(data_s, m->im_id,
				    m->v.connect_reply.language, nbyte);
       break;

      case IM_REGISTER_TRIGGER_KEYS:
       p = iiimp_register_trigger_keys_pack(
	   data_s, m->im_id,
	   m->v.register_trigger_keys.trigger_on,
	   m->v.register_trigger_keys.trigger_off, nbyte);
       break;

      case IM_TRIGGER_NOTIFY:
       p = iiimp_trigger_notify_pack(data_s, m->im_id, m->ic_id,
				     m->v.trigger_notify.flag, nbyte);
       break;

      case IM_REGISTER_HOTKEYS:
       p = iiimp_register_hotkeys_pack(
	   data_s, m->im_id, m->v.register_hotkeys.flag,
	   m->v.register_hotkeys.hotkeys, nbyte);
       break;

      case IM_HOTKEY_NOTIFY:
       p = iiimp_hotkey_notify_pack(data_s, m->im_id, m->ic_id,
				    m->v.hotkey_notify.hotkey_id, 
				    m->v.hotkey_notify.index,nbyte);
       break;

      case IM_HOTKEY_STATE_NOTIFY:
       p = iiimp_hotkey_state_notify_pack(data_s, m->im_id, m->ic_id,
				    m->v.hotkey_state_notify.hotkey_id,
				    m->v.hotkey_state_notify.current_state_flag,nbyte);
       break;

      case IM_SETIMVALUES:
       p = iiimp_setimvalues_pack(data_s, m->im_id,
				  m->v.setimvalues.attr_list, nbyte);
       break;

      case IM_GETIMVALUES:
       p = iiimp_getimvalues_pack(data_s, m->im_id,
				  m->v.getimvalues.attr_list, nbyte);
       break;

      case IM_GETIMVALUES_REPLY:
       p = iiimp_getimvalues_reply_pack(data_s, m->im_id,
					m->v.getimvalues_reply.attr_list,
					nbyte);
       break;

      case IM_FORWARD_EVENT:
       p = iiimp_forward_event_pack(data_s, m->im_id, m->ic_id,
				    m->v.forward_event.contents,
				    nbyte);
       break;

      case IM_COMMIT_STRING:
       p = iiimp_commit_string_pack(data_s, m->im_id, m->ic_id,
				    m->v.commit_string.contents,
				    nbyte);
       break;

      case IM_FORWARD_EVENT_WITH_OPERATIONS:
       p = iiimp_forward_event_with_operations_pack(
	   data_s, m->im_id, m->ic_id,
	   m->v.forward_event_with_operations.contents,
	   m->v.forward_event_with_operations.operation, nbyte);
       break;

      case IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY:
       p = iiimp_forward_event_with_operations_reply_pack(
	   data_s, m->im_id, m->ic_id,
	   m->v.forward_event_with_operations_reply.operation,
	   nbyte);
       break;

      case IM_CREATEIC:
       p = iiimp_createic_pack(data_s, m->im_id,
			       m->v.createic.attr_list, nbyte);
       break;

      case IM_SETICVALUES:
       p = iiimp_seticvalues_pack(data_s, m->im_id, m->ic_id,
				  m->v.seticvalues.attr_list, nbyte);
       break;

      case IM_GETICVALUES:
       p = iiimp_geticvalues_pack(data_s, m->im_id, m->ic_id,
				  m->v.geticvalues.attr_list, nbyte);
       break;

      case IM_GETICVALUES_REPLY:
       p = iiimp_geticvalues_reply_pack(data_s, m->im_id, m->ic_id,
					m->v.geticvalues_reply.attr_list,
					nbyte);
       break;

      case IM_PREEDIT_START_REPLY:
       p = iiimp_preedit_start_reply_pack(
	   data_s, m->im_id, m->ic_id,
	   m->v.preedit_start_reply.maximum_length, nbyte);
       break;

      case IM_PREEDIT_DRAW:
       p = iiimp_preedit_draw_pack(data_s, m->im_id, m->ic_id,
				   m->v.preedit_draw.caret,
				   m->v.preedit_draw.change_first,
				   m->v.preedit_draw.change_length,
				   m->v.preedit_draw.preedit,
				   nbyte);
       break;

      case IM_STATUS_DRAW:
       p = iiimp_status_draw_pack(data_s, m->im_id, m->ic_id,
				  m->v.status_draw.status, nbyte);
       break;

      case IM_LOOKUP_CHOICE_START:
       p = iiimp_lookup_choice_start_pack(
	   data_s, m->im_id, m->ic_id,
	   m->v.lookup_choice_start.master,
	   m->v.lookup_choice_start.choice_per_window,
	   m->v.lookup_choice_start.rows,
	   m->v.lookup_choice_start.columns,
	   m->v.lookup_choice_start.direction,
	   m->v.lookup_choice_start.label_owner,
	   nbyte);
       break;

      case IM_LOOKUP_CHOICE_DRAW:
       p = iiimp_lookup_choice_draw_pack(data_s, m->im_id, m->ic_id,
					 m->v.lookup_choice_draw.first,
					 m->v.lookup_choice_draw.last,
					 m->v.lookup_choice_draw.current,
					 m->v.lookup_choice_draw.choice,
					 m->v.lookup_choice_draw.index_label,
					 m->v.lookup_choice_draw.title, nbyte);
       break;

      case IM_LOOKUP_CHOICE_PROCESS:
       p = iiimp_lookup_choice_process_pack(data_s, m->im_id, m->ic_id,
					    m->v.lookup_choice_process.type,
					    m->v.lookup_choice_process.value,
					    nbyte);
       break;

      case IM_AUX_START:
      case IM_AUX_START_REPLY:
      case IM_AUX_DRAW_REPLY:
      case IM_AUX_DONE_REPLY:
      case IM_AUX_DONE:
      case IM_AUX_SETVALUES_REPLY:
       p = iiimp_aux_simple_pack(data_s, m->opcode, m->im_id, m->ic_id,
				 m->v.aux_simple.class_index,
				 m->v.aux_simple.input_method_name,
				 nbyte);
       break;

      case IM_AUX_DRAW:
      case IM_AUX_SETVALUES:
      case IM_AUX_GETVALUES:
      case IM_AUX_GETVALUES_REPLY:
       p = iiimp_aux_value_pack(data_s, m->opcode, m->im_id, m->ic_id,
				m->v.aux_value.class_index,
				m->v.aux_value.input_method_name,
				m->v.aux_value.integer_value,
				m->v.aux_value.string_value,
				nbyte);
       break;

      case IM_PROTOCOL_VERSION:
       p = iiimp_protocol_version_pack(data_s, m->im_id,
				       m->v.protocol_version.number,
				       nbyte);
       break;

      default:
       p = NULL;
       data_s->status = IIIMP_DATA_INVALID;
    }

    return p;
}


static IIIMP_message_unpack_func message_unpack_func[] = {
	iiimp_invalid_message_unpack,	/* 0 */

	iiimp_connect_unpack,		/* IM_CONNECT */
	iiimp_connect_reply_unpack,	/* IM_CONNECT_REPLY */
	iiimp_simple_im_unpack,		/* IM_DISCONNECT */
	iiimp_simple_im_unpack,		/* IM_DISCONNECT_REPLY */
	iiimp_register_trigger_keys_unpack,
	/* IM_REGISTER_TRIGGER_KEYS */
	iiimp_trigger_notify_unpack,	/* IM_TRIGGER_NOTIFY */
	iiimp_simple_unpack,		/* IM_TRIGGER_NOTIFY_REPLY */
	iiimp_setimvalues_unpack,	/* IM_SETIMVALUES */
	iiimp_simple_im_unpack,		/* IM_SETIMVALUES_REPLY */
	iiimp_getimvalues_unpack,	/* IM_GETIMVALUES */
	iiimp_getimvalues_reply_unpack,	/* IM_GETIMVALUES_REPLY */

	iiimp_forward_event_unpack,	/* IM_FORWARD_EVENT */
	iiimp_simple_unpack,		/* IM_FORWARD_EVENT_REPLY */
	iiimp_commit_string_unpack,	/* IM_COMMIT_STRING */
	iiimp_forward_event_with_operations_unpack,
	/* IM_FORWARD_EVENT_WITH_OPERATIONS */
	iiimp_forward_event_with_operations_reply_unpack,
	/* IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY */

	iiimp_register_hotkeys_unpack,
	/* IM_REGISTER_HOTKEYS */
	iiimp_hotkey_notify_unpack,	/* IM_HOTKEY_NOTIFY */
	iiimp_simple_unpack,		/* IM_HOTKEY_NOTIFY_REPLY */

	iiimp_createic_unpack,		/* IM_CREATEIC */
	iiimp_simple_unpack,		/* IM_CREATEIC_REPLY */
	iiimp_simple_unpack,		/* IM_DESTROYIC */
	iiimp_simple_unpack,		/* IM_DESTROYIC_REPLY */
	iiimp_seticvalues_unpack,	/* IM_SETICVALUES */
	iiimp_simple_unpack,		/* IM_SETICVALUES_REPLY */
	iiimp_geticvalues_unpack,	/* IM_GETICVALUES */
	iiimp_geticvalues_reply_unpack,	/* IM_GETICVALUES_REPLY */
	iiimp_simple_unpack,		/* IM_SETICFOCUS */
	iiimp_simple_unpack,		/* IM_SETICFOCUS_REPLY */
	iiimp_simple_unpack,		/* IM_UNSETICFOCUS */
	iiimp_simple_unpack,		/* IM_UNSETICFOCUS_REPLY */
	iiimp_simple_unpack,		/* IM_RESETIC */
	iiimp_simple_unpack,		/* IM_RESETIC_REPLY */

	iiimp_hotkey_state_notify_unpack,	/* IM_HOTKEY_STATE_NOTIFY */
	iiimp_simple_unpack,	/* IM_HOTKEY_STATE_NOTIFY_REPLY */
	iiimp_invalid_message_unpack,	/* 36 */
	iiimp_invalid_message_unpack,	/* 37 */
	iiimp_invalid_message_unpack,	/* 38 */
	iiimp_invalid_message_unpack,	/* 39 */

	iiimp_simple_unpack,		/* IM_PREEDIT_START */
	iiimp_preedit_start_reply_unpack,
	/* IM_PREEDIT_START_REPLY */
	iiimp_preedit_draw_unpack,	/* IM_PREEDIT_DRAW */
	iiimp_simple_unpack,		/* IM_PREEDIT_DRAW_REPLY */
	iiimp_invalid_message_unpack,	/* 44 */
	iiimp_invalid_message_unpack,	/* 45 */
	iiimp_simple_unpack,		/* IM_PREEDIT_DONE */
	iiimp_simple_unpack,		/* IM_PREEDIT_DONE_REPLY */

	iiimp_invalid_message_unpack,	/* 48 */
	iiimp_invalid_message_unpack,	/* 49 */

	iiimp_simple_unpack,		/* IM_STATUS_START */
	iiimp_simple_unpack,		/* IM_STATUS_START_REPLY */
	iiimp_status_draw_unpack,	/* IM_STATUS_DRAW */
	iiimp_simple_unpack,		/* IM_STATUS_DRAW_REPLY */
	iiimp_simple_unpack,		/* IM_STATUS_DONE */
	iiimp_simple_unpack,		/* IM_STATUS_DONE_REPLY */

	iiimp_invalid_message_unpack,	/* 56 */
	iiimp_invalid_message_unpack,	/* 57 */
	iiimp_invalid_message_unpack,	/* 58 */
	iiimp_invalid_message_unpack,	/* 59 */
	iiimp_invalid_message_unpack,	/* 60 */
	iiimp_invalid_message_unpack,	/* 61 */
	iiimp_invalid_message_unpack,	/* 62 */
	iiimp_invalid_message_unpack,	/* 63 */
	iiimp_invalid_message_unpack,	/* 64 */
	iiimp_invalid_message_unpack,	/* 65 */
	iiimp_invalid_message_unpack,	/* 66 */
	iiimp_invalid_message_unpack,	/* 67 */
	iiimp_invalid_message_unpack,	/* 68 */
	iiimp_invalid_message_unpack,	/* 69 */

	iiimp_lookup_choice_start_unpack,
	/* IM_LOOKUP_CHOICE_START */
	iiimp_simple_unpack,		/* IM_LOOKUP_CHOICE_START_REPLY */
	iiimp_lookup_choice_draw_unpack,/* IM_LOOKUP_CHOICE_DRAW */
	iiimp_simple_unpack,		/* IM_LOOKUP_CHOICE_DRAW_REPLY */
	iiimp_simple_unpack,		/* IM_LOOKUP_CHOICE_DONE */
	iiimp_simple_unpack,		/* IM_LOOKUP_CHOICE_DONE_REPLY */
	iiimp_lookup_choice_process_unpack,
	/* IM_LOOKUP_CHOICE_PROCESS */
	iiimp_simple_unpack,		/* IM_LOOKUP_CHOICE_PROCESS_REPLY */

	iiimp_invalid_message_unpack,	/* 78 */
	iiimp_invalid_message_unpack,	/* 79 */
	iiimp_invalid_message_unpack,	/* 80 */
	iiimp_invalid_message_unpack,	/* 81 */
	iiimp_invalid_message_unpack,	/* 82 */
	iiimp_invalid_message_unpack,	/* 83 */
	iiimp_invalid_message_unpack,	/* 84 */
	iiimp_invalid_message_unpack,	/* 85 */
	iiimp_invalid_message_unpack,	/* 86 */
	iiimp_invalid_message_unpack,	/* 87 */
	iiimp_invalid_message_unpack,	/* 88 */
	iiimp_invalid_message_unpack,	/* 89 */

	iiimp_aux_simple_unpack,	/* IM_AUX_START */
	iiimp_aux_simple_unpack,	/* IM_AUX_START_REPLY */
	iiimp_aux_value_unpack,		/* IM_AUX_DRAW */
	iiimp_aux_simple_unpack,	/* IM_AUX_DRAW_REPLY */
	iiimp_aux_simple_unpack,	/* IM_AUX_DONE */
	iiimp_aux_simple_unpack,	/* IM_AUX_DONE_REPLY */
	iiimp_aux_value_unpack,		/* IM_AUX_SETVALUES */
	iiimp_aux_simple_unpack,	/* IM_AUX_SETVALUES_REPLY */
	iiimp_aux_value_unpack,		/* IM_AUX_GETVALUES */
	iiimp_aux_value_unpack,		/* IM_AUX_GETVALUES_REPLY */

	iiimp_protocol_version_unpack,	/* IM_PROTOCOL_VERSION */

	iiimp_invalid_message_unpack,	/* 101 */
	iiimp_invalid_message_unpack,	/* 102 */
	iiimp_invalid_message_unpack,	/* 103 */
	iiimp_invalid_message_unpack,	/* 104 */
	iiimp_invalid_message_unpack,	/* 105 */
	iiimp_invalid_message_unpack,	/* 106 */
	iiimp_invalid_message_unpack,	/* 107 */
	iiimp_invalid_message_unpack,	/* 108 */
	iiimp_invalid_message_unpack,	/* 109 */
	iiimp_invalid_message_unpack,	/* 110 */
	iiimp_invalid_message_unpack,	/* 111 */
	iiimp_invalid_message_unpack,	/* 112 */
	iiimp_invalid_message_unpack,	/* 113 */
	iiimp_invalid_message_unpack,	/* 114 */
	iiimp_invalid_message_unpack,	/* 115 */
	iiimp_invalid_message_unpack,	/* 116 */
	iiimp_invalid_message_unpack,	/* 117 */
	iiimp_invalid_message_unpack,	/* 118 */
	iiimp_invalid_message_unpack,	/* 119 */
	iiimp_invalid_message_unpack,	/* 120 */
	iiimp_invalid_message_unpack,	/* 121 */
	iiimp_invalid_message_unpack,	/* 122 */
	iiimp_invalid_message_unpack,	/* 123 */
	iiimp_invalid_message_unpack,	/* 124 */
	iiimp_invalid_message_unpack,	/* 125 */
	iiimp_invalid_message_unpack,	/* 126 */
	iiimp_invalid_message_unpack	/* 127 */
};


IIIMP_message *
iiimp_message_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    return (message_unpack_func[opcode & 0x7f])(data_s, opcode, nbyte, ptr);
}


void
iiimp_message_header_print(
    IIIMP_data_s *	data_s,
    int		opcode,
    int		im_id,
    int		ic_id)
{
    if (im_id < 0) {
	(void)fprintf(data_s->print_fp, ":*:*:");
    } else if (ic_id < 0) {
	(void)fprintf(data_s->print_fp, ":%d:*:", im_id);
    } else {
	(void)fprintf(data_s->print_fp, ":%d:%d:", im_id, ic_id);
    }
    (void)fprintf(data_s->print_fp, " %s\n", opcode_string_get(opcode));
}


typedef void
(* IIIMP_message_print_func)(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m);

static IIIMP_message_print_func message_print_func[] = {
	iiimp_invalid_message_print,	/* 0 */

	iiimp_connect_print,		/* IM_CONNECT */
	iiimp_connect_reply_print,	/* IM_CONNECT_REPLY */
	iiimp_simple_im_print,		/* IM_DISCONNECT */
	iiimp_simple_im_print,		/* IM_DISCONNECT_REPLY */
	iiimp_register_trigger_keys_print,
	/* IM_REGISTER_TRIGGER_KEYS */
	iiimp_trigger_notify_print,	/* IM_TRIGGER_NOTIFY */
	iiimp_simple_print,		/* IM_TRIGGER_NOTIFY_REPLY */
	iiimp_setimvalues_print,	/* IM_SETIMVALUES */
	iiimp_simple_im_print,		/* IM_SETIMVALUES_REPLY */
	iiimp_getimvalues_print,	/* IM_GETIMVALUES */
	iiimp_getimvalues_reply_print,	/* IM_GETIMVALUES_REPLY */

	iiimp_forward_event_print,	/* IM_FORWARD_EVENT */
	iiimp_simple_print,		/* IM_FORWARD_EVENT_REPLY */
	iiimp_commit_string_print,	/* IM_COMMIT_STRING */
	iiimp_forward_event_with_operations_print,
	/* IM_FORWARD_EVENT_WITH_OPERATIONS */
	iiimp_forward_event_with_operations_reply_print,
	/* IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY */

	iiimp_register_hotkeys_print,
	/* IM_REGISTER_HOTKEYS */
	iiimp_hotkey_notify_print,	/* IM_HOTKEY_NOTIFY */
	iiimp_simple_print,		/* IM_HOTKEY_NOTIFY_REPLY */

	iiimp_createic_print,		/* IM_CREATEIC */
	iiimp_simple_print,		/* IM_CREATEIC_REPLY */
	iiimp_simple_print,		/* IM_DESTROYIC */
	iiimp_simple_print,		/* IM_DESTROYIC_REPLY */
	iiimp_seticvalues_print,	/* IM_SETICVALUES */
	iiimp_simple_print,		/* IM_SETICVALUES_REPLY */
	iiimp_geticvalues_print,	/* IM_GETICVALUES */
	iiimp_geticvalues_reply_print,	/* IM_GETICVALUES_REPLY */
	iiimp_simple_print,		/* IM_SETICFOCUS */
	iiimp_simple_print,		/* IM_SETICFOCUS_REPLY */
	iiimp_simple_print,		/* IM_UNSETICFOCUS */
	iiimp_simple_print,		/* IM_UNSETICFOCUS_REPLY */
	iiimp_simple_print,		/* IM_RESETIC */
	iiimp_simple_print,		/* IM_RESETIC_REPLY */

	iiimp_hotkey_state_notify_print,	/* IM_HOTKEY_STATE_NOTIFY */
	iiimp_simple_print,	/* IM_HOTKEY_STATE_NOTIFY_REPLY */
	iiimp_invalid_message_print,	/* 36 */
	iiimp_invalid_message_print,	/* 37 */
	iiimp_invalid_message_print,	/* 38 */
	iiimp_invalid_message_print,	/* 39 */

	iiimp_simple_print,		/* IM_PREEDIT_START */
	iiimp_preedit_start_reply_print,/* IM_PREEDIT_START_REPLY */
	iiimp_preedit_draw_print,	/* IM_PREEDIT_DRAW */
	iiimp_simple_print,		/* IM_PREEDIT_DRAW_REPLY */
	iiimp_invalid_message_print,	/* 44 */
	iiimp_invalid_message_print,	/* 45 */
	iiimp_simple_print,		/* IM_PREEDIT_DONE */
	iiimp_simple_print,		/* IM_PREEDIT_DONE_REPLY */

	iiimp_invalid_message_print,	/* 48 */
	iiimp_invalid_message_print,	/* 49 */

	iiimp_simple_print,		/* IM_STATUS_START */
	iiimp_simple_print,		/* IM_STATUS_START_REPLY */
	iiimp_status_draw_print,	/* IM_STATUS_DRAW */
	iiimp_simple_print,		/* IM_STATUS_DRAW_REPLY */
	iiimp_simple_print,		/* IM_STATUS_DONE */
	iiimp_simple_print,		/* IM_STATUS_DONE_REPLY */

	iiimp_invalid_message_print,	/* 56 */
	iiimp_invalid_message_print,	/* 57 */
	iiimp_invalid_message_print,	/* 58 */
	iiimp_invalid_message_print,	/* 59 */
	iiimp_invalid_message_print,	/* 60 */
	iiimp_invalid_message_print,	/* 61 */
	iiimp_invalid_message_print,	/* 62 */
	iiimp_invalid_message_print,	/* 63 */
	iiimp_invalid_message_print,	/* 64 */
	iiimp_invalid_message_print,	/* 65 */
	iiimp_invalid_message_print,	/* 66 */
	iiimp_invalid_message_print,	/* 67 */
	iiimp_invalid_message_print,	/* 68 */
	iiimp_invalid_message_print,	/* 69 */

	iiimp_lookup_choice_start_print,/* IM_LOOKUP_CHOICE_START */
	iiimp_simple_print,		/* IM_LOOKUP_CHOICE_START_REPLY */
	iiimp_lookup_choice_draw_print,	/* IM_LOOKUP_CHOICE_DRAW */
	iiimp_simple_print,		/* IM_LOOKUP_CHOICE_DRAW_REPLY */
	iiimp_simple_print,		/* IM_LOOKUP_CHOICE_DONE */
	iiimp_simple_print,		/* IM_LOOKUP_CHOICE_DONE_REPLY */
	iiimp_lookup_choice_process_print,
	/* IM_LOOKUP_CHOICE_PROCESS */
	iiimp_simple_print,		/* IM_LOOKUP_CHOICE_PROCESS_REPLY */

	iiimp_invalid_message_print,	/* 78 */
	iiimp_invalid_message_print,	/* 79 */
	iiimp_invalid_message_print,	/* 80 */
	iiimp_invalid_message_print,	/* 81 */
	iiimp_invalid_message_print,	/* 82 */
	iiimp_invalid_message_print,	/* 83 */
	iiimp_invalid_message_print,	/* 84 */
	iiimp_invalid_message_print,	/* 85 */
	iiimp_invalid_message_print,	/* 86 */
	iiimp_invalid_message_print,	/* 87 */
	iiimp_invalid_message_print,	/* 88 */
	iiimp_invalid_message_print,	/* 89 */

	iiimp_aux_simple_print,		/* IM_AUX_START */
	iiimp_aux_simple_print,		/* IM_AUX_START_REPLY */
	iiimp_aux_value_print,		/* IM_AUX_DRAW */
	iiimp_aux_simple_print,		/* IM_AUX_DRAW_REPLY */
	iiimp_aux_simple_print,		/* IM_AUX_DONE */
	iiimp_aux_simple_print,		/* IM_AUX_DONE_REPLY */
	iiimp_aux_value_print,		/* IM_AUX_SETVALUES */
	iiimp_aux_simple_print,		/* IM_AUX_SETVALUES_REPLY */
	iiimp_aux_value_print,		/* IM_AUX_GETVALUES */
	iiimp_aux_value_print,		/* IM_AUX_GETVALUES_REPLY */

	iiimp_protocol_version_print,	/* IM_PROTOCOL_VERSION */

	iiimp_invalid_message_print,	/* 101 */
	iiimp_invalid_message_print,	/* 102 */
	iiimp_invalid_message_print,	/* 103 */
	iiimp_invalid_message_print,	/* 104 */
	iiimp_invalid_message_print,	/* 105 */
	iiimp_invalid_message_print,	/* 106 */
	iiimp_invalid_message_print,	/* 107 */
	iiimp_invalid_message_print,	/* 108 */
	iiimp_invalid_message_print,	/* 109 */
	iiimp_invalid_message_print,	/* 110 */
	iiimp_invalid_message_print,	/* 111 */
	iiimp_invalid_message_print,	/* 112 */
	iiimp_invalid_message_print,	/* 113 */
	iiimp_invalid_message_print,	/* 114 */
	iiimp_invalid_message_print,	/* 115 */
	iiimp_invalid_message_print,	/* 116 */
	iiimp_invalid_message_print,	/* 117 */
	iiimp_invalid_message_print,	/* 118 */
	iiimp_invalid_message_print,	/* 119 */
	iiimp_invalid_message_print,	/* 120 */
	iiimp_invalid_message_print,	/* 121 */
	iiimp_invalid_message_print,	/* 122 */
	iiimp_invalid_message_print,	/* 123 */
	iiimp_invalid_message_print,	/* 124 */
	iiimp_invalid_message_print,	/* 125 */
	iiimp_invalid_message_print,	/* 126 */
	iiimp_invalid_message_print	/* 127 */
};


void
iiimp_message_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    if (NULL == m) return;
    (message_print_func[0x7f & m->opcode])(data_s, m);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
