# Time-stamp: <2002-11-09 14:40:12 crabbkw>

# Code and design by Casey Crabb (crabbkw@nafai.dyndns.org)
# This code is licensed under the BSD license.
# See the LICENSE file for details
#
# Copyright Casey Crabb (crabbkw@nafai.dyndns.org) July 2001
#

# Constructors will only take attributes
# sub elements can be inserted by the construction side
# PCDATA will always be stored in .text

# no error checking for now, that can be done later.
class JabberStream:
  def __init__(self,to,ffrom,id):
    self.name = "JabberStream"
    self.to = to
    self.ffrom = ffrom
    self.id = id

class JabberIQ:
  def __init__(self,to,toResource,ffrom,fromResource,id,type):
    self.to = to
    self.toResource = toResource
    self.ffrom = ffrom
    self.fromResource = fromResource
    self.id = id
    self.type = type
    self.ns = None

class JabberPresence:
  def __init__(self,to,ffrom,type, resource, status):
    self.to = to
    self.ffrom = ffrom
    self.type = type
    self.resource = resource
    self.show = None
    self.status = status
    self.priority = 0
    self.mucAffiliation = None
    self.mucRole = None
    self.mucJID = None
    self.mucNick = None
    self.mucCode = None
    self.mucActor = None
    self.createdConference = None

class JabberMessage:
  def __init__(self, to, ffrom, resource, id, type):
    self.to = to
    self.ffrom = ffrom
    self.id = id
    self.type = type
    self.resource = resource
    self.body = None
    self.subject = None
    self.mucInviteFrom = None
    self.mucInviteReason = None
    self.mucInvitePassword = None

class JabberStatus:
  def __init__(self):
    self.text = None
    pass

class JabberPriority:
  def __init__(self):
    pass

class JabberShow:
  def __init__(self):
    pass

class JabberBody:
  def __init__(self):
    self.text = None

class JabberSubject:
  def __init__(self):
    pass

class JabberThread:
  def __init__(self):
    pass

class JabberError:
  def __init__(self, code):
    self.code = code

class JabberIQQueryAuth:
  def __init__(self):
    pass

class JabberIQQueryAuthUsername:
  def __init__(self):
    pass

class JabberIQQueryAuthPassword:
  def __init__(self):
    pass

class JabberIQQueryAuthDigest:
  def __init__(self):
    pass

class JabberIQQueryAuthResource:
  def __init__(self):
    pass

class JabberRoster:
  def __init__(self):
    self.users = []

class JabberRosterItem:
  def __init__(self, jid, name, subscription, ask):
    self.jid = jid
    self.name = name
    self.subscription = subscription
    self.groups = []
    self.ask = ask

class JabberOOB:
  def __init__(self):
    self.url = None
    self.desc = None

class ErrorTag:
  def __init__(self, code):
    self.code = code

class JabberRegister:
  def __init__(self):
    self.fields = []
    self.key = None
    self.instructions = ""
    pass

class JabberRegisterKey:
  def __init__(self):
    pass

class JabberAgentList:
  def __init__(self):
    self.agentlist = []

class JabberAgent:
  def __init__(self, jid):
    self.jid = jid
    self.name = None
    self.transport = None

class JabberTransportRegister:
  def __init__(self):
    self.fields = []

class JabberDummyTag:
  def __init__(self):
    self.text = None
    pass

class JabberAdmin:
  def __init__(self):
    self.w = None

class JabberAdminWho:
  def __init__(self):
    self.presencelist = []

class JabberNegotiateFeature:
  def __init__(self, cat, type):
    self.featureCatagory = cat
    self.featureType     = type
    self.options         = []

class JabberNegotiate:
  def __init__(self):
    self.features = []

class JabberIQQueryJidLink:
  def __init__(self):
    self.key = None
    self.ns = "jabber:iq:jidlink"

class JabberIQQueryDTCP:
  def __init__(self):
    self.key = None
    self.ns = "jabber:iq:dtcp"
    self.verify = None
    self.hosts = [] # contents are [(ip, port), (ip,port),...]
    self.comment = None
    self.jidLinkKey = None

class JabberXDataField:
  def __init__(self):
    self.options = []
    self.value = None
    self.label = None
    self.var = None
    self.required = None
    self.description = None
    self.type = None

class JabberXDataForm:
  def __init__(self):
    self.fields = []
    self.instructions = ""
    self.title = None
