#! perl

&doMakeDef();
exit(0);

sub doMakeDef()
{
    print "####### Generating 'inkscape.def' #######\n";

    my $nmlines = ();  #store lines read in hash, to remove dupes
    my @lines;         #output lines	
    my $line;          #single line of input
    my $datestr;       #current date
    local(*PIPE);      #output of the 'nm' command
    local(*OUTFILE);   #output file - inkscape.def

    open (PIPE, "nm libinkscape.a |");
    while(<PIPE>)
        {
        if ($_ =~ /\./)
            {
            next;
            }
        elsif ($_ =~ /T _/)
            {
            $line = $_;
            $line =~ s/.* T _//;
            $nmlines->{$line} = 1;
            }
        elsif  ($_ =~ /B _/)
            {
            $line = $_;
            $line =~ s/.* B _//;
            $nmlines->{$line} = 1;
            }
        }
    close (PIPE);

    foreach (keys(%{$nmlines}))
        {
        push @lines, $_;
        }
        
    @lines = sort(@lines);

    $datestr = gmtime();
    open (OUTFILE, ">inkscape.def");
    print OUTFILE ";########################################################\n";
    print OUTFILE ";## File: inkscape.def\n";
    print OUTFILE ";## Purpose: Used by dllwrap to make inkscape.dll\n";
    print OUTFILE ";## Generated by makedef.pl at :$datestr\n";
    print OUTFILE ";########################################################\n\n";
    print OUTFILE "LIBRARY\tinkscape.dll\n";
    print OUTFILE "EXPORTS\n";
    foreach (<@lines>)
        {
        # print $_, "\n";
        print OUTFILE "    ", $_, "\n";
        }
    close (OUTFILE);
}
