/***************************************************************************
                          checkpointcmd.cpp  -  description
                             -------------------
    begin                : Sat Apr 21 2001
    copyright            : (C) 2001 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "checkpointcmd.h"


CheckPointCmd::CheckPointCmd( Entity *_e ) : Command()
{
  m_entity = _e;
  m_old = m_entity -> clone();

}
CheckPointCmd::~CheckPointCmd()
{

}

bool CheckPointCmd::undo()
{
  assert( m_entity );

  Entity *temp = m_entity -> clone();
  m_entity -> copyFrom( m_old );
  m_old -> copyFrom( temp );

  delete temp;

  return true;
}
bool CheckPointCmd::execute()
{
  assert( m_entity );

  Entity *temp = m_old -> clone();
  m_old -> copyFrom( m_entity );
  m_entity -> copyFrom( temp );

  delete temp;

  return true;
}
