/***************************************************************************
                          configdialog.h  -  description
                             -------------------
    begin                : Fri Feb 11 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qspinbox.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qdialog.h>

/**
  *@author Jon Anderson
  */

class ConfigDialog : public QDialog  {
   Q_OBJECT
public: 
	ConfigDialog(QWidget *parent=0, const char *name=0);
	~ConfigDialog();

	void init();
	
	QString getTextureDirectory(){return t_dir;};
	QString getPluginDirectory(){return p_dir;};
	QString getSceneDirectory(){return s_dir;};
	
	bool isWireframe(){return wireframe;};
	bool isWireframe3D(){return wireframe_3d;};
	bool isMoveWireframe(){return wireframe_move;};
	bool isSmoothShaded(){return smooth_shaded;};
	bool isSmoothTextures(){return smooth_textures;};
	bool isFilledWireframe(){return wireframe_filled;};
	
	float   getGridSize(){return grid_size;};
	float getGridSpacing(){return grid_spacing;};
	
	void save();
	void load();
	
	void show();
	
	void applySettings();
	void initDefault();

public slots:
	void apply();
	void ok();	
	void slotTextureDir();
	void slotPluginDir();
	void slotSceneDir();
	
protected: 
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QGroupBox *grpDirectories;
	QLineEdit *fldPlugins;
	QPushButton *btnBrowsePlugin;
	QLabel *lblPlugins;
	QPushButton *btnBrowseMaterial;
	QLineEdit *fldMaterials;
	QLabel *lblMaterials;
	QLabel *lblScenes;
	QLineEdit *fldScenes;
	QPushButton *btnBrowseScene;
	QGroupBox *grpDisplay;
	QCheckBox *chkWireMove;
	QCheckBox *chkWireframe;
	QCheckBox *chkSmooth;
	QCheckBox *chk3DWireframe;
	QCheckBox *chkFilledWireframe;
	QCheckBox *chkSmoothTextures;
	QLabel *lblGridSpacing;
	QSpinBox *spnGridSpacing;
	QSpinBox *spnGridSize;
	QLabel *lblGridSize;
	QPushButton *btnOk;
	QPushButton *btnApply;
	QPushButton *btnCancel;
	//Generated area. DO NOT EDIT!!!(end)

private:
	QString t_dir;
	QString p_dir;
	QString s_dir;	
	
	float grid_size;
	float grid_spacing;
	
	bool wireframe_3d;
	bool wireframe_filled;
	bool wireframe_move;
	bool smooth_shaded;
	bool smooth_textures;
	bool wireframe;
	
};

#endif
