/***************************************************************************
                         edge.h  -  description                              
                            -------------------                                         
   begin                : Wed Dec 15 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef EDGE_H
#define EDGE_H

#include "subobject.h"

class Face;

class Vertex;

/**An Edge is a line segment between to vertices.
  *@author Jon Anderson
  */


class Edge : public SubObject
{
   public:
      Edge( Object *p );
      Edge( int v1, int v2, Object *p );
      ~Edge();

      int draw( int d_options = 0 );
      void init();

      Vector4 getNormal();
      Vector4 getUVCenter();

      int divideEdge();
      int getMidpoint();

      Edge & operator=( Edge &rhs );
      bool operator==( Edge &rhs );
      Edge * clone();
      void copyFrom( SubObject * );

      bool isHard() { return m_hard; };

      void setHard( bool s ) { m_hard = s; };

      void toggleHardness() { m_hard = !m_hard; };

      static int TYPE;

   private:
      int t_v1;
      int t_v2;
      bool m_hard;
};

#endif
