/***************************************************************************
                        mesh.h  -  description                              
                           -------------------                                         
  begin                : Wed Dec 15 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MESH_H
#define MESH_H

#include "object.h"

class Face;

/** A Mesh is an object that also contains a collection of faces.
  * @author Jon Anderson
  */

class Mesh : public Object
{
   public:
      Mesh( Entity *p = 0 );
      Mesh( Vector4 &p, Entity *parent = 0 );
      Mesh( float x, float y, float z, Entity *parent = 0 );
      virtual ~Mesh();

      int findFace( Face * );

      virtual int draw( int d_options = 0 );
      void drawFaces();

      Mesh & operator=( Mesh&rhs );

      virtual Entity * clone();

      virtual void copyFrom( Entity * );



      void setDrawEdges( bool f ) {draw_edges = f;};

      /* Modeling functions
       *
      * All operations on subobjects are done through entry points at the
      * object level.  Subobjects are always identified through their indexes
      * into the subobject vector. All operations take the subobject type as a parameter
      * and include 'short cut' methods to access the method with a certain subobject type.
       */

      virtual void mirror( int axis );
      virtual void subdivide();
      virtual void subdivideTriangles();
      virtual void subdivideTriangles( vector<int> & );

      virtual void triangulate();
      virtual void triangulateFaces( vector<int> &faces );

      virtual void reverse();
      virtual void tighten( float tolerance );
      virtual void smooth( float tolerance );

      void merge( vector<Object *> &objs );
      void explode( vector<Mesh *> & );

      void weldVerts( vector<int> &vlist );
      void weldFace( int a, int b );

      void toggleEdgeHardness( vector<int> &elist );
      void setVertexColors( vector<int> &vlist, float r, float g, float b, float a );
      void resetVertexColors( vector<int> &vlist );

      Mesh * sliceVerts( vector<int> &verts );
      Mesh * sliceFaces( vector<int> &verts );
      Mesh * sliceEdges( vector<int> &verts );

      virtual void deleteFaces( vector<int> &faces );
      virtual void deleteVerts( vector<int> &verts );
      virtual void deleteEdges( vector<int> &edges );

      virtual Mesh * slice( int type, vector<int> &solist );

      void loopVerts( vector<int> &v );
      void loopEdges( vector<int> &v );
      void connectVerts( vector<int> &v );
      void connectEdges( vector<int> &v );
      virtual void connect( int type, vector<int> &, bool loop );

      void extrudeVerts( vector<int> &v, Vector4 &p );
      void extrudeEdges( vector<int> &e, Vector4 &p );
      void extrudeFaces( vector<int> &f, Vector4 &p );

      void bevelVerts( vector<int> &v, float amt );
      void bevelEdges( vector<int> &e, float amt );
      void bevelFaces( vector<int> &f, float amt );

      void divideEdges( vector<int> &e );
      void reverseFaces( vector<int> & );
      void smoothFaces( vector<int> & );
      void subdivideFaces( vector<int> & );

      void createNewFace( vector<int> & );


      //shared by all meshes.
      static bool draw_edges;
      static bool cull_faces;
      static int TYPE;

   protected:

};

#endif
