/***************************************************************************
                         metaball.h  -  description                              
                            -------------------                                         
   begin                : Tue Nov 16 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef METABALL_H
#define METABALL_H

#include "isosurface.h"

/** A Metaball is soft ball that 'sticks' to each other.  They are usefull
  * for turning 3d points into a surface, or for organining modelling.
  * They are in general, cool.
  * @author Jon Anderson
  */

class MetaBall : public IsoSurface
{
   public:
      MetaBall( float x, float y, float z, Entity *p = 0 );
      ~MetaBall();
      int draw( int d_options = 0 );
      bool isIn( float x, float y, float z );
      float getField( float r );

      static int TYPE;

   protected:
      float radius;
      float strength;
      float maxdist;


};

#endif
