/***************************************************************************
                         nurbscurve.h  -  description
                            -------------------                                         
   begin                : Thu Nov 18 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef NURBSCURVE_H
#define NURBSCURVE_H

#include "spline.h"
#include <nurbs++/nurbs.hh>
#include <nurbs++/vector.hh>

#define CONTROL_CURVE 0
#define INTERPOLATE_CURVE 1
#define CIRCLE_CURVE 2

/**This class is  a Nurbs curve.
  *@author Jon Anderson
  */

class Material;

class Vertex;

class CtrlPt;

class NurbsCurve : public Spline
{
   public:
      NurbsCurve( Entity *parent = 0, int ctype = 0 );
      virtual ~NurbsCurve();

      virtual void copyFrom( Entity * );

      NurbsCurve( Vector4 &, int );
      void init();

      virtual int draw( int d_options = 0 );

      void interpolate( vector<Vector4 > & );
      void interpolateClosed( vector<Vector4 > & );

      void makeCircle( Vector4 &, Vector4 & );

      void controlPoints( vector<Vector4 > & );
      PLib::NurbsCurvef getCurve() { return curve;};

      PLib::NurbsCurvef getWorldSpaceCurve();

      void drawControlPolygon();

      void setUpControlPoints();
      void moveControlPoint( CtrlPt *, float x, float y, float z );


      CtrlPt * createCtrlPt( float x, float y, float z );

      void reverse();
      void closeSpline();
      void breakSpline();

      NurbsCurve & operator=( NurbsCurve &rhs );
      virtual Entity * clone();
      void setUSegs( int i ) {usegs = i;};

      int getUSegs() { return usegs;};

      vector<float> getUKnots();
      int getUDegree() { return degree;};

      void createCurve( vector<Vector4> &pts, vector<float> &knots, int degree );

      virtual Entity * sweep( Spline &s );
      virtual Entity * revolve( Spline &s, int degrees, int segs );

      void extend( Vector4 & );

      static int TYPE;

   private:
      NurbsCurve * getProfile( NurbsCurve *, float );

   protected:
      /** The nurbs curve */
      PLib::NurbsCurvef curve;

      /** A vector of control points for the curve */
      Vector_Point3Df points;
      /** A vector of tangents for the curve */
      Vector_Point3Df tangents;

      int degree;

      int create_type;
      vector<Vector4 >create_pts;

      /**The glu Nurbs renderer used to draw the curve */
      GLUnurbsObj *theNurbs;
      void setDirtyBox( bool flag );
      Material *material;
      int usegs;

};

#endif
