/***************************************************************************
                         readtex.h  -  description
                            -------------------
   begin                : Sun Aug 20 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef READTEX
#define READTEX

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#ifndef SEEK_SET
#  define SEEK_SET 0
#endif


/*
** RGB Image Structure
*/

typedef struct _TK_RGBImageRec
{
   GLint sizeX, sizeY;
   GLint components;
   unsigned char *data;
}

TK_RGBImageRec;



/******************************************************************************/

typedef struct _rawImageRec
{
   unsigned short imagic;
   unsigned short type;
   unsigned short dim;
   unsigned short sizeX, sizeY, sizeZ;
   unsigned long min, max;
   unsigned long wasteBytes;
   char name[ 80 ];
   unsigned long colorMap;
   FILE *file;
   unsigned char *tmp, *tmpR, *tmpG, *tmpB, *tmpA;
   unsigned long rleEnd;
   GLuint *rowStart;
   GLint *rowSize;
}

rawImageRec;

/******************************************************************************/

TK_RGBImageRec *tkRGBImageLoad( const char *fileName );
void FreeImage( TK_RGBImageRec *image );


#endif //READTEX
