/***************************************************************************
                          fileIO.h  -  description
                             -------------------                                         
    begin                : Tue Oct 19 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef FILEIO_H
#define FILEIO_H

//qt includes

#include <string>
#include <iostream.h>
#include <fstream.h>

class ObjectDB;
class TextureManager;

enum {
    VERSION_006,
    VERSION_007,
    VERSION_008,
    VERSION_009,
    VERSION_010
};


/**This is the base class for all file IO.
  *@author Jon Anderson
  */

enum {
    FILEIO_ASCII  =  1,
    FILEIO_BINARY =  2
};

class FileIO {
public:
    FileIO(string name, int mode=1);
    virtual ~FileIO();
    void setIOMode(int _mode){IO_mode = _mode;};
    void setFileFormat(string format){fileformat=format;};
    virtual void write()=0;
    virtual void read()=0;

    string readString();
    void writeString(string);
protected:
    ObjectDB *db;
    TextureManager *tm;
    ifstream in;
    ofstream out;

    string filename;
    string fileformat;
    int IO_mode;
    int version;


};

#endif








