//
// (c) Polar Pyramid                                                                                                             
// suggestions to stolken@kabelfoon.nl and/or stolk@xs4all.nl
//


// Description:
//	The Vector3 class is a 3d vector containing 3 floats, can be used
//  to represent points(positions) as well as vectors(directions)
//
//

#ifndef VECTOR3_HH
#define VECTOR3_HH

class Vector3
{
public:
  // the vector data

//  float v[3];

  float           x;
  float           y;
  float           z;
  bool             interp;


  // constructors

  Vector3();
  Vector3(const Vector3 &);
  Vector3(float x, float y, float z);

  // array access

  float& operator [] (int);
   const float& operator [] (int) const;

  // assignment

  Vector3& assign(float x, float y, float z);

  // math operators

  Vector3 operator - () const;
  Vector3& operator += (const Vector3&);
  Vector3& operator -= (const Vector3&);
  Vector3& operator *= (float);
  Vector3& operator /= (float);

	void scale(float x, float y, float z);

  Vector3 operator + (const Vector3&) const;
  Vector3 operator - (const Vector3&) const;
  Vector3 operator / (float) const;

  bool operator == (const Vector3&) const;
  bool operator != (const Vector3&) const;

   bool isInterpolatable();
   void setInterpolatable(bool);
  // friends

  friend Vector3 operator*(float c, Vector3 const &v);
  friend Vector3 operator*(Vector3 const &v, float c);

   float * v(float *v){v[0]=x;v[1]=y;v[2]=z;return v;};

	//overloaded cast.
	//operator const float*() const {return(v);};


  // operations

  float      length(void) const;
  float       lengthSqr(void) const;
  float      length2d(void) const;
  float       lengthSqr2d(void) const;
  void        normalize(void);

  // cross product

  Vector3 operator * (const Vector3&) const;

  // dot product

   float dot(const Vector3&) const;
   float dot2d(const Vector3&) const;

  // distance functions when interpreted as a point

  float distanceSqr(const Vector3&) const;
  float distance(const Vector3&) const;
  float distanceSqr2d(const Vector3&) const;
  float distance2d(const Vector3&) const;

  void Dump(void) const;
};

typedef class Vector3 *Vector3Ptr;

#endif




