/***************************************************************************
                         facemodifier.h  -  description
                            -------------------
   begin                : Mon Apr 23 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FACEMODIFIER_H
#define FACEMODIFIER_H

#include "subobjectmodifier.h"

class UVWrap;

/**
  *@author Jon Anderson
  */

class FaceModifier : public SubObjectModifier
{
      Q_OBJECT
   public:
      FaceModifier();
      ~FaceModifier();

      // virtual void filterSelection( int *array, int n, int mode );

      virtual void activate();
      virtual void deactivate();

      virtual void startTransform();
      virtual void endTransform();
      virtual void transform ( Vector4 &, Vector4 & );

      virtual void draw();

      virtual void keyEvent ( QKeyEvent * );

      static int TYPE;

   public slots:
      void slotExtrude();
      void slotBevel();
      void slotReverse();
      void slotDelete();
      void slotTriangulate();

      void slotXYPlaneGizmo();
			void slotYZPlaneGizmo();
			void slotXZPlaneGizmo();

      void slotCubeGizmo();
      void slotCylinderGizmo();
      void slotSphereGizmo();

      void slotEditUVs();

      void slotApplyGizmo();
      void slotQuitGizmo();


   protected:
      UVWrap * m_gizmo;
      bool m_using_gizmo;
};

#endif
