/***************************************************************************
                         icontrol.h  -  description
                            -------------------
   begin                : Mon Apr 16 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ICONTROL_H
#define ICONTROL_H

#include <qpopupmenu.h>
#include <vector>
#include <Commands/dbcommand.h>
#include <Commands/transactioncommand.h>
#include <Commands/transformcmd.h>
#include <Commands/checkpointcmd.h>

#include <qobject.h>

class Selectable;

class Vector4;

/**
  *@author Jon Anderson
  */

class IControl : public QObject
{
      Q_OBJECT

   public:

      enum { CREATOR, MODIFIER };

      IControl();
      virtual ~IControl();

      virtual QPopupMenu * getPopupMenu() { return m_popup;};

      int getControlType();
      void setControlType( int i );


      virtual void filterSelection( int *array, int n, int mode ) = 0;

      virtual void mouseMove ( Vector4 &, Vector4 &, int ) = 0;
      virtual void mousePress ( Vector4 &, Vector4 &, int ) = 0;
      virtual void mouseRelease( Vector4 &, Vector4 &, int ) = 0;
      virtual void keyEvent ( QKeyEvent * ) = 0;

      virtual void draw() = 0;

      virtual void activate() = 0;
      virtual void deactivate() = 0;

      virtual void updateViews();
      void setStatus( char * );
      void setStatusDone();

      string & getName() { return m_name; };

      void setName( string s ) { m_name = s;};

      virtual void cut();
      virtual void copy();
      virtual void paste();

      static int TYPE;
      static int getUID() { return _type++; };


   public slots:
      void slotUpdateViews();

   protected:
      vector<Selectable *> m_selection;
      QPopupMenu * m_popup;

      int m_control_type;

      string m_name;

      static int _type;

};

#endif
