/***************************************************************************
                         meshcreator.h  -  description
                            -------------------
   begin                : Wed Apr 18 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MESHCREATOR_H
#define MESHCREATOR_H

#include "creator.h"
#include <qobject.h>

class Mesh;
/**
  *@author Jon Anderson
  */

class MeshCreator : public Creator
{
      Q_OBJECT

   public:
      MeshCreator();
      ~MeshCreator();

      virtual void mousePress ( Vector4 &, Vector4 &, int );
      virtual void keyEvent ( QKeyEvent * );

      virtual void activate();
      virtual void deactivate();

      static int TYPE;

   public slots:
      void slotCreateCube();
      void slotCreateSphere();
      void slotCreateHMap();
      void slotCreateCylinder();
      void slotCreateXYPlane();
      void slotCreateXZPlane();
      void slotCreateYZPlane();
      void slotCreateCustom();

   private:
      Mesh *m_mesh;
};

#endif
