/***************************************************************************
                          pluginregistry.h  -  description
                             -------------------
    begin                : Sat Feb 12 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLUGINREGISTRY_H
#define PLUGINREGISTRY_H

class IPlugin;
class PluginBase;
class FilePluginWrapper;
class DialogPluginWrapper;
class Creator;
class Modifier;
class DynamicLibrary;

/**This class is responsible for loading and unloading all
plugins.
  *@author Jon Anderson
  */

class PluginRegistry {
public: 
	PluginRegistry();
	~PluginRegistry();
	
	bool loadPlugins();
	bool unloadPlugins();
	IPlugin * createPlugin(DynamicLibrary *p_dll);
	
  QList<FilePluginWrapper> & getFilePlugins(){return file_plugins;};
  QList<DialogPluginWrapper> & getDialogPlugins(){return dialog_plugins;};

  QList<Creator> & getCreatorPlugins() { return creator_plugins; };
  QList<Modifier> & getModifierPlugins() { return modifier_plugins; };


private:
	QList<FilePluginWrapper> file_plugins;
	QList<DialogPluginWrapper> dialog_plugins;
	QList<Creator> creator_plugins;
	QList<Modifier> modifier_plugins;
	
	QList<DynamicLibrary> plugin_dlls;
	
};

#endif
