/***************************************************************************
                          uvwrap.cpp  -  description
                             -------------------
    begin                : Wed Jun 14 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "uvwrap.h"
#include <Entities/face.h>

UVWrap::UVWrap() : Entity(0), m_scale(1, 1, 1, 1)
{
	
}

UVWrap::~UVWrap(){
}


//scale by scaling the vectors.
void UVWrap::scale(float x, float y, float z, float cx, float cy, float cz)
{
	m_scale.x *= x;
	m_scale.y *= y;
	m_scale.z *= z;	
}

void UVWrap::copyFrom( Entity *rhs )
{
   *this = * dynamic_cast<UVWrap *>( rhs );
}

UVWrap & UVWrap::operator=( UVWrap &rhs )
{
	Entity::operator=(rhs);
	
	m_scale = rhs.m_scale;
	
	return *this;
}

