/***************************************************************************
                          uvwrap.h  -  description
                             -------------------
    begin                : Wed Jun 14 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UVWRAP_H
#define UVWRAP_H

#include <Math/vector4.h>
#include <Entities/entity.h>
#include <GL/glut.h>
#include <math.h>

#include <vector>

/**This is the base class for all UVWrapping gizmos.
  *@author Jon Anderson
  */

class TextureMaterial;
class Face;
class SubObject;

class UVWrap : public Entity {
public: 
	UVWrap();
	virtual ~UVWrap();
	//overwritten from entity.
  virtual int draw(int d_options = 0)=0;
  virtual void scale(float x, float y, float z, float px, float py, float pz);
  virtual void createMapping(vector<SubObject *> *faces)=0;
	
  virtual Entity * clone()=0;
	UVWrap & operator=( UVWrap &rhs );
 	virtual void copyFrom( Entity *rhs );
 	
protected:
	Vector4 m_scale;
	
};

#endif
