/***************************************************************************
                         glpreview.h  -  description
                            -------------------
   begin                : Wed Jan 19 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GLPREVIEW_H
#define GLPREVIEW_H

#include <qgl.h>
#include <GL/glut.h>
#include <Entities/texturematerial.h>
#include <qpixmap.h>

#define PREVIEW_CUBE      0
#define PREVIEW_CYLINDER  1
#define PREVIEW_SPHERE    2
#define PREVIEW_TEAPOT    3

/**
  *@author Jon Anderson
  */

class GLPreview : public QGLWidget
{
   public:
      GLPreview( QWidget *parent, const char *name, QGLWidget *sharer );
      ~GLPreview();

      TextureMaterial *getMaterial() { return mat;};

      void setMaterial( TextureMaterial *tm ) {mat = tm;};

      void setPreviewType( int mode ) {type = mode;};

      QPixmap getPixmap( );
      void drawBackground();

   protected:
      void initializeGL();
      void paintGL();
      void resizeGL( int h, int w );

   protected:
      int width, height;
      TextureMaterial *mat;
      TextureMaterial *def_mat;
      int type;
      GLUquadricObj *gluObj;
      int display_cube;

      GLuint bgName;

};

#endif
