/***************************************************************************
                         viewuv.cpp  -  description                              
                            -------------------                                         
   begin                : Sun Sep 26 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "viewUV.h"
#include<Entities/mesh.h>
#include <Entities/texturematerial.h>
#include <Entities/face.h>
#include <Entities/uvcoord.h>
#include <Entities/subobject.h>

ViewUV::ViewUV( QWidget *parent, const char *name = 0, QGLWidget *sharer = 0, bool enable )
      : ViewXY( parent, name, sharer ), faces()
{

   showaxis = false;
   showgrid = false;
   showBackground( false );

   vrepeat = 1;
   urepeat = 1;
   mesh = 0;
   uv_modifier = 0;

}

ViewUV::~ViewUV()
{
   //clean up it's modifier...
   delete uv_modifier;
}

/**Assumes that all faces have been validated to have the same parent mesh
 *and that more than one face is in the list.
  */ 
/*
void ViewUV::setFaces(FaceList &flist)
{
 showBackground(false);
 
 
 faces = flist;
  
 Face *f = (Face *)faces[0];
 
 mesh = (Mesh *)f->getParentObject();
 
 TextureMaterial *t =mesh->getTextureMaterial(0);
 if(t==0){
  showBackground(false);
  return;
 
 }
 
 background = t->texture;
 if(background != 0){
   showBackground(true);
 } 
 
 determineBounds();   
 
}
*/ 
/**Determine the bounding rectangle of the uv coordinates.
  */
void ViewUV::determineBounds()
{
/*
   min_u = 10000;
   max_u = -10000;
   min_v = 10000;
   max_v = -10000;

   Vector4 p;
   UVList *uvlist = mesh->getUVs();

   for ( int i = 0; i < ( int ) faces.size(); i++ )
   {
      vector<int> *uvs = mesh -> getFace( faces[ i ] ) -> getUVs();

      for ( int j = 0; j < ( int ) uvs->size(); j++ )
      {
         p = ( *uvlist ) [ ( *uvs ) [ j ] ] ->getPosition();

         if ( min_u > p.x )
            min_u = p.x;

         if ( max_u < p.x )
            max_u = p.x;

         if ( min_v > p.y )
            min_v = p.y;

         if ( max_v < p.y )
            max_v = p.y;

      }

   }

   //conversion from float to int truncates the decimal places....
   vrepeat = ( int ) ( max_v + 1 );

   urepeat = ( int ) ( max_u + 1 );


   emit uRepeat( urepeat );

   emit vRepeat( vrepeat );

*/
   vrepeat = 1;
   urepeat = 1;

   //makeCurrent();
   //resizeGL(width, height);

}

void ViewUV::setMesh( Mesh *_mesh, vector<int> &_faces )
{
   showBackground( false );


   mesh = _mesh;


   faces = _faces;

   TextureMaterial *t = _mesh -> getTextureMaterial( 0 );

   if ( t == 0 )
   {
      showBackground( false );
      return ;

   }

   background = t -> texture;

   if ( background != 0 )
   {
      showBackground( true );
   }

   determineBounds();


}

void ViewUV::display()
{
   if ( mesh == 0 )
   {
      return ;
   }

   glPushAttrib( GL_POLYGON_BIT );

   glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );

   glPushName( mesh->getID() );
   vector<SubObject *> *uvs = mesh->getUVs();

   glColor4f( 1, 1, 1, 1 );

   for ( int i = 0; i < ( int ) faces.size(); i++ )
   {
      Face *f = mesh -> getFace( faces[ i ] );
      vector<int> *uvlist = f->getUVs();
      glBegin( GL_LINE_LOOP );
      Vector4 p;

      for ( int j = 0; j < ( int ) uvlist->size(); j++ )
      {
         UVCoord * uv = static_cast< UVCoord * >( ( *uvs ) [ ( *uvlist ) [ j ] ] );
         uv -> getPosition( &p );
         glVertex3f( p.x / urepeat, p.y / vrepeat, p.z );
      }

      glEnd();

   }

   for ( int i = 0; i < ( int ) faces.size(); i++ )
   {
      Face *f = mesh -> getFace( faces[ i ] );
      vector<int> *uvlist = f->getUVs();

      Vector4 p;

      for ( int j = 0; j < ( int ) uvlist->size(); j++ )
      {
         UVCoord * uv = static_cast< UVCoord * >( ( *uvs ) [ ( *uvlist ) [ j ] ] );
         glPushName( uv -> getParentIndex() );

         if ( uv -> isSelected() )
         {
            glColor4f( 1, 0, 0, 1 );
            //hack to make sure boxes appear correctly when UVs are repeated.
            uv -> getPosition( &p );
            uv -> setPosition( p.x / urepeat, p.y / vrepeat, p.z );
            uv -> drawBoundingBox();
            uv -> setPosition( p.x, p.y, p.z );

         }

         else
         {
            glColor4f( 0, 1, 0, 1 );
         }

         glBegin( GL_POINTS );
         uv -> getPosition( &p );
         glVertex3f( p.x / urepeat, p.y / vrepeat, p.z );
         glEnd();
         glPopName();
      }
   }

   glPopName();
   glPopAttrib();
}

void ViewUV::setCamera()
{
   Vector4 & pos = camera->getPosition();
   gluLookAt( 0, 0, pos.z , 0, 0, 0, 0, 1, 0 );
   glTranslatef( -pos.x, -pos.y, 0 );

}

void ViewUV::setProjection()
{
   glOrtho( -.05 * wpct, 1.05 * wpct, -.05 * hpct, 1.05 * hpct, -2500, 2500 );
   //   glOrtho(-.25, 1.25, -.25, 1.25, -500, 500);
}


void ViewUV::drawBackground()
{

   if ( background == 0 )
      return ;

   glPushAttrib( GL_TEXTURE_BIT | GL_LIGHTING_BIT | GL_POLYGON_BIT );

   glEnable( GL_TEXTURE_2D );

   glBindTexture( GL_TEXTURE_2D, background->getID() );

   glMatrixMode( GL_MODELVIEW );

   glPushMatrix();

   glLoadIdentity();

   glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );

   glDisable( GL_LIGHTING );

   glColor4f( 1, 1, 1, 1 );

   // float wt, ht;

   glBegin( GL_QUADS );

   glTexCoord2f( 0, 0 ); glVertex3f( 0, 0, -499 );

   glTexCoord2f( 1 * urepeat, 0 ); glVertex3f( 1, 0, -499 );

   glTexCoord2f( 1 * urepeat, 1 * vrepeat );glVertex3f( 1, 1, -499 );

   glTexCoord2f( 0, 1 * vrepeat );glVertex3f( -0, 1, -499 );

   glEnd();

   glPopMatrix();

   glPopAttrib();

}


void ViewUV::setURepeat( int x )
{
   UVList * uvs = mesh->getUVs();

   Vector4 p;

   for ( int i = 0; i < ( int ) faces.size(); i++ )
   {
      vector<int> *uvlist = mesh -> getFace( faces[ i ] ) -> getUVs();

      for ( int j = 0; j < ( int ) uvlist->size(); j++ )
      {
         p = ( *uvs ) [ ( *uvlist ) [ j ] ] ->getPosition();
         p.x = p.x / urepeat;
         p.x = p.x * x;
         ( *uvs ) [ ( *uvlist ) [ j ] ] ->setPosition( p.x, p.y, p.z );

      }
   }

   urepeat = x;
   updateGL();
}

void ViewUV::setVRepeat( int x )
{
   vector<SubObject *> *uvs = mesh->getUVs();

   Vector4 p;

   for ( int i = 0; i < ( int ) faces.size(); i++ )
   {
      vector<int> *uvlist = mesh -> getFace( faces[ i ] ) -> getUVs();

      for ( int j = 0; j < ( int ) uvlist->size(); j++ )
      {
         p = ( *uvs ) [ ( *uvlist ) [ j ] ] ->getPosition();
         p.y = p.y / vrepeat;
         p.y = p.y * x;
         ( *uvs ) [ ( *uvlist ) [ j ] ] ->setPosition( p.x, p.y, p.z );

      }
   }

   vrepeat = x;
   updateGL();
}































