/***************************************************************************
                         i3d.cpp  -  description
                            -------------------                                         
   begin                : Sat Aug 14 10:38:16 CDT 1999
                                          
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <iostream.h>
#include <qtimer.h>

// include files for KDE
//#include <kiconloader.h>
#include <qmessagebox.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qtoolbutton.h>
#include <qpixmap.h>
#include <qwhatsthis.h>
#include <qfiledialog.h>

// application specific includes
#include <i3d.h>
#include "i3dworkspace.h"
#include "i3ddoc.h"

#include "Controls/animationctrl.h"
#include "Controls/configdialog.h"



#include "resource.h"
#include "Commands/command.h"
#include "redostack.h"
#include "undostack.h"

//pixmaps.
#include "Xpm/filenew.xpm"
#include "Xpm/fileopen.xpm"
#include "Xpm/filesave.xpm"
#include "Xpm/cut.xpm"
#include "Xpm/copy.xpm"
#include "Xpm/paste.xpm"
#include "Xpm/undo.xpm"
#include "Xpm/redo.xpm"
#include "Xpm/objectselector.xpm" 
//#include "Controls/mateditor.h"


#include <Plugins/pluginregistry.h>
#include <Plugins/fileplugin.h>
#include <Plugins/filepluginwrapper.h>
#include <Plugins/dialogpluginwrapper.h>
#include <Plugins/dialogplugin.h>

#include "Modifiers/modetoolbar.h"
#include "Modifiers/meshcreator.h"
#include "Modifiers/surfacecreator.h"
#include "Modifiers/splinecreator.h"
#include "Modifiers/primitivecreator.h"
#include "Modifiers/bonecreator.h"

#include "Modifiers/vertexmodifier.h"
#include "Modifiers/meshmodifier.h"
#include "Modifiers/edgemodifier.h"
#include "Modifiers/facemodifier.h"
#include "Modifiers/splinemodifier.h"
#include "Modifiers/surfacemodifier.h"
#include "Modifiers/bonemodifier.h"

#include "GUI/configdlg.h"
#include "GUI/helpwindow.h"

#include "objectselector.h"

#include "config.h"


I3D *I3D::i3d = 0L;


I3D::I3D() : QMainWindow()
{
   num_toolbars = 1;
	 view_id = 0;
	
   i3d = this;

   tb = new QToolBar( this );
   mb = new QMenuBar( this );

   initConfig();

   ///////////////////////////////////////////////////////////////////
   // call inits to invoke all other construction parts
   initMenuBar();
   initToolBar();
   initStatusBar();
   initKeyAccel();


   initDocument();
   initView();

   initPlugins();  //relies on menu being initialized.

   mb->insertItem( "&Window", m_workspace->getPopupMenu() );

   mb->insertSeparator();
   mb->insertItem( "&Help", help_menu );



   readOptions();

   ///////////////////////////////////////////////////////////////////
   //disable menu and toolbar items at startup

   //disableCommand(ID_FILE_SAVE);
   //disableCommand(ID_FILE_SAVE_AS);
   disableCommand( ID_FILE_PRINT );

   //disableCommand(ID_EDIT_CUT);
   //disableCommand(ID_EDIT_COPY);
   //disableCommand(ID_EDIT_PASTE);
   disableCommand( ID_EDIT_UNDO );
   disableCommand( ID_EDIT_REDO );

   m_path = QDir::homeDirPath();

   //setup app to handle all available image formats.
   //   qInitImageIO();
   //

   activateControl( MeshModifier::TYPE );

   m_config -> setSection( "Window" );
   setGeometry( 0, 0, m_config -> getInt( "Width" ), m_config -> getInt( "Height" ) );

   initRecentFiles();

   getWorkspace() -> refreshOptions();

   QTimer *timer = new QTimer( this );
   connect( timer, SIGNAL(timeout()), this, SLOT(slotUpdateViews()) );
   timer->start( 0, TRUE );  //run as soon as events have expired.

}

I3D::~I3D()
{
   cerr << "Quitting..." << endl;
   char buffer[ 256 ];
   int i = 0;
   //
   m_config -> setSection( "Window" );
   m_config -> setInt( "Width", width() );
   m_config -> setInt( "Height", height() );

   m_config -> setSection( "RecentFiles" );

   for ( QString * str = recent_files.first(); str != 0; str = recent_files.next() )
   {
      sprintf( buffer, "file%d", i );
      m_config -> setString( buffer, str -> ascii() );
      i++;
   }

   m_config -> save();
   delete m_mateditor;
   delete m_config;
}

void I3D::initRecentFiles()
{

   char buffer[ 256 ];
   string file;

   m_config -> setSection( "RecentFiles" );

   QList<QString> list;

   for ( int i = 0; i < 5; i++ )
   {
      sprintf( buffer, "file%d", i );
      file = m_config -> getString( buffer );

      if ( file != "" )
      {
         QString * str = new QString();
         *str = file.c_str();
         list.append( str );
      }
   }

   setRecentFiles( list );

}


void I3D::closeEvent( QCloseEvent *e )
{
   if ( queryClose() )
   {
      e->accept();
      //    if (memberList->count() == 1) // last window close accepted?
      //    {
      if ( queryExit() )             // Yes, Quit app?
      {
         delete this;              // Yes, delete this...
         qApp->quit();             // ...and quit aplication.
      }                           //--------------------------------

      //   }
      //   else                         // It was not last window...
      //     delete this;               // ...so only delete this. (sven)
   }

}

void I3D::initConfig()
{
   m_config = new Config();

   m_conf = new ConfigDlg();
   m_conf -> hide();


   QString cfgrc = QDir::homeDirPath();
   cfgrc += "/.i3drc";

   //try loading the file
   if ( m_config -> load( cfgrc.ascii() ) )
   {
      return ;
   }

   //otherwise, initialize defaults...

   QMessageBox::information( this, "I3D", "Welcome to I3D. I3D will now\n"
                             "setup it's default options." );

   m_config -> setSection( "Directories" );

   m_config -> setString( "Plugins", "/usr/local/i3d/Plugins" );

   m_config -> setString( "Textures", "/usr/local/i3d/Textures" );

   m_config -> setString( "Scenes", "/usr/local/i3d/Scenes" );

   m_config -> setSection( "Display" );

   m_config -> setFloat( "GridSpacing", 10.0f );

   m_config -> setFloat( "GridSize", 10.0f );

   m_config -> setBool( "MoveWireframe", false );

   m_config -> setBool( "3DWireframe", false );

   m_config -> setBool( "2DWireframe", true );

   m_config -> setBool( "SmoothShading", true );

   m_config -> setSection( "Window" );

   m_config -> setInt( "Width", 800 );

   m_config -> setInt( "Height", 600 );

   // m_config -> setSection( "RecentFiles" );
   //nothing here, duh.

   return ;

}


void I3D::initKeyAccel()
{
   key_accel = new QAccel( this );

   key_accel->insertItem( IDK_New, ID_FILE_NEW );
   key_accel->insertItem( IDK_Open, ID_FILE_OPEN );
   key_accel->insertItem( IDK_Save, ID_FILE_SAVE );
   key_accel->insertItem( IDK_Close, ID_FILE_CLOSE );
   key_accel->insertItem( IDK_Print, ID_FILE_PRINT );
   key_accel->insertItem( IDK_Quit, ID_FILE_QUIT );
   key_accel->insertItem( IDK_Cut, ID_EDIT_CUT );
   key_accel->insertItem( IDK_Copy, ID_EDIT_COPY );
   key_accel->insertItem( IDK_Paste, ID_EDIT_PASTE );
   key_accel->insertItem( IDK_Redo, ID_EDIT_REDO );
   key_accel->insertItem( IDK_Undo, ID_EDIT_UNDO );

   // file_menu accelerators
   key_accel->connectItem( ID_FILE_NEW, this, SLOT( slotFileNew() ) );
   key_accel->connectItem( ID_FILE_OPEN, this, SLOT( slotFileOpen() ) );
   key_accel->connectItem( ID_FILE_SAVE, this, SLOT( slotFileSave() ) );
   key_accel->connectItem( ID_FILE_CLOSE, this, SLOT( slotFileClose() ) );
   key_accel->connectItem( ID_FILE_PRINT, this, SLOT( slotFilePrint() ) );
   key_accel->connectItem( ID_FILE_QUIT, this, SLOT( slotFileQuit() ) );
   // edit_menu accelerators
   key_accel->connectItem( ID_EDIT_CUT, this, SLOT( slotEditCut() ) );
   key_accel->connectItem( ID_EDIT_COPY, this, SLOT( slotEditCopy() ) );
   key_accel->connectItem( ID_EDIT_PASTE, this, SLOT( slotEditPaste() ) );
   key_accel->connectItem( ID_EDIT_UNDO , this, SLOT( slotUndo() ) );
   key_accel->connectItem( ID_EDIT_REDO , this, SLOT( slotRedo() ) );

   key_accel->setEnabled( true );
}
void I3D::setViewMenu( QPopupMenu * m )
{
//	mb -> ();
}
void I3D::initMenuBar()
{

   ///////////////////////////////////////////////////////////////////
   // MENUBAR

   recent_files_menu = new QPopupMenu();
   import_menu = new QPopupMenu();
   export_menu = new QPopupMenu();

   // Setup the Create and Modify menu
   create_menu = new QPopupMenu();
   modify_menu = new QPopupMenu();

   MeshCreator *mc = new MeshCreator();
   SurfaceCreator *sc = new SurfaceCreator();
   SplineCreator *spc = new SplineCreator();
   PrimitiveCreator *pc = new PrimitiveCreator();
   BoneCreator *bc = new BoneCreator();

   create_menu -> insertItem( pc -> getName().c_str(), pc -> getPopupMenu() );
   create_menu -> insertItem( spc -> getName().c_str(), spc -> getPopupMenu() );
   create_menu -> insertItem( mc -> getName().c_str(), mc -> getPopupMenu() );
   create_menu -> insertItem( sc -> getName().c_str(), sc -> getPopupMenu() );
   create_menu -> insertItem( bc -> getName().c_str(), bc -> getPopupMenu() );

   m_controls.insert( IControlPair( MeshCreator::TYPE, mc ) );
   m_controls.insert( IControlPair( SurfaceCreator::TYPE, sc ) );
   m_controls.insert( IControlPair( SplineCreator::TYPE, spc ) );
   m_controls.insert( IControlPair( PrimitiveCreator::TYPE, pc ) );
   m_controls.insert( IControlPair( BoneCreator::TYPE, bc ) );


   VertexModifier *vm = new VertexModifier();
   MeshModifier *mm = new MeshModifier();
   EdgeModifier *em = new EdgeModifier();
   FaceModifier *fm = new FaceModifier();
   SplineModifier *spm = new SplineModifier();
   SurfaceModifier *sfm = new SurfaceModifier();
   BoneModifier *bm = new BoneModifier();

   m_controls.insert( IControlPair( MeshModifier::TYPE, mm ) );
   m_controls.insert( IControlPair( SurfaceModifier::TYPE, sfm ) );
   m_controls.insert( IControlPair( SplineModifier::TYPE, spm ) );
   m_controls.insert( IControlPair( VertexModifier::TYPE, vm ) );
   m_controls.insert( IControlPair( BoneModifier::TYPE, bm ) );
   m_controls.insert( IControlPair( EdgeModifier::TYPE, em ) );
   m_controls.insert( IControlPair( FaceModifier::TYPE, fm ) );

   modify_menu -> insertItem( vm -> getName().c_str(), vm, SLOT( slotActivate() ) );
   modify_menu -> insertItem( em -> getName().c_str(), em, SLOT( slotActivate() ) );
   modify_menu -> insertItem( fm -> getName().c_str(), fm, SLOT( slotActivate() ) );
   modify_menu -> insertItem( spm -> getName().c_str(), spm, SLOT( slotActivate() ) );
   modify_menu -> insertItem( mm -> getName().c_str(), mm, SLOT( slotActivate() ) );
   modify_menu -> insertItem( sfm -> getName().c_str(), sfm, SLOT( slotActivate() ) );
   modify_menu -> insertItem( bm -> getName().c_str(), bm, SLOT( slotActivate() ) );

   plugin_menu = new QPopupMenu();

   connect( recent_files_menu, SIGNAL( activated( int ) ), SLOT( slotFileOpenRecent( int ) ) );

   ///////////////////////////////////////////////////////////////////
   // menuBar entry file_menu
   file_menu = new QPopupMenu();
   //  file_menu->insertSeparator();

   file_menu->insertItem( "&Open...\tCTRL-O", ID_FILE_OPEN );
   file_menu->insertItem( "Open &recent", recent_files_menu, ID_FILE_OPEN_RECENT );

   file_menu->insertItem( "&Close\tCTRL-W", ID_FILE_CLOSE );
   file_menu->insertSeparator();
   file_menu->insertItem( "&Save\tCTRL-S", ID_FILE_SAVE );
   file_menu->insertItem( "Save &As...", ID_FILE_SAVE_AS );
   file_menu->insertSeparator();

   file_menu->insertItem( "&Import", import_menu, ID_FILE_IMPORT );
   file_menu->insertItem( "&Export", export_menu, ID_FILE_EXPORT );
   file_menu->insertSeparator();
   file_menu->insertItem( "E&xit\tCTRL-Q", ID_FILE_QUIT );

   ///////////////////////////////////////////////////////////////////
   // menuBar entry edit_menu
   edit_menu = new QPopupMenu();

   edit_menu->insertItem( "&Undo\tCTRL-Z", ID_EDIT_UNDO );
   edit_menu->insertItem( "&Redo\tCTRL-Y", ID_EDIT_REDO );
   edit_menu->insertSeparator();

   edit_menu->insertItem( "Cu&t\tCTRL-X", ID_EDIT_CUT );
   edit_menu->insertItem( "&Copy\tCTRL-C", ID_EDIT_COPY );
   edit_menu->insertItem( "&Paste\tCTRL-V", ID_EDIT_PASTE );

   ///////////////////////////////////////////////////////////////////
   // menuBar entry view_menu

   view_menu = new QPopupMenu();
   QPopupMenu *new_views_menu = new QPopupMenu();

   new_views_menu->insertItem( "3D View", ID_3DVIEW );
   new_views_menu->insertItem( "XY View", ID_XYVIEW );
   new_views_menu->insertItem( "XZ View", ID_XZVIEW );
   new_views_menu->insertItem( "YZ View", ID_YZVIEW );

   view_menu -> insertItem( "New...", new_views_menu );

   operate_menu = new QPopupMenu();
   operate_menu->insertItem( "&Material Editor", ID_TOOLS_MATEDITOR );
//   operate_menu->insertItem( "&Animation Editor", ID_TOOLS_ANICTRL );

   operate_menu->insertSeparator();
   operate_menu->insertItem( "&Options", ID_TOOLS_OPTIONS );

   ///////////////////////////////////////////////////////////////////
   // menuBar entry help_menu
   QString aboutstring = "Innovation3D 0.6\n\n";

   help_menu = new QPopupMenu();
   //help_menu = kapp->getHelpMenu(true, aboutstring );
   help_menu -> insertItem( "&Help", this, SLOT( slotShowHelp() ) );
   ///////////////////////////////////////////////////////////////////
   // MENUBAR CONFIGURATION
   // insert your popup menus with the according menubar entries in the order
   // they will appear later from left to right
   mb->insertItem( "&File", file_menu );
   mb->insertItem( "&Edit", edit_menu );
   view_id = mb->insertItem( "&Views", view_menu );
   mb->insertItem( "&Tools", operate_menu );
   mb->insertItem( "&Create", create_menu );
   mb->insertItem( "&Modify", modify_menu );

   mb->insertItem( "&Plugins", plugin_menu );

   ///////////////////////////////////////////////////////////////////
   // CONNECT THE MENU SLOTS WITH SIGNALS
   // for execution slots and statusbar messages

   connect( file_menu, SIGNAL( activated( int ) ), SLOT( commandCallback( int ) ) );
   connect( file_menu, SIGNAL( highlighted( int ) ), SLOT( statusCallback( int ) ) );

   connect( edit_menu, SIGNAL( activated( int ) ), SLOT( commandCallback( int ) ) );
   connect( edit_menu, SIGNAL( highlighted( int ) ), SLOT( statusCallback( int ) ) );

   connect( view_menu, SIGNAL( activated( int ) ), SLOT( commandCallback( int ) ) );
   connect( view_menu, SIGNAL( highlighted( int ) ), SLOT( statusCallback( int ) ) );

   connect( new_views_menu, SIGNAL( activated( int ) ), SLOT( commandCallback( int ) ) );
   connect( new_views_menu, SIGNAL( highlighted( int ) ), SLOT( statusCallback( int ) ) );


   connect( operate_menu, SIGNAL( activated( int ) ), SLOT( commandCallback( int ) ) );
   connect( operate_menu, SIGNAL( highlighted( int ) ), SLOT( statusCallback( int ) ) );

}


QToolBar * I3D::getToolbar()
{
   num_toolbars++;
   QToolBar *tb = new QToolBar( this );
   addToolBar( tb );
   return tb; //toolBar(num_toolbars-1);
}

void I3D::initToolBar()
{

   QToolBar * my_toolbar = new QToolBar( this );
   ModeToolbar *t = ModeToolbar::getInstance();
   t -> init( my_toolbar );

   ///////////////////////////////////////////////////////////////////
   // TOOLBAR
   //  tb = new QToolBar(this);
   //addToolBar(tb);
   QPixmap fn( ( const char ** ) filenew );
   QToolButton *fnb = new QToolButton( fn, "New File", 0, this, SLOT( slotFileNew() ), tb );
   command_buttons.insert( ID_FILE_NEW, fnb );

   QPixmap fo( ( const char ** ) fileopen );
   QToolButton *fob = new QToolButton( fo, "Open File", 0, this, SLOT( slotFileOpen() ), tb );
   command_buttons.insert( ID_FILE_OPEN, fob );

   QPixmap fs( ( const char ** ) filesave );
   QToolButton *fsb = new QToolButton( fs, "Save File", 0, this, SLOT( slotFileSave() ), tb );
   command_buttons.insert( ID_FILE_SAVE, fsb );

   tb->addSeparator();
   QPixmap ud( ( const char ** ) undo );
   QToolButton *udb = new QToolButton( ud, "Undo", 0, this, SLOT( slotUndo() ), tb );
   command_buttons.insert( ID_EDIT_UNDO, udb );


   QPixmap rd( ( const char ** ) redo );
   QToolButton *rdb = new QToolButton( rd, "Redo", 0, this, SLOT( slotRedo() ), tb );
   command_buttons.insert( ID_EDIT_REDO, rdb );


   tb->addSeparator();
   QPixmap ct( ( const char ** ) cut_xpm );
   QToolButton *ctb = new QToolButton( ct, "Cut", 0, this, SLOT( slotEditCut() ), tb );
   command_buttons.insert( ID_EDIT_CUT, ctb );

   QPixmap cp( ( const char ** ) copy_xpm );
   QToolButton *cpb = new QToolButton( cp, "Copy", 0, this, SLOT( slotEditCopy() ), tb );
   command_buttons.insert( ID_EDIT_COPY, cpb );

   QPixmap pst( ( const char ** ) paste_xpm );
   QToolButton *pb = new QToolButton( pst, "Paste", 0, this, SLOT( slotEditPaste() ), tb );
   command_buttons.insert( ID_EDIT_PASTE, pb );

   tb->addSeparator();
   QWhatsThis::whatsThisButton( tb );

   QPixmap os( ( const char ** ) objectselector_xpm );
   QToolButton *fos = new QToolButton( os, "Object Selector", 0, this, SLOT( slotObjectSelector() ), tb );
   //command_buttons.insert(ID_OBJECT_SELECTOR, os);

   QWhatsThis::add( fnb, "Click this button to create a new file.\n\n"
                    "You can also select the New command from the File menu." );
   QWhatsThis::add( fob, "Click this button to open a new file.\n\n"
                    "You can also select the Open command from the File menu." );
   QWhatsThis::add( fsb, "Click this button to save the file you are "
                    "editing. You will be prompted for a file name.\n\n"
                    "You can also select the Save command from the File menu." );
   QWhatsThis::add( udb, "Click this button to undo your last action.\n\n"
                    "You can also use the keyboard shortcut CTRL-Z." );
   QWhatsThis::add( rdb, "Click this button to redo the last action that was undone.\n\n"
                    "You can also use the keyboard shortcut CTRL-Y." );
   QWhatsThis::add( ctb, "Click this button to delete your selection and\n copy it to the clipboard.\n\n"
                    "You can also use the keyboard shortcut CTRL-X." );
   QWhatsThis::add( cpb, "Click this button to copy your selection to the clipboard.\n\n "
                    "You can also use the keyboard shortcut CTRL-C." );
   QWhatsThis::add( pb, "Click this button to paste the contents of the clipboard\n to your model.\n\n"
                    "You can also use the keyboard shortcut CTRL-V." );

   QWhatsThis::add( fos, "Click this button to bring up the object selector dialog" );

}

void I3D::initStatusBar()
{
   QLabel * l;

   l = new QLabel( statusBar(), "Camera Mode" );
   l -> setText( "  Camera : Z-zoom; X-rotate; C-pan;  " );

   lblMode = new QLabel( statusBar(), "Mode" );
   lblMode -> setText( " No Active Mode " );

   lblPlace = new QLabel( statusBar(), "Place" );
   lblPlace -> setText( " X:00.00 Y:00.00 Z:00.00 " );

   statusBar() -> message( "Ready." );
   statusBar() -> addWidget( l, 0, true );
   statusBar() -> addWidget( lblMode , 0, true );
   statusBar() -> addWidget( lblPlace, 0, true );
}

void I3D::initPlugins()
{
   m_pluginregistry = new PluginRegistry();

   //first setup the file plugins;
   QList<FilePluginWrapper> fplist;
   QList<DialogPluginWrapper> dplist;

   QList<Creator> clist;
   QList< ::Modifier > mlist;

   fplist = m_pluginregistry->getFilePlugins();

   for ( FilePluginWrapper * fp = fplist.first(); fp != 0; fp = fplist.next() )
   {
      if ( fp->plugin->isExportable() )
      {
         export_menu->insertItem( fp->plugin->getName().c_str(), fp, SLOT( slotExport() ) );
      }

      if ( fp->plugin->isImportable() )
      {
         import_menu->insertItem( fp->plugin->getName().c_str(), fp, SLOT( slotImport() ) );
      }

   }

   dplist = m_pluginregistry->getDialogPlugins();

   for ( DialogPluginWrapper * dp = dplist.first(); dp != 0; dp = dplist.next() )
   {
      plugin_menu->insertItem( dp->plugin->getName().c_str(), dp, SLOT( slotStartPlugin() ) );
      cerr << "loaded dialog plugin" << endl;
   }

   //initialize creator plugins
   clist = m_pluginregistry -> getCreatorPlugins();

   for ( Creator * c = clist.first(); c != 0; c = clist.next() )
   {
      create_menu -> insertItem( c -> getName().c_str(), c -> getPopupMenu() );
      m_controls.insert( IControlPair( c -> getControlType(), c ) );
      cerr << "Loaded Creator plugin '" << c->getName().c_str() << "'" << endl;
   }

   //initialize modifier plugins
   mlist = m_pluginregistry -> getModifierPlugins();

   for ( ::Modifier * m = mlist.first(); m != 0; m = mlist.next() )
   {
      modify_menu -> insertItem( "Fred", m, SLOT( slotActivate() ) );
      // modify_menu -> insertItem( m -> getName().c_str(), m -> getPopupMenu() );
      m_controls.insert( IControlPair( m -> getControlType(), m ) );
      cerr << "Loaded Modifier plugin '" << endl; //m->getName().c_str()<<"'"<<endl;
   }



}

void I3D::initDocument()
{
   m_document = new I3DDoc( this );
   m_document->newDocument();
}

void I3D::initView()
{


   m_workspace = new I3DWorkspace( this, "Workspace Area" );
   setCentralWidget( m_workspace );
   QString caption = "Innovation 3D";
   setCaption( caption + ": " + m_document->getFilename() );





   m_mateditor = new MatEditor();
   m_mateditor -> init();
   m_mateditor -> hide();

   m_animationctrl = new AnimationCtrl();
   //  m_animationctrl -> init();
   m_animationctrl -> hide();

   m_workspace -> init();


}

void I3D::enableCommand( int id_ )
{
   ///////////////////////////////////////////////////////////////////
   // enable menu and toolbar functions by their ID's
   // mb->setItemEnabled(id_,true);
   //  tb->setItemEnabled(id_,true);
   QToolButton * bt = command_buttons.find( id_ );

   if ( bt != 0 )
      bt->setEnabled( true );
}

void I3D::disableCommand( int id_ )
{
   ///////////////////////////////////////////////////////////////////
   // disable menu and toolbar functions by their ID's
   // mb->setItemEnabled(id_,false);
   // tb->setItemEnabled(id_,false);
   QToolButton * bt = command_buttons.find( id_ );

   if ( bt != 0 )
      bt->setEnabled( false );
}

void I3D::setRecentFiles( QList<QString> &l )
{
   recent_files.clear();
   recent_files = l;
   recent_files_menu->clear();

   for ( int i = 0 ; i < ( int ) recent_files.count(); i++ )
   {
      recent_files_menu->insertItem( *( recent_files.at( i ) ), i );
   }
}

void I3D::addRecentFile( const char* file )
{
   QString * temp = new QString();
   *temp = file;

   for ( QString * str = recent_files.first(); str != 0; str = recent_files.next() )
   {
      if ( *str == *temp )
      {
         delete temp;
         return ;
      }
   }

   if ( recent_files.count() < 5 )
      recent_files.insert( 0, temp );
   else
   {
      recent_files.remove( 4 );
      recent_files.insert( 0, temp );
   }

   recent_files_menu->clear();

   for ( int i = 0 ; i < ( int ) recent_files.count(); i++ )
   {
      recent_files_menu->insertItem( *( recent_files.at( i ) ) );
   }

}

void I3D::openDocumentFile( const char* _cmdl )
{
   slotStatusMsg( "Opening file..." );
   m_document->openDocument( _cmdl );
   slotStatusMsg( "Ready." );
}


void I3D::saveOptions()
{}


void I3D::readOptions()
{}

bool I3D::queryClose()
{
   return true; //doc->saveModified();
}

bool I3D::queryExit()
{
   saveOptions();
   return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void I3D::slotFileNewWindow()
{
   slotStatusMsg( "Opening a new Application window..." );


   slotStatusMsg( "Ready." );
}

void I3D::slotFileNew()
{
   slotStatusMsg( "Creating new document..." );

   if ( !m_document->saveModified() )
      return ;

   m_document -> newDocument();

   QString caption = "Innovation3D ";

   setCaption( caption + ": " + m_document->getFilename() );

   slotStatusMsg( "Ready." );
}

void I3D::slotFileOpen()
{
   slotStatusMsg( "Opening file..." );

   if ( !m_document -> saveModified() )
      return ;

   QString directory = getConfig() ->getString( "Directories", "Scenes" ).c_str();


   QString fileToOpen = QFileDialog::getOpenFileName( directory, "*.i3d", this, "Open File..." );

   if ( !fileToOpen.isEmpty() )
   {

      m_document->openDocument( fileToOpen );
      QString caption = "Innovation 3D";
      setCaption( caption + ": " + m_document->getFilename() );
      addRecentFile( fileToOpen );
   }

   slotStatusMsg( "Ready." );
}

void I3D::slotFileOpenRecent( int id_ )
{
   slotStatusMsg( "Opening file..." );

   if ( !m_document->saveModified() )
      return ;

   m_document->openDocument( *( recent_files.at( id_ ) ) );

   QString caption = "Innovation 3D"; //kapp->getCaption();

   setCaption( caption + ": " + m_document->getFilename() );

   slotStatusMsg( "Ready." );
}

void I3D::slotFileSave()
{
   slotStatusMsg( "Saving file..." );

   if ( m_document->getFilename().isEmpty() )
   {
      slotFileSaveAs();
      return ;
   }

   m_document->saveDocument( m_document->getFilename() );

   slotStatusMsg( "Ready." );
}

void I3D::slotShowHelp()
{
   if ( m_help == 0 )
   {
   		QString path = "";
   		QString home = "";
      m_help = new HelpWindow( home, path );
   }

   m_help -> show();

}

void I3D::slotFileSaveAs()
{
   slotStatusMsg( "Saving file under new filename..." );

   QString directory = m_config->getString( "Directories", "Scenes" ).c_str();

   QString newName = QFileDialog::getSaveFileName( directory, "*.i3d", this, "Save As..." );

   if ( !newName.isEmpty() )
   {
      if ( newName.right( 3 ) != "i3d" )
         newName += ".i3d";

      m_document->setFilename( newName );

      m_document->saveDocument( newName );

      addRecentFile( newName );

      QString caption = "Innovation 3D"; //kapp->getCaption();

      setCaption( caption + ": " + m_document->getFilename() );
   }

   slotStatusMsg( "Ready." );
}

void I3D::slotFileClose()
{
   slotStatusMsg( "Closing file..." );
   close();
}

void I3D::slotMaterialEditor()
{
   slotStatusMsg( "Editing Materials..." );
   m_mateditor->show();
}

void I3D::slotAnimationControl()
{
   slotStatusMsg( "Animating..." );
   m_animationctrl->show();
}

void I3D::slotUVEditor()
{
   slotStatusMsg( "Editing UVs..." );
}

void I3D::slotOptions()
{
   slotStatusMsg( "Configuring..." );
   m_conf -> load();
   m_conf -> show();
}

void I3D::slotFilePrint()
{
   slotStatusMsg( "Printing..." );



   slotStatusMsg( "Ready." );
}

void I3D::slotFileQuit()
{
   saveOptions();
   // close the first window, the list makes the next one the first again.
   // This ensures that queryClose() is called on each window to ask for closing
   //KTMainWindow* w;
   //if(memberList){
   // for(w=memberList->first(); w; w=memberList->first()){
   // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
   //  // the window and the application stay open.
   //   if(!w->close())
   //   break;
   // }
   //}
   close();
   qApp->quit();
}

void I3D::slotEditCut()
{
   slotStatusMsg( "Cutting selection..." );
   getWorkspace() -> getCurrentControl() -> cut();
   slotStatusMsg( "Ready." );
}

void I3D::slotEditCopy()
{
   slotStatusMsg( "Copying selection to Clipboard..." );
   getWorkspace() -> getCurrentControl() -> copy();
   slotStatusMsg( "Ready." );
}

void I3D::slotEditPaste()
{
   slotStatusMsg( "Inserting Clipboard contents..." );
   getWorkspace() -> getCurrentControl() -> paste();
   slotStatusMsg( "Ready." );
}


void I3D::slotObjectSelector()
{
   slotStatusMsg( "Object Selector..." );

   ObjectListSelector t;
   t.setCaption( "Select Objects" );
   t.show();

   slotStatusMsg( "Ready." );
}


void I3D::slotUndo()
{
   UndoStack * u = UndoStack::getInstance();

   Command *c = u->pop();

   if ( c == 0 )
      return ;

   c->undo();

   //save it on the redo stack and enable the button.
   RedoStack::getInstance() ->push( c );

   enableCommand( ID_EDIT_REDO );

   if ( u->isEmpty() )
      disableCommand( ID_EDIT_UNDO );

   workspace() ->update();
}

void I3D::slotRedo()
{
   RedoStack * r = RedoStack::getInstance();
   Command *c = r->pop();

   if ( c == 0 )
      return ;

   c->execute();

   //save it on the undo stack and enable the button.
   UndoStack::getInstance() ->push( c );

   enableCommand( ID_EDIT_UNDO );

   if ( r->isEmpty() )
      disableCommand( ID_EDIT_REDO );

   workspace() ->update();
}

void I3D::slotAddView( int v )
{
   m_workspace->addView( v, true );
   slotStatusMsg( "Added a view." );
}

void I3D::slotStatusMsg( const char *text )
{
   statusBar() ->clear();
   statusBar() ->message( text );
   statusBar() ->repaint();
   // update();
}


void I3D::slotStatusHelpMsg( const char *text )
{
   ///////////////////////////////////////////////////////////////////
   // change status message of whole statusbar temporary (text, msec)
   statusBar() ->message( text, 2000 );
   statusBar() ->repaint();
   //update();
}



void I3D::commandCallback( int id_ )
{
   switch ( id_ )
   {
      case ID_FILE_NEW_WINDOW:
         slotFileNewWindow();
         break;
      case ID_FILE_NEW:
         slotFileNew();
         break;
      case ID_FILE_OPEN:
         slotFileOpen();
         break;
      case ID_FILE_SAVE:
         slotFileSave();
         break;
      case ID_FILE_SAVE_AS:
         slotFileSaveAs();
         break;
      case ID_FILE_CLOSE:
         slotFileClose();
         break;
      case ID_FILE_PRINT:
         slotFilePrint();
         break;
      case ID_FILE_QUIT:
         slotFileQuit();
         break;

      case ID_EDIT_CUT:
         slotEditCut();
         break;
      case ID_EDIT_COPY:
         slotEditCopy();
         break;
      case ID_EDIT_PASTE:
         slotEditPaste();
         break;
      case ID_EDIT_UNDO:
         slotUndo();
         break;
      case ID_EDIT_REDO:
         slotRedo();
         break;
      case ID_TOOLS_MATEDITOR:
         slotMaterialEditor();
         break;
      case ID_TOOLS_ANICTRL:
         slotAnimationControl();
         break;
      case ID_TOOLS_UVEDITOR:
         slotUVEditor();
         break;
      case ID_TOOLS_OPTIONS:
         slotOptions();
         break;
      case ID_3DVIEW:
         slotAddView( V3D );
         break;
      case ID_XYVIEW:
         slotAddView( VXY );
         break;
      case ID_XZVIEW:
         slotAddView( VXZ );
         break;
      case ID_YZVIEW:
         slotAddView( VYZ );
         break;

      default:
         break;
   }
}

void I3D::statusCallback( int id_ )
{
   switch ( id_ )
   {
      case ID_FILE_NEW_WINDOW:
         slotStatusHelpMsg( "Opens a new application window" );
         break;
      case ID_FILE_NEW:
         slotStatusHelpMsg( "Creates a new document" );
         break;
      case ID_FILE_OPEN:
         slotStatusHelpMsg( "Opens an existing document" );
         break;
      case ID_FILE_OPEN_RECENT:
         slotStatusHelpMsg( "Opens a recently used file" );
         break;
      case ID_FILE_SAVE:
         slotStatusHelpMsg( "Save the actual document" );
         break;
      case ID_FILE_SAVE_AS:
         slotStatusHelpMsg( "Save the document as..." );
         break;
      case ID_FILE_CLOSE:
         slotStatusHelpMsg( "Closes the actual file" );
         break;
      case ID_FILE_PRINT:
         slotStatusHelpMsg( "Prints the current document" );
         break;
      case ID_FILE_QUIT:
         {
            QString caption = "Innovation 3D"; //kapp->getCaption();
            slotStatusHelpMsg( "Exits " + caption );
            break;
         }

      case ID_EDIT_CUT:
         slotStatusHelpMsg( "Cuts the selected section and puts it to the clipboard" );
         break;
      case ID_EDIT_COPY:
         slotStatusHelpMsg( "Copys the selected section to the clipboard" );
         break;
      case ID_EDIT_PASTE:
         slotStatusHelpMsg( "Pastes the clipboard contents to actual position" );
         break;
      case ID_EDIT_UNDO:
         slotStatusHelpMsg( "Undo the most recent action." );
         break;
      case ID_EDIT_REDO:
         slotStatusHelpMsg( "Redo the most recent action." );
         break;
      case ID_TOOLS_MATEDITOR:
         slotStatusHelpMsg( "Launch the Material Editor" );
         break;
      case ID_TOOLS_ANICTRL:
         slotStatusHelpMsg( "Launch the Animation Control" );
         break;
      case ID_TOOLS_UVEDITOR:
         slotStatusHelpMsg( "Launch the UV Editor" );
      case ID_TOOLS_OPTIONS:
         slotStatusHelpMsg( "Configure I3D" );
      default:
         break;
   }
}

I3D * I3D::getInstance()
{
   //if(i3d == 0)
   //  i3d = new I3D();

   return i3d;
}

I3DWorkspace * I3D::getWorkspace()
{
   return I3D::getInstance() ->workspace();
}

Config * I3D::getConfig()
{
   return I3D::getInstance() ->config();
}

MatEditor * I3D::getMatEditor()
{
   return I3D::getInstance() ->mateditor();
}

I3DDoc * I3D::getDocument()
{
   return I3D::getInstance() ->document();
}

ObjectDB * I3D::getDB()
{
   return I3D::getInstance() ->objectdb();
}

I3DWorkspace * I3D::workspace()
{
   return m_workspace;
}

Config * I3D::config()
{
   return m_config;
}

MatEditor * I3D::mateditor()
{
   return m_mateditor;
}

I3DDoc * I3D::document()
{
   return m_document;
}

ObjectDB * I3D::objectdb()
{
   return m_document->getObjectDB();
}

void I3D::updateViews()
{
   I3D::getWorkspace() ->update();

}

void I3D::slotUpdateViews()
{
	updateViews();
}

void I3D::setModeMsg( char *c )
{
   I3D::getInstance() -> set_mode_msg( c );
}

void I3D::set_mode_msg( char *c )
{
   lblMode -> setText( c );
}

void I3D::setPlaceLabel( char *c )
{
   I3D::getInstance() -> set_place_label( c );
}

void I3D::set_place_label( char *c )
{
   lblPlace -> setText( c );
}

void I3D::activateControl( int c )
{
   I3D::getInstance() -> activate_control( c );
}

void I3D::activate_control( int c )
{
   IControlMap::iterator it = m_controls.find( c );

   if ( it == m_controls.end() )
   {
      cerr << "Request to activate Unknown control." << endl;
      return ;
   }

   IControl * ctrl = it -> second;

   ctrl -> activate();

}































































