/***************************************************************************
                          i3ddoc.h  -  description
                             -------------------                                         
    begin                : Sat Aug 14 10:38:16 CDT 1999
                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef I3DDOC_H
#define I3DDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <vector>


class Entity;
//local includes

// forward declaration of the I3D classes
class I3DWorkspace;
class Material;
class Texture;
class RevolveObject;
class ExtrudeObject;
class ObjectDB;
class Vertex;
class Object;


/**	I3DDoc provides a document object for a document-view model.
  *
	* @author Jon Anderson 	
	* @version 0.1
	*/
class I3DDoc : public QObject
{
  Q_OBJECT

 public:
  I3DDoc(QWidget* parent, const char *name=0);
  ~I3DDoc();
	
	 void setModified(bool modified=true){ b_modified=modified; }
   bool isModified(){ return b_modified;}
	bool saveModified();	
	
	void deleteContents();
	bool newDocument();
	void closeDocument();
	
	bool openDocument(const char* filename, const char* format=0);
  bool saveDocument(const char* filename, const char* format=0);
	
	void setFilename(const char *filename);
	const QString & getFilename() const {return m_filename;}
	
	void draw();
	
	ObjectDB *getObjectDB(){return db;};
	
 public slots:

signals:
	void entityChanged(Entity *e); 	
 	
 public:	

 private:
 	/** the modified flag of the current document */
 	bool b_modified;
	QString m_filename;
	/**Object database */
	ObjectDB *db;
	
	int num_selected;
	int *current_selected;
	vector<Entity *> *clipboard;

};

#endif // I3DDOC_H







































