/*
 * libtu/stringstore.c
 *
 * Copyright (c) Tuomo Valkonen 2004. 
 *
 * You may distribute and modify this library under the terms of either
 * the Clarified Artistic License or the GNU LGPL, version 2.1 or later.
 */

#include <stdlib.h>

#include "misc.h"
#include "output.h"
#include "rb.h"
#include "stringstore.h"


static Rb_node stringstore=NULL;


const char *stringstore_get(StringId id)
{
    return (const char*)(((Rb_node)id)->k.key);
}

    
StringId stringstore_find(const char *str)
{
    Rb_node node;
    int found=0;
    
    if(stringstore==NULL)
        return STRINGID_NONE;
    
    node=rb_find_key_n(stringstore, str, &found);
    
    if(!found)
        return STRINGID_NONE;
    
    return (StringId)node;
}


StringId stringstore_alloc(const char *str)
{
    Rb_node node=(Rb_node)stringstore_find(str);
    char *s;
    
    if(node!=NULL){
        node->v.ival++;
        return node;
    }
    
    if(stringstore==NULL){
        stringstore=make_rb();
        if(stringstore==NULL)
            return STRINGID_NONE;
    }
    
    s=scopy(str);
    
    if(s==NULL)
        return STRINGID_NONE;
    
    node=rb_insert(stringstore, s, NULL);
    
    if(node==NULL)
        return STRINGID_NONE;
    
    node->v.ival=1;
        
    return (StringId)node;
}


void stringstore_free(StringId id)
{
    Rb_node node=(Rb_node)id;
    
    if(node==NULL){
        warn("Attempt to free un-allocated string from stringstore.");
        return;
    }
    
    if(node->v.ival<=0){
        warn("Stringstore reference count corrupted.");
        return;
    }
    
    node->v.ival--;
    
    if(node->v.ival==0){
        char *s=(char*)(node->k.key);
        rb_delete_node(node);
        free(s);
    }
}

