/*
 *
 * $Id: postgre.c, v 0.9 2001/04/06 23:22:45 kaiser Exp $
 *
 * postgresql backend to ipac
 * Copyright (C) 2001 Al Zaharov
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author can be reached via email: kaiser13@mail2000.ru, or by 
 * fido: Al_Zaharov@p88.f58.n5005.z2.fidonet.org
 *
*/

#include "ipac.h"
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/param.h>
#include <unistd.h>
#include <libpq-fe.h>

//#define DEBUG_POST
#undef DEBUG_POST

static char *pgoptions = NULL;
static char *pgtty = NULL;

static char *pgname = DBASE;
static char *pgport = DBASE_PORT;
static char *pghost = FETCH_HOST;
static char *pglogin = FETCH_LOGIN;
static char *pgpwd = FETCH_PASS;

#ifdef DEBUG_POST
static char *log_file = "/post_log";
static FILE *logs;
#endif

static PGconn *conn;
static PGresult *res;

/* plain file ipac interface entries */
int postg_ipac_open(int flag);
int postg_ipac_get_user_list(user_list **list);
int postg_ipac_get_raw_list(char *ag_name, char *login, raw_rule_type **data);
double postg_ipac_get_cash(char *login);
int postg_ipac_set_cash(char *login, double cash);
double postg_ipac_get_price(char *rule_name);
double postg_ipac_get_kredit(char *login);
int postg_ipac_get_pay_type(char *rule_name);
char * postg_ipac_get_last_paid(char *service_name);
int postg_ipac_set_last_paid(char *login, char *paid);
int postg_ipac_login(char *login);
int postg_ipac_logout(char *login, double cash);
int postg_ipac_close();

static const access_agent_t interface_entry = {
	"postg",
	postg_ipac_open,
	postg_ipac_get_user_list,
	postg_ipac_get_raw_list,
	postg_ipac_get_cash,
	postg_ipac_set_cash,
	postg_ipac_get_price,
	postg_ipac_get_kredit,
	postg_ipac_get_pay_type,
	postg_ipac_get_last_paid,
	postg_ipac_set_last_paid,
	postg_ipac_login,
	postg_ipac_logout,
	postg_ipac_close
};

const access_agent_t *ipac_ac_interface_postg() {
	return &interface_entry;
}

int postg_ipac_open(int flag)
{
//	conn=PQsetdb(pghost, pgport, pgoptions, pgtty, pgname);
	conn=PQsetdbLogin(pghost, pgport, pgoptions, pgtty, pgname, pglogin,
								    pgpwd);
	if (verbose>2)
		fprintf(stderr, "postg access agent: opening database %s\n", pgname);
	if(PQstatus(conn) == CONNECTION_BAD) {
		fprintf(stderr, "Connection to database '%s' failed.\n", pgname);
    		fprintf(stderr, "%s", PQerrorMessage(conn));
    		PQfinish(conn);
    		return(1);
	}
#ifdef DEBUG_POST
	logs=fopen(log_file, "a+");
	fprintf(logs, "%lu : postg_ipac_open\n", time(NULL));
#endif        
	return(0);
}

int
postg_ipac_get_user_list(user_list **list)
{
	int i;
	long nr_users;
	user_list *last_name, *name;
	char wh_exec[250];

	sprintf(wh_exec, "select count(distinct login) from customers");
	if (verbose>2)
		fprintf(stderr, "postg access agent: %s\n", wh_exec);
	res = PQexec(conn, wh_exec);
	if (PQntuples(res)<1) {
		fprintf(stderr, "\n");
		return 1;
	}
	nr_users = strtol(PQgetvalue(res,0,0),0,0);
	PQclear(res);
	sprintf(wh_exec, "select login, ip_addr, pause 
					    from customers order by login");
	if (verbose>2)
		fprintf(stderr, "postg access agent: %s\n", wh_exec);
	res = PQexec(conn, wh_exec);

	last_name = *list = NULL;
	for (i=0; i<PQntuples(res); i++) {
		name = new_user();
		strncpy(name->login, (char *)PQgetvalue(res, i, 0), MAX_RULE_NAME_LENGTH);
		strncpy(name->ip, (char *)PQgetvalue(res, i, 1), MAX_RULE_NAME_LENGTH);
		if ((PQgetvalue(res, i, 2)[0] == 't'))
			name->pause = 1;
		else 
			name->pause = 0;
		if (last_name != NULL)
			last_name->next = name;
		last_name = name;
		if (*list == NULL)
			*list = name;
	}
	PQclear(res);

	return 0;
}

/*
 * 
 */
int 
postg_ipac_get_raw_list(char *ag_name, char *login, raw_rule_type **data)
{
        char buf[450];
        char buf1[100];
	user_list *ul, *ul1;
	int i;
	raw_rule_type *r, *r1;
	char name[MAX_RULE_NAME_LENGTH+10];
	
	if (*login && login[0]!='\0') {
		strcpy(name, login);
		strcat(name, "*");
	} else
		strcpy(name, "*");
		
	access_agent->get_user_list(&ul);
	ul1 = ul;
	*data = r1 = NULL;
// create all chains
	while(ul) {
		r = new_raw_rule();
		if (r1 == NULL)
			*data = r;
		else
			r1->next = r;
		r1 = r;
		strcpy(r->name, "%chain% ");
		strcpy(r->name+8, ul->login);
		strcpy(r->name+strlen(r->name), " out");
		strcpy(r->dest, "out");
		strcpy(r->snet, ul->ip);
		strcpy(r->dnet, "0/0");
		r = new_raw_rule();
		r1->next = r;
		r1 = r;
		strcpy(r->name, "%chain% ");
		strcpy(r->name+8, ul->login);
		strcpy(r->name+strlen(r->name), " in");
		strcpy(r->dest, "in");
		strcpy(r->snet, "0/0");
		strcpy(r->dnet, ul->ip);
		if (memcmp(ul->login, "admin", 5)) {
			r = new_raw_rule();
			r1->next = r;
			r1 = r;
			strcpy(r->name, "%chain% ");
			strcpy(r->name+8, ul->login);
			strcpy(r->name+strlen(r->name), " out ctrl");
			strcpy(r->dest, CH_CTRL_OUT);
			strcpy(r->snet, ul->ip);
			strcpy(r->direction, "out");
			strcpy(r->dnet, "0/0");
			r = new_raw_rule();
			r1->next = r;
			r1 = r;
			strcpy(r->name, "%chain% ");
			strcpy(r->name+8, ul->login);
			strcpy(r->name+strlen(r->name), " in ctrl");
			strcpy(r->dest, CH_CTRL_IN);
			strcpy(r->snet, "0/0");
			strcpy(r->dnet, ul->ip);
			strcpy(r->direction, "in");
		}
		ul=ul->next;
	}
	sprintf(buf, "SELECT "
		"login||' - '||serv_name, ip_addr, ip_net, sport, dport, dest, "
		"proto, iface, login, pause, tariffs.detailed "
		"from customers, services_names, services, "
		"nets, tariffs, nets_names "
		"where tariffs.tariff_id=services.tariff_id and "
		"tariffs.cust_id=customers.cust_id and "
		"services_names.serv_id=services.serv_id and "
		"nets.net_id=services.net_id and "
		"nets_names.net_id=nets.net_id ");
	if (*login && login[0] != '\0') {
		sprintf(buf1, "and login='%s' ", login);
		strcpy(buf+strlen(buf), buf1);
	}
	if (*ag_name && ag_name[0] != '\0') {
		sprintf(buf1, "and agent='%s' ", ag_name);
		strcpy(buf+strlen(buf), buf1);
	}
	strcpy(buf+strlen(buf), "order by customers.login, nets_names.glob\n");
#ifdef DEBUG_POST
	fprintf(logs,"%lu : postg_ipac_get_raw_list\n%s\n", time(NULL), buf);
	fflush(logs);
#endif
	res = PQexec(conn, buf);
	for (i=0; i<PQntuples(res); i++)
	{
		r = new_raw_rule();
		r1->next = r;
		r1 = r;
		strncpy(r->name, PQgetvalue(res, i, 0), PQgetlength(res, i, 0));
		r->name[PQgetlength(res, i, 0)] = '\0';

		strncpy(r->dest, PQgetvalue(res, i, 5), PQgetlength(res, i, 5));
		r->dest[PQgetlength(res, i, 5)] = '\0';

		if (!memcmp(r->dest, "out",3))
		{
			strcpy(r->snet, PQgetvalue(res, i, 1));
			strcpy(r->dnet, PQgetvalue(res, i, 2));
			strcpy(r->direction, "out");
		} else {
			strcpy(r->dnet, PQgetvalue(res, i, 1));
			strcpy(r->snet, PQgetvalue(res, i, 2));
			strcpy(r->direction, "in");
		}
		strcpy(r->dest, PQgetvalue(res, i, 8));
		strcpy(r->dest+strlen(r->dest), " ");
		strcpy(r->dest+strlen(r->dest), PQgetvalue(res, i, 5));
		strncpy(r->sport, PQgetvalue(res, i, 3), PQgetlength(res, i, 3));
		r->sport[PQgetlength(res, i, 3)] = '\0';
		strncpy(r->dport, PQgetvalue(res, i, 4), PQgetlength(res, i, 4));
		r->dport[PQgetlength(res, i, 4)] = '\0';
		
		strncpy(r->protocol, PQgetvalue(res, i, 6), 
						    PQgetlength(res, i, 6));
		r->protocol[PQgetlength(res, i, 6)] = '\0';
		strncpy(r->iface, PQgetvalue(res, i, 7), PQgetlength(res, i, 7));
		r->iface[PQgetlength(res, i, 7)] = '\0';
// add identical rules for control
		if (memcmp(r->name, "admin", 5)) {
			if (PQgetvalue(res, i, 9)[0] == 't')
				strcpy(r->policy, "DROP");
			else 
				if (PQgetvalue(res, i, 10)[0] == 't')
					strcpy(r->policy, "QUEUE");
				else
					strcpy(r->policy, "RETURN");
			r = new_raw_rule();
			memcpy(r, r1, sizeof(raw_rule_type));
			r1->next = r;
			r1 = r;
			strcpy(r->dest+strlen(r->dest), " ctrl");
			strcpy(r->direction, r1->direction);
			strcpy(r->policy, "DROP");
		} else
			strcpy(r->policy, "RETURN");
//			r->policy[0]='\0';
		
	}
// drop all other packets from user
	ul = ul1;
	while(ul) {
		if (memcmp(ul->login, "admin", 5)) {
			r = new_raw_rule();
			r1->next = r;
			r1 = r;
			strcpy(r->name, ul->login);
			strcpy(r->name+strlen(r->name), " stopper");
			strcpy(r->dest, ul->login);
			strcpy(r->dest+strlen(r->dest), " out ctrl");
			strcpy(r->dnet, "0/0");
			strcpy(r->policy, "DROP");
			strcpy(r->snet, ul->ip);
			r = new_raw_rule();
			r1->next = r;
			r1 = r;
			strcpy(r->name, ul->login);
			strcpy(r->name+strlen(r->name), " stopper");
			strcpy(r->dest, ul->login);
			strcpy(r->dest+strlen(r->dest), " in ctrl");
			strcpy(r->snet, "0/0");
			strcpy(r->policy, "DROP");
			strcpy(r->dnet, ul->ip);
		}
		ul = ul->next;
	}

	PQclear(res);
	
	return 0;
}

/*
 * get a balance of the account, input may be a login name or a rule name
 * returns 1 in case there is no such account
 */
double postg_ipac_get_cash(char *login)
{
	char wh_exec[300];
	double cash=0;
	char *name;
	
	name = xstrdup(login);
	name = strtok(name, " ");	//Only first word is needed
	while(strtok(NULL, " "));
	sprintf(wh_exec,
		"select cash from cash, customers "
		"where cash.cust_id=customers.cust_id "
		"and customers.login='%s'", name);
	res = PQexec(conn, wh_exec);
	if (PQntuples(res)>0)
		cash = strtod(PQgetvalue(res, 0, 0), NULL);
	PQclear(res);
	free(name);
	return cash;
}

/*
 * get a kredit of the account, input may be a login name
 */
double 
postg_ipac_get_kredit(char *login)
{
	char wh_exec[300];
	double kredit=0;
	char *name;
	
	name = xstrdup(login);
	name = strtok(name, " ");	//Only first word is needed
	while(strtok(NULL, " "));
	sprintf(wh_exec,
		"select kredit from cash, customers "
		"where cash.cust_id=customers.cust_id "
		"and customers.login='%s'", name);
	res = PQexec(conn, wh_exec);
	if (PQntuples(res)>0)
		kredit = strtod(PQgetvalue(res, 0, 0), NULL);
	PQclear(res);
	free(name);
	return kredit;
}


int 
postg_ipac_set_cash(char *login, double cash)
{
	char wh_exec[300];
	char *name;
	
	name = xstrdup(login);
	res = PQexec(conn, "BEGIN");
	PQclear(res);
	name = strtok(name, " ");	//Only first word is needed
	while(strtok(NULL, " "));

	sprintf(wh_exec, "update cash set cash='%f' "
		"where cash.cust_id=customers.cust_id "
		"and customers.login='%s'", cash, name);
	res = PQexec(conn, wh_exec);
	PQclear(res);
	res = PQexec(conn, "COMMIT");
	PQclear(res);
	free(name);
	return 0;
}

double 
postg_ipac_get_price(char *rule_name)
{
	double tmp=0;
	char wh_exec[500];

	sprintf(wh_exec, "select price "
		"from tariffs, services, services_names, customers "
		"where tariffs.tariff_id=services.tariff_id and "
		"services.serv_id=services_names.serv_id and "
		"tariffs.cust_id=customers.cust_id and "
		"customers.login||' - '||services_names.serv_name='%s'", 
								    rule_name);
	res = PQexec(conn, wh_exec);
	if (PQntuples(res)>0)
		tmp = strtod(PQgetvalue(res, 0, 0), NULL);
	PQclear(res);
	return tmp;
}

/*
 * Reads pay type from database, in case there is no entry for this
 * rule returns 0 - free
 */
int 
postg_ipac_get_pay_type(char *login)
{
	int tmp=0;
	char wh_exec[450];

	sprintf(wh_exec, "select pr_type "
		"from tariffs, services_names, customers, services "
		"where tariffs.tariff_id=services.tariff_id and "
		"customers.cust_id=tariffs.cust_id and "
		"services.serv_id=services_names.serv_id and "
		"customers.login||' - '||services_names.serv_name='%s'", login);
	res = PQexec(conn, wh_exec);
	if (PQntuples(res)>0)
		tmp = strtol(PQgetvalue(res,0,0),0,0);
	PQclear(res);
	return tmp;
}

char *
postg_ipac_get_last_paid(char *service_name)
{
	char *tmp;
	char wh_exec[350];

	sprintf(wh_exec, "select age(last_paid) "
            "from tariffs, services, services_names, customers "
            "where "
            "tariffs.tariff_id=services.tariff_id and "
            "services.serv_id=services_names.serv_id and "
            "customers.cust_id=tariffs.cust_id and "
            "customers.login||' - '||services_names.serv_name='%s'",
                                                            service_name);
	res = PQexec(conn, wh_exec);
	if (PQntuples(res)>0) {
		tmp = xstrdup(PQgetvalue(res,0,0));
	} else
		tmp = xstrdup("");
	PQclear(res);
	return tmp;
}

int 
postg_ipac_set_last_paid(char *login, char *paid)
{
	char wh_exec[550];

	res = PQexec(conn, "BEGIN");
	PQclear(res);
	sprintf(wh_exec, "update tariffs set last_paid=((select last_paid from "
	    "tariffs, services, services_names, customers where "
	    "tariffs.tariff_id=services.tariff_id and "
	    "services.serv_id=services_names.serv_id and "
	    "customers.cust_id=tariffs.cust_id and "
	    "customers.login||' - '||services_names.serv_name='%s') "
	    "+ interval '%s') "
	    "where "
	    "tariffs.tariff_id=services.tariff_id and "
	    "services.serv_id=services_names.serv_id and "
	    "customers.cust_id=tariffs.cust_id and "
	    "customers.login||' - '||services_names.serv_name='%s'", 
							login, paid, login);
	res = PQexec(conn, wh_exec);
	PQclear(res);
	res = PQexec(conn, "COMMIT");
	PQclear(res);
	return 0;
}

int postg_ipac_close()
{
//    PQclear(res);
#ifdef DEBUG_POST
    fprintf(logs, "%lu : postg_ipac_close\n", time(NULL));
    fclose(logs);
    fflush(logs);
#endif    
    PQfinish(conn);
    return 0;
}

// enable some services for user (depending of cash on)
int
postg_ipac_login(char *login)
{
	char wh_exec[600];
	double cash;
	double kredit;
	unsigned long active;
	int i, tmp;
	user_list *u, *u1, *ul;

	cash = postg_ipac_get_cash(login);
	kredit = postg_ipac_get_kredit(login);
	if (kredit+cash<0) {
		printf("not enough cash - login disallowed\n");
		return 1;
	}
	// form services list
	sprintf(wh_exec, "select distinct "
		"login||' - '||serv_name, active_nocash, pause "
		"from customers, services_names, services, "
		    "nets, tariffs, nets_names "
		"where tariffs.tariff_id=services.tariff_id and "
		    "tariffs.cust_id=customers.cust_id and "
		    "services_names.serv_id=services.serv_id and "
		    "nets.net_id=services.net_id and "
		    "nets_names.net_id=nets.net_id and "
		    "customers.login='%s'", login);
	if (cash<0)
		sprintf(wh_exec+strlen(wh_exec), " and tariffs.active_nocash=1");
	res = PQexec(conn, wh_exec);

	if (PQntuples(res)<1) {
		printf("user '%s' not found, login failed\n", login);
		return 1;
	}
	tmp = PQntuples(res);
	// at first, create list (because postg funcs are not reentrant)
	ul = u = u1 = NULL;
	for (i=0; i<tmp; i++) {
		active = strtoul((char *)PQgetvalue(res, i, 1), 0, 0);
		if (((cash>0) || (active==1)) && 
				    (strtod(PQgetvalue(res, i, 2), NULL)==0)) {
			u = new_user();
			strcpy(u->login, (char *)PQgetvalue(res, i, 0));
			if (u1 == NULL)
				ul = u;
			else
				u1->next = u;
			u1 = u;
		} // created
	}
	PQclear(res);
	acc_agent->init(0);
	while (ul) {
		if (verbose>1)
			printf("Accepting '%s'\n", ul->login);
		acc_agent->accept(ul->login);
		ul=ul->next;
	}
	return 0;
}

// disable *all* services for user login
int
postg_ipac_logout(char *login, double cash)
{
	unsigned long active;
	char wh_exec[400];
	double kredit;
	char *login_name;
	char *login1;
	int tmp=0;
	
	login1=xstrdup(login);

        login_name = strsep(&login1, " \0");
	while(strsep(&login1, " \0"));
	kredit=postg_ipac_get_kredit(login_name);
	
	if (kredit+cash>0) {
		sprintf(wh_exec, "select active_nocash "
			"from tariffs, services, services_names, customers "
			"where tariffs.tariff_id=services.tariff_id and "
			"customers.cust_id=tariffs.cust_id and "
			"services.serv_id=services_names.serv_id and "
			"customers.login||' - '||services_names.serv_name='%s'", 
									login);
		res = PQexec(conn, wh_exec);
		if (PQntuples(res)>0) {
			active = strtoul(PQgetvalue(res,0,0), 0, 0);
		} else {
			active = 0;
			tmp=1;
		}
		PQclear(res);

		if (active==0)
			acc_agent->deny(login);
	} else
		acc_agent->deny(login);
	free(login1);
	return 0;
}
