/*
 sql.c : sql plugin for irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "sql.h"

static PLUGIN_REC *plug;

gchar *plugin_sql_addslashes(gchar *str)
{
    gchar *ret, *p;
    gint len;

    g_return_val_if_fail(str != NULL, NULL);

    /* the string size with slashes.. */
    len = 0;
    for (p = str; *p != '\0'; p++, len++)
    {
	if (*p == '\'' || *p == '\\' || *p == '"')
	    len++;
    }

    /* add slashes */
    p = ret = g_malloc(len+1);
    while (*str != '\0')
    {
        if (*str == '\'' || *str == '\\' || *str == '"')
            *p++ = '\\';
        *p++ = *str++;
    }
    *p = '\0';
    return ret;
}

gchar *plugin_description(void)
{
    return "SQL plugin";
}

gint plugin_version(void)
{
    return PLUGIN_LAYER_VERSION;
}

/* If we call plugin_deinit() in this code, it doesn't necessarily point to
   _THIS_ module's plugin_deinit() but instead some other module's.. So,
   we create static deinit() function which should be used.. */
static void deinit(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    plugin_sql_setup_deinit(plugin);
    plugin_sql_mysql_deinit(plugin);

    g_free(data);
}

void plugin_deinit(PLUGIN_REC *plugin)
{
    deinit(plugin);
}

gboolean plugin_init(gint gui, PLUGIN_REC *plugin, gchar *args)
{
    PLUGIN_DATA *data;

    plug = plugin;
    plugin->data = data = g_new0(PLUGIN_DATA, 1);
    data->plugin = plugin;

    plugin_sql_setup_init(plugin);
    if (!plugin_sql_mysql_init(plugin))
    {
	/* mysql initialization failed */
	printtext(NULL, NULL, MSGLEVEL_CLIENTERROR, "Couldn't connect to database - plugin not loaded");
	deinit(plugin);
	return FALSE;
    }

    data->loaded = TRUE;
    return TRUE;
}
