#ifndef __GUI_CHANNELS_H
#define __GUI_CHANNELS_H

#define CHANNEL_GUI(a) ((GUI_CHANNEL_REC *) ((a)->gui_data))

typedef struct
{
    guint servermenu:1; /* display server menu */
    guint autoraise:1; /* Auto raise this window when new text appears */
    guint nicklist:1; /* Display nicklist */
    gint nicklist_pos; /* Paned tag position */
    GList *who_tags;

    GdkFont *font_normal, *font_bold;

#ifdef HAVE_GNOME_PANEL
    GtkWidget *panelframe; /* for pixmapped buttons */
    GtkWidget *panellabel;
    gint panelpos;
#endif

    time_t gone_oldest; /* oldest gone nick record in this channel */
}
GUI_CHANNEL_REC;

gchar *gui_channel_get_name(CHANNEL_REC *channel);

gboolean gui_channel_active(CHANNEL_REC *channel);

void gui_channels_init(void);
void gui_channels_deinit(void);

#endif
