/*
 wordclick.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "gui-nicklist-popup.h"

static gint execstr(gchar *cmd, gchar *word)
{
    gchar *str;
    gint ret;

    g_return_val_if_fail(cmd != NULL, 0);
    g_return_val_if_fail(word != NULL, 0);

    str = g_strdup_printf(cmd, word);
    ret = execute(str);
    g_free(str);

    return ret;
}

static void word_menu_sendmail(GtkWidget *menuitem)
{
    gchar *word;

    g_return_if_fail(menuitem != NULL);

    word = gtk_object_get_data(GTK_OBJECT(menuitem->parent), "word");
    execstr(setup_get_str("url_mail_client"), word);
}

static void word_menu_open_www(GtkWidget *menuitem)
{
    gchar *word;

    g_return_if_fail(menuitem != NULL);

    word = gtk_object_get_data(GTK_OBJECT(menuitem->parent), "word");
    execstr(setup_get_str("url_www_client"), word);
}

static void word_menu_open_ftp(GtkWidget *menuitem)
{
    gchar *word;

    g_return_if_fail(menuitem != NULL);

    word = gtk_object_get_data(GTK_OBJECT(menuitem->parent), "word");
    execstr(setup_get_str("url_ftp_client"), word);
}

static void word_menu_join(GtkWidget *menuitem, SERVER_REC *server)
{
    gchar *word;

    g_return_if_fail(menuitem != NULL);

    word = gtk_object_get_data(GTK_OBJECT(menuitem->parent), "word");
    signal_emit("command join", 3, word, server, cur_channel);
}

static void word_menu_query(GtkWidget *menuitem, SERVER_REC *server)
{
    gchar *word;

    g_return_if_fail(menuitem != NULL);

    word = gtk_object_get_data(GTK_OBJECT(menuitem->parent), "word");
    signal_emit("command query", 3, word, server, cur_channel);
}

void word_clicked(WINDOW_REC *window, gchar *word, GtkWidget *menu, GdkEventButton *event)
{
    GtkWidget *menuitem;
    gchar *entry, *tmp, max[20];
    GString *str;
    gboolean dblclick;

    g_return_if_fail(window != NULL);
    g_return_if_fail(word != NULL);
    g_return_if_fail(event != NULL);

    dblclick = event->type == GDK_2BUTTON_PRESS;
    if (event->button != 1 && event->button != 3) return; /* use only left & right buttons */

    entry = gtk_entry_get_text(GTK_ENTRY(WINDOW_GUI(window)->parent->entry));
    menuitem = NULL;

    str = g_string_new(NULL);
    strncpy(max, word, sizeof(max)-1); max[sizeof(max)-1] = '\0';

    if (ischannel(*word))
    {
        /* irc channel */
        if (event->button == 3)
        {
            g_string_sprintf(str, _("Join %s"), max);
            menuitem = popup_add(menu, str->str, word_menu_join, window->active->server);
        }
        else if (dblclick)
            signal_emit("command join", 3, word, window->active->server, window->active);
    }
    else if (nicklist_find(window->active, word) != NULL)
    {
        /* nick */
        if (event->button == 3)
            gui_nicklist_popup(menu, window->active, word, event);
        else if (dblclick)
            signal_emit("command query", 3, word, window->active->server, window->active);
    }
    else if (strncmp(word, "http://", 7) == 0 || strncmp(word, "www.", 4) == 0)
    {
        /* WWW URL */
        if (event->button == 3)
        {
            g_string_sprintf(str, _("Open HTTP page %s"), max);
            menuitem = popup_add(menu, str->str, word_menu_open_www, window->active->server);
        }
        else if (dblclick)
            execstr(setup_get_str("url_www_client"), word);
    }
    else if (strncmp(word, "ftp://", 6) == 0 || strncmp(word, "ftp.", 4) == 0)
    {
        /* FTP URL */
        if (event->button == 3)
        {
            g_string_sprintf(str, _("Open FTP page %s"), max);
            menuitem = popup_add(menu, str->str, word_menu_open_ftp, window->active->server);
        }
        else if (dblclick)
            execstr(setup_get_str("url_ftp_client"), word);
    }
    else if ((tmp = strchr(word, '@')) != NULL && strchr(tmp, '.') != NULL)
    {
        /* E-mail address */
        if (event->button == 3)
        {
            g_string_sprintf(str, _("Send email to %s"), max);
            menuitem = popup_add(menu, str->str, word_menu_sendmail, window->active->server);
        }
        else
        {
            if (strncmp(word, "mailto:", 7) == 0) word += 7;
            if (dblclick) execstr(setup_get_str("url_mail_client"), word);
        }
    }
    else if (window->active != NULL && window->active->level & MSGLEVEL_MSGS)
    {
        /* msgs window, create query with doubleclick */
        if (event->button == 3)
        {
            g_string_sprintf(str, _("Query %s"), max);
            menuitem = popup_add(menu, str->str, word_menu_query, window->active->server);
        }
        else if (dblclick)
            signal_emit("command query", 3, word, window->active->server, window->active);
        else
        {
            /* check if word is a server tag */
            SERVER_REC *server;

            server = server_find_tag(word);
            if (server != NULL)
            {
                /* change server.. */
                window->active->server = server;
                signal_emit("channel server changed", 1, window->active);
            }
            else if (*entry == '\0' && *word != '\0')
            {
                /* put "/msg word" in entry */
                GString *str;

                str = g_string_new(NULL);
                g_string_sprintf(str, "/msg %s ", word);
                gtk_entry_set_text(GTK_ENTRY(WINDOW_GUI(window)->parent->entry), str->str);
                g_string_free(str, TRUE);
            }
        }
    }
    g_string_free(str, TRUE);

    if (menuitem != NULL)
    {
        word = g_strdup(word);
        popup_add(menu, NULL, NULL, NULL);
        gtk_object_set_data(GTK_OBJECT(menu), "word", word);
        gtk_signal_connect_object(GTK_OBJECT (menu), "selection_done",
                                  GTK_SIGNAL_FUNC(g_free), (GtkObject *) word);
    }
}
