#ifndef __NICKLIST_H
#define __NICKLIST_H

typedef struct
{
    time_t last_check; /* last time gone was checked */
    gboolean send_massjoin; /* Waiting to be sent in massjoin signal */

    gchar *nick;
    gchar *host;
    gchar *realname;

    guint op:1;
    guint voice:1;
    guint gone:1;
    guint ircop:1;
}
NICK_REC;

/* Add new nick to list */
NICK_REC *nicklist_insert(CHANNEL_REC *channel, gchar *nick, gboolean op, gboolean voice, gboolean send_massjoin);
/* remove nick from list */
void nicklist_remove(CHANNEL_REC *channel, NICK_REC *nick);
/* Find nick record from list */
NICK_REC *nicklist_find(CHANNEL_REC *channel, gchar *mask);
/* Get list of nicks */
GList *nicklist_getnicks(CHANNEL_REC *channel);

/* nick record comparision for sort functions */
gint nicklist_compare(NICK_REC *p1, NICK_REC *p2);

gchar *nick_strip(gchar *nick);

void nicklist_init(void);
void nicklist_deinit(void);

#endif
