
/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: log.c,v 1.7 2005/05/12 01:42:34 ro_han Exp $
 *****************************************************************************/

#include "log.h"

static void ivm_log(int priority, const char *format, va_list args)
{
    openlog(PACKAGE_NAME, 0, LOG_USER);
    vsyslog(priority, format, args);
    closelog();
}

void log_error(const char *format, ...)
{
    va_list ap;

    va_start(ap, format);
    ivm_log(LOG_ERR, format, ap);
}

void log_notice(const char *format, ...)
{
    va_list ap;

    va_start(ap, format);
    ivm_log(LOG_NOTICE, format, ap);
}

void log_debug(const char *format, ...)
{
    va_list ap;

    va_start(ap, format);
    ivm_log(LOG_DEBUG, format, ap);
}

void log_vdebug(const char *format, va_list ap)
{
    ivm_log(LOG_DEBUG, format, ap);
}
