/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Interval;
import java.util.Vector;

public final class IntCharSet {
    private static final boolean DEBUG = false;
    private Vector intervalls;
    private int pos;

    public IntCharSet() {
        this.intervalls = new Vector();
    }

    public IntCharSet(char c) {
        this(new Interval(c, c));
    }

    public IntCharSet(Interval intervall) {
        this();
        this.intervalls.addElement(intervall);
    }

    public IntCharSet(Vector chars) {
        int size = chars.size();
        this.intervalls = new Vector(size);
        for (int i = 0; i < size; ++i) {
            this.add((Interval)chars.elementAt(i));
        }
    }

    private int indexOf(char c) {
        int start = 0;
        int end = this.intervalls.size() - 1;
        while (start <= end) {
            int check = (start + end) / 2;
            Interval i = (Interval)this.intervalls.elementAt(check);
            if (start == end) {
                return i.contains(c) ? start : -1;
            }
            if (c < i.start) {
                end = check - 1;
                continue;
            }
            if (c > i.end) {
                start = check + 1;
                continue;
            }
            return check;
        }
        return -1;
    }

    public IntCharSet add(IntCharSet set) {
        for (int i = 0; i < set.intervalls.size(); ++i) {
            this.add((Interval)set.intervalls.elementAt(i));
        }
        return this;
    }

    public void add(Interval intervall) {
        int size = this.intervalls.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = (Interval)this.intervalls.elementAt(i);
            if (elem.end + '\u0001' < intervall.start) continue;
            if (elem.contains(intervall)) {
                return;
            }
            if (elem.start > intervall.end + '\u0001') {
                this.intervalls.insertElementAt(new Interval(intervall), i);
                return;
            }
            if (intervall.start < elem.start) {
                elem.start = intervall.start;
            }
            if (intervall.end <= elem.end) {
                return;
            }
            elem.end = intervall.end;
            ++i;
            while (i < size) {
                Interval x = (Interval)this.intervalls.elementAt(i);
                if (x.start > elem.end + '\u0001') {
                    return;
                }
                elem.end = x.end;
                this.intervalls.removeElementAt(i);
                --size;
            }
            return;
        }
        this.intervalls.addElement(new Interval(intervall));
    }

    public void add(char c) {
        int size = this.intervalls.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = (Interval)this.intervalls.elementAt(i);
            if (elem.end + '\u0001' < c) continue;
            if (elem.contains(c)) {
                return;
            }
            if (elem.start > c + '\u0001') {
                this.intervalls.insertElementAt(new Interval(c, c), i);
                return;
            }
            if (c + '\u0001' == elem.start) {
                elem.start = c;
                return;
            }
            elem.end = c;
            if (i + 1 >= size) {
                return;
            }
            Interval x = (Interval)this.intervalls.elementAt(i + 1);
            if (x.start <= c + '\u0001') {
                elem.end = x.end;
                this.intervalls.removeElementAt(i + 1);
            }
            return;
        }
        this.intervalls.addElement(new Interval(c, c));
    }

    public boolean contains(char singleChar) {
        return this.indexOf(singleChar) >= 0;
    }

    public boolean equals(Object o) {
        IntCharSet set = (IntCharSet)o;
        if (this.intervalls.size() != set.intervalls.size()) {
            return false;
        }
        for (int i = 0; i < this.intervalls.size(); ++i) {
            if (this.intervalls.elementAt(i).equals(set.intervalls.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    private char min(char a, char b) {
        return a <= b ? a : b;
    }

    private char max(char a, char b) {
        return a >= b ? a : b;
    }

    public IntCharSet and(IntCharSet set) {
        IntCharSet result = new IntCharSet();
        int i = 0;
        int j = 0;
        int size = this.intervalls.size();
        int setSize = set.intervalls.size();
        while (i < size && j < setSize) {
            Interval x = (Interval)this.intervalls.elementAt(i);
            Interval y = (Interval)set.intervalls.elementAt(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            result.intervalls.addElement(new Interval(this.max(x.start, y.start), this.min(x.end, y.end)));
            if (x.end >= y.end) {
                ++j;
            }
            if (y.end < x.end) continue;
            ++i;
        }
        return result;
    }

    public void sub(IntCharSet set) {
        int i = 0;
        int j = 0;
        int setSize = set.intervalls.size();
        while (i < this.intervalls.size() && j < setSize) {
            Interval x = (Interval)this.intervalls.elementAt(i);
            Interval y = (Interval)set.intervalls.elementAt(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            if (x.start == y.start && x.end == y.end) {
                this.intervalls.removeElementAt(i);
                ++j;
                continue;
            }
            if (x.start == y.start) {
                x.start = (char)(y.end + '\u0001');
                ++j;
                continue;
            }
            if (x.end == y.end) {
                x.end = (char)(y.start - '\u0001');
                ++i;
                ++j;
                continue;
            }
            this.intervalls.insertElementAt(new Interval(x.start, (char)(y.start - '\u0001')), i);
            x.start = (char)(y.end + '\u0001');
            ++i;
            ++j;
        }
    }

    public boolean containsElements() {
        return this.intervalls.size() > 0;
    }

    public int numIntervalls() {
        return this.intervalls.size();
    }

    public Interval getNext() {
        if (this.pos == this.intervalls.size()) {
            this.pos = 0;
        }
        return (Interval)this.intervalls.elementAt(this.pos++);
    }

    public IntCharSet getCaseless() {
        IntCharSet n = this.copy();
        int size = this.intervalls.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = (Interval)this.intervalls.elementAt(i);
            for (char c = elem.start; c <= elem.end; c = (char)(c + '\u0001')) {
                n.add(Character.toLowerCase(c));
                n.add(Character.toUpperCase(c));
                n.add(Character.toTitleCase(c));
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("{ ");
        for (int i = 0; i < this.intervalls.size(); ++i) {
            result.append(this.intervalls.elementAt(i));
        }
        result.append(" }");
        return result.toString();
    }

    public IntCharSet copy() {
        IntCharSet result = new IntCharSet();
        int size = this.intervalls.size();
        for (int i = 0; i < size; ++i) {
            Interval iv = ((Interval)this.intervalls.elementAt(i)).copy();
            result.intervalls.addElement(iv);
        }
        return result;
    }
}

