/****************************************************************************
 * NCSA HDF                                                                 *
 * National Comptational Science Alliance                                   *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 *                                                                          *
 * For conditions of distribution and use, see the accompanying             *
 * hdf-java/COPYING file.                                                   *
 *                                                                          *
 ****************************************************************************/

package ncsa.hdf.hdf5lib;

/**
/**
 *  This class contains C constants and enumerated types of HDF5 library.
 *  The values of these constants are obtained from the library by calling
 *  J2C(int jconstant), where jconstant is any of the private constants which
 *  start their name with "JH5" need to be converted.
 *  <P>
 *  <B>Do not edit this file!</b>
 *
 *  <b>See also:</b> ncsa.hdf.hdf5lib.HDF5Library
 */
public class HDF5Constants
{
    static { H5.loadH5Lib(); }

    ///////////////////////////////////////////////////////////////////////////
    //                Get the HDF5 constants from the library                //
    ///////////////////////////////////////////////////////////////////////////

    public static final int H5_SZIP_MAX_PIXELS_PER_BLOCK = H5_SZIP_MAX_PIXELS_PER_BLOCK();
    public static final int H5_SZIP_NN_OPTION_MASK = H5_SZIP_NN_OPTION_MASK();
    public static final int H5_SZIP_EC_OPTION_MASK = H5_SZIP_EC_OPTION_MASK();
    public static final int H5_SZIP_ALLOW_K13_OPTION_MASK = H5_SZIP_ALLOW_K13_OPTION_MASK();
    public static final int H5_SZIP_CHIP_OPTION_MASK = H5_SZIP_CHIP_OPTION_MASK();
    public static final int H5D_ALLOC_TIME_DEFAULT = H5D_ALLOC_TIME_DEFAULT();
    public static final int H5D_ALLOC_TIME_EARLY = H5D_ALLOC_TIME_EARLY();
    public static final int H5D_ALLOC_TIME_ERROR = H5D_ALLOC_TIME_ERROR();
    public static final int H5D_ALLOC_TIME_INCR = H5D_ALLOC_TIME_INCR();
    public static final int H5D_ALLOC_TIME_LATE = H5D_ALLOC_TIME_LATE();
    public static final int H5D_CHUNKED = H5D_CHUNKED();
    public static final int H5D_COMPACT = H5D_COMPACT();
    public static final int H5D_CONTIGUOUS = H5D_CONTIGUOUS();
    public static final int H5D_FILL_TIME_ALLOC = H5D_FILL_TIME_ALLOC();
    public static final int H5D_FILL_TIME_ERROR = H5D_FILL_TIME_ERROR();
    public static final int H5D_FILL_TIME_NEVER = H5D_FILL_TIME_NEVER();
    public static final int H5D_FILL_VALUE_DEFAULT = H5D_FILL_VALUE_DEFAULT();
    public static final int H5D_FILL_VALUE_ERROR = H5D_FILL_VALUE_ERROR();
    public static final int H5D_FILL_VALUE_UNDEFINED = H5D_FILL_VALUE_UNDEFINED();
    public static final int H5D_FILL_VALUE_USER_DEFINED = H5D_FILL_VALUE_USER_DEFINED();
    public static final int H5D_LAYOUT_ERROR = H5D_LAYOUT_ERROR();
    public static final int H5D_NLAYOUTS = H5D_NLAYOUTS();
    public static final int H5D_SPACE_STATUS_ALLOCATED = H5D_SPACE_STATUS_ALLOCATED();
    public static final int H5D_SPACE_STATUS_ERROR = H5D_SPACE_STATUS_ERROR();
    public static final int H5D_SPACE_STATUS_NOT_ALLOCATED = H5D_SPACE_STATUS_NOT_ALLOCATED();
    public static final int H5D_SPACE_STATUS_PART_ALLOCATED = H5D_SPACE_STATUS_PART_ALLOCATED();
    public static final int H5E_ALIGNMENT = H5E_ALIGNMENT();
    public static final int H5E_ALREADYEXISTS = H5E_ALREADYEXISTS();
    public static final int H5E_ALREADYINIT = H5E_ALREADYINIT();
    public static final int H5E_ARGS = H5E_ARGS();
    public static final int H5E_ATOM = H5E_ATOM();
    public static final int H5E_ATTR = H5E_ATTR();
    public static final int H5E_BADATOM = H5E_BADATOM();
    public static final int H5E_BADFILE = H5E_BADFILE();
    public static final int H5E_BADGROUP = H5E_BADGROUP();
    public static final int H5E_BADMESG = H5E_BADMESG();
    public static final int H5E_BADRANGE = H5E_BADRANGE();
    public static final int H5E_BADSELECT = H5E_BADSELECT();
    public static final int H5E_BADSIZE = H5E_BADSIZE();
    public static final int H5E_BADTYPE = H5E_BADTYPE();
    public static final int H5E_BADVALUE = H5E_BADVALUE();
    public static final int H5E_BTREE = H5E_BTREE();
    public static final int H5E_CACHE = H5E_CACHE();
    public static final int H5E_CALLBACK = H5E_CALLBACK();
    public static final int H5E_CANAPPLY = H5E_CANAPPLY();
//    public static final int H5E_CANTALLOC = H5E_CANTALLOC(); 
    public static final int H5E_CANTCLIP = H5E_CANTCLIP();
    public static final int H5E_CANTCLOSEFILE = H5E_CANTCLOSEFILE();
    public static final int H5E_CANTCONVERT = H5E_CANTCONVERT();
    public static final int H5E_CANTCOPY = H5E_CANTCOPY();
    public static final int H5E_CANTCOUNT = H5E_CANTCOUNT();
    public static final int H5E_CANTCREATE = H5E_CANTCREATE();
    public static final int H5E_CANTDEC = H5E_CANTDEC();
    public static final int H5E_CANTDECODE = H5E_CANTDECODE();
    public static final int H5E_CANTDELETE = H5E_CANTDELETE();
    public static final int H5E_CANTENCODE = H5E_CANTENCODE();
    public static final int H5E_CANTFLUSH = H5E_CANTFLUSH();
    public static final int H5E_CANTFREE = H5E_CANTFREE();
    public static final int H5E_CANTGET = H5E_CANTGET();
    public static final int H5E_CANTINC = H5E_CANTINC();
    public static final int H5E_CANTINIT = H5E_CANTINIT();
    public static final int H5E_CANTINSERT = H5E_CANTINSERT();
    public static final int H5E_CANTLIST = H5E_CANTLIST();
    public static final int H5E_CANTLOAD = H5E_CANTLOAD();
    public static final int H5E_CANTLOCK = H5E_CANTLOCK();
    public static final int H5E_CANTNEXT = H5E_CANTNEXT();
    public static final int H5E_CANTOPENFILE = H5E_CANTOPENFILE();
    public static final int H5E_CANTOPENOBJ = H5E_CANTOPENOBJ();
//    public static final int H5E_CANTRECV = H5E_CANTRECV();
    public static final int H5E_CANTREGISTER = H5E_CANTREGISTER();
    public static final int H5E_CANTRELEASE = H5E_CANTRELEASE();
    public static final int H5E_CANTSELECT = H5E_CANTSELECT();
    public static final int H5E_CANTSET = H5E_CANTSET();
    public static final int H5E_CANTSPLIT = H5E_CANTSPLIT();
    public static final int H5E_CANTUNLOCK = H5E_CANTUNLOCK();
    public static final int H5E_CLOSEERROR = H5E_CLOSEERROR();
    public static final int H5E_COMPLEN = H5E_COMPLEN();
    public static final int H5E_DATASET = H5E_DATASET();
    public static final int H5E_DATASPACE = H5E_DATASPACE();
    public static final int H5E_DATATYPE = H5E_DATATYPE();
    public static final int H5E_DUPCLASS = H5E_DUPCLASS();
    public static final int H5E_EFL = H5E_EFL();
    public static final int H5E_EXISTS = H5E_EXISTS();
    public static final int H5E_FCNTL = H5E_FCNTL();
    public static final int H5E_FILE = H5E_FILE();
    public static final int H5E_FILEEXISTS = H5E_FILEEXISTS();
    public static final int H5E_FILEOPEN = H5E_FILEOPEN();
    public static final int H5E_FUNC = H5E_FUNC();
    public static final int H5E_HEAP = H5E_HEAP();
    public static final int H5E_INTERNAL = H5E_INTERNAL();
    public static final int H5E_IO = H5E_IO();
    public static final int H5E_LINK = H5E_LINK();
    public static final int H5E_LINKCOUNT = H5E_LINKCOUNT();
    public static final int H5E_MOUNT = H5E_MOUNT();
    public static final int H5E_MPI = H5E_MPI();
    public static final int H5E_MPIERRSTR = H5E_MPIERRSTR();
    public static final int H5E_NOFILTER = H5E_NOFILTER();
    public static final int H5E_NOIDS = H5E_NOIDS();
    public static final int H5E_NONE_MAJOR = H5E_NONE_MAJOR();
    public static final int H5E_NONE_MINOR = H5E_NONE_MINOR();
    public static final int H5E_NOSPACE = H5E_NOSPACE();
    public static final int H5E_NOTCACHED = H5E_NOTCACHED();
    public static final int H5E_NOTFOUND = H5E_NOTFOUND();
    public static final int H5E_NOTHDF5 = H5E_NOTHDF5();
    public static final int H5E_OHDR = H5E_OHDR();
    public static final int H5E_OVERFLOW = H5E_OVERFLOW();
    public static final int H5E_PLINE = H5E_PLINE();
    public static final int H5E_PLIST = H5E_PLIST();
    public static final int H5E_PROTECT = H5E_PROTECT();
    public static final int H5E_READERROR = H5E_READERROR();
    public static final int H5E_REFERENCE = H5E_REFERENCE();
    public static final int H5E_RESOURCE = H5E_RESOURCE();
    public static final int H5E_RS = H5E_RS();
    public static final int H5E_SEEKERROR = H5E_SEEKERROR();
    public static final int H5E_SETLOCAL = H5E_SETLOCAL();
    public static final int H5E_STORAGE = H5E_STORAGE();
    public static final int H5E_SYM = H5E_SYM();
    public static final int H5E_TRUNCATED = H5E_TRUNCATED();
    public static final int H5E_TST = H5E_TST();
    public static final int H5E_UNINITIALIZED = H5E_UNINITIALIZED();
    public static final int H5E_UNSUPPORTED = H5E_UNSUPPORTED();
    public static final int H5E_VERSION = H5E_VERSION();
    public static final int H5E_VFL = H5E_VFL();
    public static final int H5E_WALK_DOWNWARD = H5E_WALK_DOWNWARD();
    public static final int H5E_WALK_UPWARD = H5E_WALK_UPWARD();
    public static final int H5E_WRITEERROR = H5E_WRITEERROR();
    public static final int H5F_ACC_CREAT = H5F_ACC_CREAT();
    public static final int H5F_ACC_DEBUG = H5F_ACC_DEBUG();
    public static final int H5F_ACC_EXCL = H5F_ACC_EXCL();
    public static final int H5F_ACC_RDONLY = H5F_ACC_RDONLY();
    public static final int H5F_ACC_RDWR = H5F_ACC_RDWR();
    public static final int H5F_ACC_TRUNC = H5F_ACC_TRUNC();
    public static final int H5F_CLOSE_DEFAULT = H5F_CLOSE_DEFAULT();
    public static final int H5F_CLOSE_SEMI = H5F_CLOSE_SEMI();
    public static final int H5F_CLOSE_STRONG = H5F_CLOSE_STRONG();
    public static final int H5F_CLOSE_WEAK = H5F_CLOSE_WEAK();
    public static final int H5F_OBJ_ALL = H5F_OBJ_ALL();
    public static final int H5F_OBJ_ATTR = H5F_OBJ_ATTR();
    public static final int H5F_OBJ_DATASET = H5F_OBJ_DATASET();
    public static final int H5F_OBJ_DATATYPE = H5F_OBJ_DATATYPE();
    public static final int H5F_OBJ_FILE = H5F_OBJ_FILE();
    public static final int H5F_OBJ_GROUP = H5F_OBJ_GROUP();
    public static final int H5F_OBJ_LOCAL = H5F_OBJ_LOCAL();  
    public static final int H5F_SCOPE_GLOBAL = H5F_SCOPE_GLOBAL();
    public static final int H5F_SCOPE_LOCAL = H5F_SCOPE_LOCAL();
    public static final int H5F_UNLIMITED = H5F_UNLIMITED();
    public static final int H5G_DATASET = H5G_DATASET();
    public static final int H5G_GROUP = H5G_GROUP();
    public static final int H5G_LINK = H5G_LINK();
    public static final int H5G_LINK_ERROR = H5G_LINK_ERROR();
    public static final int H5G_LINK_HARD = H5G_LINK_HARD();
    public static final int H5G_LINK_SOFT = H5G_LINK_SOFT();
    public static final int H5G_NLIBTYPES = H5G_NLIBTYPES();
    public static final int H5G_NTYPES = H5G_NTYPES();
    public static final int H5G_NUSERTYPES = H5G_NUSERTYPES();
    public static final int H5G_RESERVED_5 = H5G_RESERVED_5();
    public static final int H5G_RESERVED_6 = H5G_RESERVED_6();
    public static final int H5G_RESERVED_7 = H5G_RESERVED_7();
    public static final int H5G_SAME_LOC = H5G_SAME_LOC();
    public static final int H5G_TYPE = H5G_TYPE();
    public static final int H5G_UNKNOWN = H5G_UNKNOWN();
    public static final int H5I_ATTR = H5I_ATTR();
    public static final int H5I_BADID = H5I_BADID();
    public static final int H5I_DATASET = H5I_DATASET();
    public static final int H5I_DATASPACE = H5I_DATASPACE();
    public static final int H5I_DATATYPE = H5I_DATATYPE();
    public static final int H5I_FILE = H5I_FILE();
    public static final int H5I_GENPROP_CLS = H5I_GENPROP_CLS();
    public static final int H5I_GENPROP_LST = H5I_GENPROP_LST();
    public static final int H5I_GROUP = H5I_GROUP();
    public static final int H5I_INVALID_HID = H5I_INVALID_HID();
    public static final int H5I_REFERENCE = H5I_REFERENCE();
    public static final int H5I_VFL = H5I_VFL();
    public static final int H5P_DATASET_CREATE = H5P_DATASET_CREATE();
    public static final int H5P_DATASET_CREATE_DEFAULT = H5P_DATASET_CREATE_DEFAULT();
    public static final int H5P_DATASET_XFER = H5P_DATASET_XFER();
    public static final int H5P_DATASET_XFER_DEFAULT = H5P_DATASET_XFER_DEFAULT();
    public static final int H5P_DEFAULT = H5P_DEFAULT();
    public static final int H5P_FILE_ACCESS = H5P_FILE_ACCESS();
    public static final int H5P_FILE_ACCESS_DEFAULT = H5P_FILE_ACCESS_DEFAULT();
    public static final int H5P_FILE_CREATE = H5P_FILE_CREATE();
    public static final int H5P_FILE_CREATE_DEFAULT = H5P_FILE_CREATE_DEFAULT();
    public static final int H5P_NO_CLASS = H5P_NO_CLASS();
    public static final int H5R_BADTYPE = H5R_BADTYPE();
    public static final int H5R_DATASET_REGION = H5R_DATASET_REGION();
    public static final int H5R_MAXTYPE = H5R_MAXTYPE();
    public static final int H5R_OBJ_REF_BUF_SIZE = H5R_OBJ_REF_BUF_SIZE();
    public static final int H5R_OBJECT = H5R_OBJECT();
    public static final int H5S_ALL = H5S_ALL();
    public static final int H5S_MAX_RANK = H5S_MAX_RANK();
    public static final int H5S_NO_CLASS = H5S_NO_CLASS();
    public static final int H5S_SCALAR = H5S_SCALAR();
    public static final int H5S_SEL_ALL = H5S_SEL_ALL();
    public static final int H5S_SEL_ERROR = H5S_SEL_ERROR();
    public static final int H5S_SEL_HYPERSLABS = H5S_SEL_HYPERSLABS();
    public static final int H5S_SEL_N = H5S_SEL_N();
    public static final int H5S_SEL_NONE = H5S_SEL_NONE();
    public static final int H5S_SEL_POINTS = H5S_SEL_POINTS();
    public static final int H5S_SELECT_AND = H5S_SELECT_AND();
    public static final int H5S_SELECT_APPEND = H5S_SELECT_APPEND();
    public static final int H5S_SELECT_INVALID = H5S_SELECT_INVALID();
    public static final int H5S_SELECT_NOOP = H5S_SELECT_NOOP();
    public static final int H5S_SELECT_NOTA = H5S_SELECT_NOTA();
    public static final int H5S_SELECT_NOTB = H5S_SELECT_NOTB();
    public static final int H5S_SELECT_OR = H5S_SELECT_OR();
    public static final int H5S_SELECT_PREPEND = H5S_SELECT_PREPEND();
    public static final int H5S_SELECT_SET = H5S_SELECT_SET();
    public static final int H5S_SELECT_XOR = H5S_SELECT_XOR();
    public static final int H5S_SIMPLE = H5S_SIMPLE();
    public static final int H5S_UNLIMITED = H5S_UNLIMITED();
    public static final int H5T_ALPHA_B16 = H5T_ALPHA_B16();
    public static final int H5T_ALPHA_B32 = H5T_ALPHA_B32();
    public static final int H5T_ALPHA_B64 = H5T_ALPHA_B64();
    public static final int H5T_ALPHA_B8 = H5T_ALPHA_B8();
    public static final int H5T_ALPHA_F32 = H5T_ALPHA_F32();
    public static final int H5T_ALPHA_F64 = H5T_ALPHA_F64();
    public static final int H5T_ALPHA_I16 = H5T_ALPHA_I16();
    public static final int H5T_ALPHA_I32 = H5T_ALPHA_I32();
    public static final int H5T_ALPHA_I64 = H5T_ALPHA_I64();
    public static final int H5T_ALPHA_I8 = H5T_ALPHA_I8();
    public static final int H5T_ALPHA_U16 = H5T_ALPHA_U16();
    public static final int H5T_ALPHA_U32 = H5T_ALPHA_U32();
    public static final int H5T_ALPHA_U64 = H5T_ALPHA_U64();
    public static final int H5T_ALPHA_U8 = H5T_ALPHA_U8();
    public static final int H5T_ARRAY = H5T_ARRAY();
    public static final int H5T_BITFIELD = H5T_BITFIELD();
    public static final int H5T_BKG_NO = H5T_BKG_NO();
    public static final int H5T_BKG_YES = H5T_BKG_YES();
    public static final int H5T_C_S1 = H5T_C_S1();
    public static final int H5T_COMPOUND = H5T_COMPOUND();
    public static final int H5T_CONV_CONV = H5T_CONV_CONV();
    public static final int H5T_CONV_FREE = H5T_CONV_FREE();
    public static final int H5T_CONV_INIT = H5T_CONV_INIT();
    public static final int H5T_CSET_ASCII = H5T_CSET_ASCII();
    public static final int H5T_CSET_ERROR = H5T_CSET_ERROR();
    public static final int H5T_CSET_RESERVED_10 = H5T_CSET_RESERVED_10();
    public static final int H5T_CSET_RESERVED_11 = H5T_CSET_RESERVED_11();
    public static final int H5T_CSET_RESERVED_12 = H5T_CSET_RESERVED_12();
    public static final int H5T_CSET_RESERVED_13 = H5T_CSET_RESERVED_13();
    public static final int H5T_CSET_RESERVED_14 = H5T_CSET_RESERVED_14();
    public static final int H5T_CSET_RESERVED_15 = H5T_CSET_RESERVED_15();
    public static final int H5T_CSET_RESERVED_2 = H5T_CSET_RESERVED_2();
    public static final int H5T_CSET_RESERVED_3 = H5T_CSET_RESERVED_3();
    public static final int H5T_CSET_RESERVED_4 = H5T_CSET_RESERVED_4();
    public static final int H5T_CSET_RESERVED_5 = H5T_CSET_RESERVED_5();
    public static final int H5T_CSET_RESERVED_6 = H5T_CSET_RESERVED_6();
    public static final int H5T_CSET_RESERVED_7 = H5T_CSET_RESERVED_7();
    public static final int H5T_CSET_RESERVED_8 = H5T_CSET_RESERVED_8();
    public static final int H5T_CSET_RESERVED_9 = H5T_CSET_RESERVED_9();
    public static final int H5T_DIR_ASCEND = H5T_DIR_ASCEND();
    public static final int H5T_DIR_DEFAULT = H5T_DIR_DEFAULT();
    public static final int H5T_DIR_DESCEND = H5T_DIR_DESCEND();
    public static final int H5T_ENUM = H5T_ENUM();
    public static final int H5T_FLOAT = H5T_FLOAT();
    public static final int H5T_FORTRAN_S1 = H5T_FORTRAN_S1();
    public static final int H5T_IEEE_F32BE = H5T_IEEE_F32BE();
    public static final int H5T_IEEE_F32LE = H5T_IEEE_F32LE();
    public static final int H5T_IEEE_F64BE = H5T_IEEE_F64BE();
    public static final int H5T_IEEE_F64LE = H5T_IEEE_F64LE();
    public static final int H5T_INTEGER = H5T_INTEGER();
    public static final int H5T_INTEL_B16 = H5T_INTEL_B16();
    public static final int H5T_INTEL_B32 = H5T_INTEL_B32();
    public static final int H5T_INTEL_B64 = H5T_INTEL_B64();
    public static final int H5T_INTEL_B8 = H5T_INTEL_B8();
    public static final int H5T_INTEL_F32 = H5T_INTEL_F32();
    public static final int H5T_INTEL_F64 = H5T_INTEL_F64();
    public static final int H5T_INTEL_I16 = H5T_INTEL_I16();
    public static final int H5T_INTEL_I32 = H5T_INTEL_I32();
    public static final int H5T_INTEL_I64 = H5T_INTEL_I64();
    public static final int H5T_INTEL_I8 = H5T_INTEL_I8();
    public static final int H5T_INTEL_U16 = H5T_INTEL_U16();
    public static final int H5T_INTEL_U32 = H5T_INTEL_U32();
    public static final int H5T_INTEL_U64 = H5T_INTEL_U64();
    public static final int H5T_INTEL_U8 = H5T_INTEL_U8();
    public static final int H5T_MIPS_B16 = H5T_MIPS_B16();
    public static final int H5T_MIPS_B32 = H5T_MIPS_B32();
    public static final int H5T_MIPS_B64 = H5T_MIPS_B64();
    public static final int H5T_MIPS_B8 = H5T_MIPS_B8();
    public static final int H5T_MIPS_F32 = H5T_MIPS_F32();
    public static final int H5T_MIPS_F64 = H5T_MIPS_F64();
    public static final int H5T_MIPS_I16 = H5T_MIPS_I16();
    public static final int H5T_MIPS_I32 = H5T_MIPS_I32();
    public static final int H5T_MIPS_I64 = H5T_MIPS_I64();
    public static final int H5T_MIPS_I8 = H5T_MIPS_I8();
    public static final int H5T_MIPS_U16 = H5T_MIPS_U16();
    public static final int H5T_MIPS_U32 = H5T_MIPS_U32();
    public static final int H5T_MIPS_U64 = H5T_MIPS_U64();
    public static final int H5T_MIPS_U8 = H5T_MIPS_U8();
    public static final int H5T_NATIVE_B16 = H5T_NATIVE_B16();
    public static final int H5T_NATIVE_B32 = H5T_NATIVE_B32();
    public static final int H5T_NATIVE_B64 = H5T_NATIVE_B64();
    public static final int H5T_NATIVE_B8 = H5T_NATIVE_B8();
    public static final int H5T_NATIVE_CHAR = H5T_NATIVE_CHAR();
    public static final int H5T_NATIVE_DOUBLE = H5T_NATIVE_DOUBLE();
    public static final int H5T_NATIVE_FLOAT = H5T_NATIVE_FLOAT();
    public static final int H5T_NATIVE_HADDR = H5T_NATIVE_HADDR();
    public static final int H5T_NATIVE_HBOOL = H5T_NATIVE_HBOOL();
    public static final int H5T_NATIVE_HERR = H5T_NATIVE_HERR();
    public static final int H5T_NATIVE_HSIZE = H5T_NATIVE_HSIZE();
    public static final int H5T_NATIVE_HSSIZE = H5T_NATIVE_HSSIZE();
    public static final int H5T_NATIVE_INT = H5T_NATIVE_INT();
    public static final int H5T_NATIVE_INT_FAST16 = H5T_NATIVE_INT_FAST16();
    public static final int H5T_NATIVE_INT_FAST32 = H5T_NATIVE_INT_FAST32();
    public static final int H5T_NATIVE_INT_FAST64 = H5T_NATIVE_INT_FAST64();
    public static final int H5T_NATIVE_INT_FAST8 = H5T_NATIVE_INT_FAST8();
    public static final int H5T_NATIVE_INT_LEAST16 = H5T_NATIVE_INT_LEAST16();
    public static final int H5T_NATIVE_INT_LEAST32 = H5T_NATIVE_INT_LEAST32();
    public static final int H5T_NATIVE_INT_LEAST64 = H5T_NATIVE_INT_LEAST64();
    public static final int H5T_NATIVE_INT_LEAST8 = H5T_NATIVE_INT_LEAST8();
    public static final int H5T_NATIVE_INT16 = H5T_NATIVE_INT16();
    public static final int H5T_NATIVE_INT32 = H5T_NATIVE_INT32();
    public static final int H5T_NATIVE_INT64 = H5T_NATIVE_INT64();
    public static final int H5T_NATIVE_INT8 = H5T_NATIVE_INT8();
    public static final int H5T_NATIVE_LDOUBLE = H5T_NATIVE_LDOUBLE();
    public static final int H5T_NATIVE_LLONG = H5T_NATIVE_LLONG();
    public static final int H5T_NATIVE_LONG = H5T_NATIVE_LONG();
    public static final int H5T_NATIVE_OPAQUE = H5T_NATIVE_OPAQUE();
    public static final int H5T_NATIVE_SCHAR = H5T_NATIVE_SCHAR();
    public static final int H5T_NATIVE_SHORT = H5T_NATIVE_SHORT();
    public static final int H5T_NATIVE_UCHAR = H5T_NATIVE_UCHAR();
    public static final int H5T_NATIVE_UINT = H5T_NATIVE_UINT();
    public static final int H5T_NATIVE_UINT_FAST16 = H5T_NATIVE_UINT_FAST16();
    public static final int H5T_NATIVE_UINT_FAST32 = H5T_NATIVE_UINT_FAST32();
    public static final int H5T_NATIVE_UINT_FAST64 = H5T_NATIVE_UINT_FAST64();
    public static final int H5T_NATIVE_UINT_FAST8 = H5T_NATIVE_UINT_FAST8();
    public static final int H5T_NATIVE_UINT_LEAST16 = H5T_NATIVE_UINT_LEAST16();
    public static final int H5T_NATIVE_UINT_LEAST32 = H5T_NATIVE_UINT_LEAST32();
    public static final int H5T_NATIVE_UINT_LEAST64 = H5T_NATIVE_UINT_LEAST64();
    public static final int H5T_NATIVE_UINT_LEAST8 = H5T_NATIVE_UINT_LEAST8();
    public static final int H5T_NATIVE_UINT16 = H5T_NATIVE_UINT16();
    public static final int H5T_NATIVE_UINT32 = H5T_NATIVE_UINT32();
    public static final int H5T_NATIVE_UINT64 = H5T_NATIVE_UINT64();
    public static final int H5T_NATIVE_UINT8 = H5T_NATIVE_UINT8();
    public static final int H5T_NATIVE_ULLONG = H5T_NATIVE_ULLONG();
    public static final int H5T_NATIVE_ULONG = H5T_NATIVE_ULONG();
    public static final int H5T_NATIVE_USHORT = H5T_NATIVE_USHORT();
    public static final int H5T_NCLASSES = H5T_NCLASSES();
    public static final int H5T_NO_CLASS = H5T_NO_CLASS();
    public static final int H5T_NORM_ERROR = H5T_NORM_ERROR();
    public static final int H5T_NORM_IMPLIED = H5T_NORM_IMPLIED();
    public static final int H5T_NORM_MSBSET = H5T_NORM_MSBSET();
    public static final int H5T_NORM_NONE = H5T_NORM_NONE();
    public static final int H5T_NPAD = H5T_NPAD();
    public static final int H5T_NSGN = H5T_NSGN();
    public static final int H5T_OPAQUE = H5T_OPAQUE();
    public static final int H5T_OPAQUE_TAG_MAX = H5T_OPAQUE_TAG_MAX(); /* 1.6.5 */
    public static final int H5T_ORDER_BE = H5T_ORDER_BE();
    public static final int H5T_ORDER_ERROR = H5T_ORDER_ERROR();
    public static final int H5T_ORDER_LE = H5T_ORDER_LE();
    public static final int H5T_ORDER_NONE = H5T_ORDER_NONE();
    public static final int H5T_ORDER_VAX = H5T_ORDER_VAX();
    public static final int H5T_PAD_BACKGROUND = H5T_PAD_BACKGROUND();
    public static final int H5T_PAD_ERROR = H5T_PAD_ERROR();
    public static final int H5T_PAD_ONE = H5T_PAD_ONE();
    public static final int H5T_PAD_ZERO = H5T_PAD_ZERO();
    public static final int H5T_PERS_DONTCARE = H5T_PERS_DONTCARE();
    public static final int H5T_PERS_HARD = H5T_PERS_HARD();
    public static final int H5T_PERS_SOFT = H5T_PERS_SOFT();
    public static final int H5T_REFERENCE = H5T_REFERENCE();
    public static final int H5T_SGN_2 = H5T_SGN_2();
    public static final int H5T_SGN_ERROR = H5T_SGN_ERROR();
    public static final int H5T_SGN_NONE = H5T_SGN_NONE();
    public static final int H5T_STD_B16BE = H5T_STD_B16BE();
    public static final int H5T_STD_B16LE = H5T_STD_B16LE();
    public static final int H5T_STD_B32BE = H5T_STD_B32BE();
    public static final int H5T_STD_B32LE = H5T_STD_B32LE();
    public static final int H5T_STD_B64BE = H5T_STD_B64BE();
    public static final int H5T_STD_B64LE = H5T_STD_B64LE();
    public static final int H5T_STD_B8BE = H5T_STD_B8BE();
    public static final int H5T_STD_B8LE = H5T_STD_B8LE();
    public static final int H5T_STD_I16BE = H5T_STD_I16BE();
    public static final int H5T_STD_I16LE = H5T_STD_I16LE();
    public static final int H5T_STD_I32BE = H5T_STD_I32BE();
    public static final int H5T_STD_I32LE = H5T_STD_I32LE();
    public static final int H5T_STD_I64BE = H5T_STD_I64BE();
    public static final int H5T_STD_I64LE = H5T_STD_I64LE();
    public static final int H5T_STD_I8BE = H5T_STD_I8BE();
    public static final int H5T_STD_I8LE = H5T_STD_I8LE();
    public static final int H5T_STD_REF_DSETREG = H5T_STD_REF_DSETREG();
    public static final int H5T_STD_REF_OBJ = H5T_STD_REF_OBJ();
    public static final int H5T_STD_U16BE = H5T_STD_U16BE();
    public static final int H5T_STD_U16LE = H5T_STD_U16LE();
    public static final int H5T_STD_U32BE = H5T_STD_U32BE();
    public static final int H5T_STD_U32LE = H5T_STD_U32LE();
    public static final int H5T_STD_U64BE = H5T_STD_U64BE();
    public static final int H5T_STD_U64LE = H5T_STD_U64LE();
    public static final int H5T_STD_U8BE = H5T_STD_U8BE();
    public static final int H5T_STD_U8LE = H5T_STD_U8LE();
    public static final int H5T_STR_ERROR = H5T_STR_ERROR();
    public static final int H5T_STR_NULLPAD = H5T_STR_NULLPAD();
    public static final int H5T_STR_NULLTERM = H5T_STR_NULLTERM();
    public static final int H5T_STR_RESERVED_10 = H5T_STR_RESERVED_10();
    public static final int H5T_STR_RESERVED_11 = H5T_STR_RESERVED_11();
    public static final int H5T_STR_RESERVED_12 = H5T_STR_RESERVED_12();
    public static final int H5T_STR_RESERVED_13 = H5T_STR_RESERVED_13();
    public static final int H5T_STR_RESERVED_14 = H5T_STR_RESERVED_14();
    public static final int H5T_STR_RESERVED_15 = H5T_STR_RESERVED_15();
    public static final int H5T_STR_RESERVED_3 = H5T_STR_RESERVED_3();
    public static final int H5T_STR_RESERVED_4 = H5T_STR_RESERVED_4();
    public static final int H5T_STR_RESERVED_5 = H5T_STR_RESERVED_5();
    public static final int H5T_STR_RESERVED_6 = H5T_STR_RESERVED_6();
    public static final int H5T_STR_RESERVED_7 = H5T_STR_RESERVED_7();
    public static final int H5T_STR_RESERVED_8 = H5T_STR_RESERVED_8();
    public static final int H5T_STR_RESERVED_9 = H5T_STR_RESERVED_9();
    public static final int H5T_STR_SPACEPAD = H5T_STR_SPACEPAD();
    public static final int H5T_STRING = H5T_STRING();
    public static final int H5T_TIME = H5T_TIME();
    public static final int H5T_UNIX_D32BE = H5T_UNIX_D32BE();
    public static final int H5T_UNIX_D32LE = H5T_UNIX_D32LE();
    public static final int H5T_UNIX_D64BE = H5T_UNIX_D64BE();
    public static final int H5T_UNIX_D64LE = H5T_UNIX_D64LE();
    public static final int H5T_VARIABLE = H5T_VARIABLE();
    public static final int H5T_VLEN = H5T_VLEN();
    public static final int H5Z_CB_CONT = H5Z_CB_CONT();
    public static final int H5Z_CB_ERROR = H5Z_CB_ERROR();
    public static final int H5Z_CB_FAIL = H5Z_CB_FAIL();
    public static final int H5Z_CB_NO = H5Z_CB_NO();
    public static final int H5Z_DISABLE_EDC = H5Z_DISABLE_EDC();
    public static final int H5Z_ENABLE_EDC = H5Z_ENABLE_EDC();
    public static final int H5Z_ERROR_EDC = H5Z_ERROR_EDC();
    public static final int H5Z_FILTER_DEFLATE = H5Z_FILTER_DEFLATE();
    public static final int H5Z_FILTER_ERROR = H5Z_FILTER_ERROR();
    public static final int H5Z_FILTER_FLETCHER32 = H5Z_FILTER_FLETCHER32();
    public static final int H5Z_FILTER_MAX = H5Z_FILTER_MAX();
    public static final int H5Z_FILTER_NONE = H5Z_FILTER_NONE();
    public static final int H5Z_FILTER_RESERVED = H5Z_FILTER_RESERVED();
    public static final int H5Z_FILTER_SHUFFLE = H5Z_FILTER_SHUFFLE();
    public static final int H5Z_FILTER_SZIP = H5Z_FILTER_SZIP();
    public static final int H5Z_FLAG_DEFMASK = H5Z_FLAG_DEFMASK();
    public static final int H5Z_FLAG_INVMASK = H5Z_FLAG_INVMASK();
    public static final int H5Z_FLAG_MANDATORY = H5Z_FLAG_MANDATORY();
    public static final int H5Z_FLAG_OPTIONAL = H5Z_FLAG_OPTIONAL();
    public static final int H5Z_FLAG_REVERSE = H5Z_FLAG_REVERSE();
    public static final int H5Z_FLAG_SKIP_EDC = H5Z_FLAG_SKIP_EDC();
    public static final int H5Z_MAX_NFILTERS = H5Z_MAX_NFILTERS();
    public static final int H5Z_NO_EDC = H5Z_NO_EDC();
    public static final int H5Z_FILTER_CONFIG_ENCODE_ENABLED = H5Z_FILTER_CONFIG_ENCODE_ENABLED();
    public static final int H5Z_FILTER_CONFIG_DECODE_ENABLED = H5Z_FILTER_CONFIG_DECODE_ENABLED();
    
    ///////////////////////////////////////////////////////////////////////////
    //    List of private native variables to get constant values from C     //
    //            DO NOT EDIT THE LIST UNLESS YOU WHAT YOU DO!!!             //
    ///////////////////////////////////////////////////////////////////////////
    private static native final int H5_SZIP_MAX_PIXELS_PER_BLOCK();
    private static native final int H5_SZIP_NN_OPTION_MASK();
    private static native final int H5_SZIP_EC_OPTION_MASK();
    private static native final int H5_SZIP_ALLOW_K13_OPTION_MASK();
    private static native final int H5_SZIP_CHIP_OPTION_MASK();
    private static native final int H5D_ALLOC_TIME_DEFAULT();
    private static native final int H5D_ALLOC_TIME_EARLY();
    private static native final int H5D_ALLOC_TIME_ERROR();
    private static native final int H5D_ALLOC_TIME_INCR();
    private static native final int H5D_ALLOC_TIME_LATE();
    private static native final int H5D_CHUNKED();
    private static native final int H5D_COMPACT();
    private static native final int H5D_CONTIGUOUS();
    private static native final int H5D_FILL_TIME_ALLOC();
    private static native final int H5D_FILL_TIME_ERROR();
    private static native final int H5D_FILL_TIME_NEVER();
    private static native final int H5D_FILL_VALUE_DEFAULT();
    private static native final int H5D_FILL_VALUE_ERROR();
    private static native final int H5D_FILL_VALUE_UNDEFINED();
    private static native final int H5D_FILL_VALUE_USER_DEFINED();
    private static native final int H5D_LAYOUT_ERROR();
    private static native final int H5D_NLAYOUTS();
    private static native final int H5D_SPACE_STATUS_ALLOCATED();
    private static native final int H5D_SPACE_STATUS_ERROR();
    private static native final int H5D_SPACE_STATUS_NOT_ALLOCATED();
    private static native final int H5D_SPACE_STATUS_PART_ALLOCATED();
    private static native final int H5E_ALIGNMENT();
    private static native final int H5E_ALREADYEXISTS();
    private static native final int H5E_ALREADYINIT();
    private static native final int H5E_ARGS();
    private static native final int H5E_ATOM();
    private static native final int H5E_ATTR();
    private static native final int H5E_BADATOM();
    private static native final int H5E_BADFILE();
    private static native final int H5E_BADGROUP();
    private static native final int H5E_BADMESG();
    private static native final int H5E_BADRANGE();
    private static native final int H5E_BADSELECT();
    private static native final int H5E_BADSIZE();
    private static native final int H5E_BADTYPE();
    private static native final int H5E_BADVALUE();
    private static native final int H5E_BTREE();
    private static native final int H5E_CACHE();
    private static native final int H5E_CALLBACK();
    private static native final int H5E_CANAPPLY();
//    private static native final int H5E_CANTALLOC();
    private static native final int H5E_CANTCLIP();
    private static native final int H5E_CANTCLOSEFILE();
    private static native final int H5E_CANTCONVERT();
    private static native final int H5E_CANTCOPY();
    private static native final int H5E_CANTCOUNT();
    private static native final int H5E_CANTCREATE();
    private static native final int H5E_CANTDEC();
    private static native final int H5E_CANTDECODE();
    private static native final int H5E_CANTDELETE();
    private static native final int H5E_CANTENCODE();
    private static native final int H5E_CANTFLUSH();
    private static native final int H5E_CANTFREE();
    private static native final int H5E_CANTGET();
    private static native final int H5E_CANTINC();
    private static native final int H5E_CANTINIT();
    private static native final int H5E_CANTINSERT();
    private static native final int H5E_CANTLIST();
    private static native final int H5E_CANTLOAD();
    private static native final int H5E_CANTLOCK();
    private static native final int H5E_CANTNEXT();
    private static native final int H5E_CANTOPENFILE();
    private static native final int H5E_CANTOPENOBJ();
//    private static native final int H5E_CANTRECV();
    private static native final int H5E_CANTREGISTER();
    private static native final int H5E_CANTRELEASE();
    private static native final int H5E_CANTSELECT();
    private static native final int H5E_CANTSET();
    private static native final int H5E_CANTSPLIT();
    private static native final int H5E_CANTUNLOCK();
    private static native final int H5E_CLOSEERROR();
    private static native final int H5E_COMPLEN();
    private static native final int H5E_DATASET();
    private static native final int H5E_DATASPACE();
    private static native final int H5E_DATATYPE();
    private static native final int H5E_DUPCLASS();
    private static native final int H5E_EFL();
    private static native final int H5E_EXISTS();
    private static native final int H5E_FCNTL();
    private static native final int H5E_FILE();
    private static native final int H5E_FILEEXISTS();
    private static native final int H5E_FILEOPEN();
    private static native final int H5E_FUNC();
    private static native final int H5E_HEAP();
    private static native final int H5E_INTERNAL();
    private static native final int H5E_IO();
    private static native final int H5E_LINK();
    private static native final int H5E_LINKCOUNT();
    private static native final int H5E_MOUNT();
    private static native final int H5E_MPI();
    private static native final int H5E_MPIERRSTR();
    private static native final int H5E_NOFILTER();
    private static native final int H5E_NOIDS();
    private static native final int H5E_NONE_MAJOR();
    private static native final int H5E_NONE_MINOR();
    private static native final int H5E_NOSPACE();
    private static native final int H5E_NOTCACHED();
    private static native final int H5E_NOTFOUND();
    private static native final int H5E_NOTHDF5();
    private static native final int H5E_OHDR();
    private static native final int H5E_OVERFLOW();
    private static native final int H5E_PLINE();
    private static native final int H5E_PLIST();
    private static native final int H5E_PROTECT();
    private static native final int H5E_READERROR();
    private static native final int H5E_REFERENCE();
    private static native final int H5E_RESOURCE();
    private static native final int H5E_RS();
    private static native final int H5E_SEEKERROR();
    private static native final int H5E_SETLOCAL();
    private static native final int H5E_STORAGE();
    private static native final int H5E_SYM();
    private static native final int H5E_TRUNCATED();
    private static native final int H5E_TST();
    private static native final int H5E_UNINITIALIZED();
    private static native final int H5E_UNSUPPORTED();
    private static native final int H5E_VERSION();
    private static native final int H5E_VFL();
    private static native final int H5E_WALK_DOWNWARD();
    private static native final int H5E_WALK_UPWARD();
    private static native final int H5E_WRITEERROR();
    private static native final int H5F_ACC_CREAT();
    private static native final int H5F_ACC_DEBUG();
    private static native final int H5F_ACC_EXCL();
    private static native final int H5F_ACC_RDONLY();
    private static native final int H5F_ACC_RDWR();
    private static native final int H5F_ACC_TRUNC();
    private static native final int H5F_CLOSE_DEFAULT();
    private static native final int H5F_CLOSE_SEMI();
    private static native final int H5F_CLOSE_STRONG();
    private static native final int H5F_CLOSE_WEAK();
    private static native final int H5F_OBJ_ALL();
    private static native final int H5F_OBJ_ATTR();
    private static native final int H5F_OBJ_DATASET();
    private static native final int H5F_OBJ_DATATYPE();
    private static native final int H5F_OBJ_FILE();
    private static native final int H5F_OBJ_GROUP();
    private static native final int H5F_OBJ_LOCAL(); /* 1.6.5 */
    private static native final int H5F_SCOPE_DOWN();
    private static native final int H5F_SCOPE_GLOBAL();
    private static native final int H5F_SCOPE_LOCAL();
    private static native final int H5F_UNLIMITED();
    private static native final int H5G_DATASET();
    private static native final int H5G_GROUP();
    private static native final int H5G_LINK();
    private static native final int H5G_LINK_ERROR();
    private static native final int H5G_LINK_HARD();
    private static native final int H5G_LINK_SOFT();
    private static native final int H5G_NLIBTYPES();
    private static native final int H5G_NTYPES();
    private static native final int H5G_NUSERTYPES();
    private static native final int H5G_RESERVED_5();
    private static native final int H5G_RESERVED_6();
    private static native final int H5G_RESERVED_7();
    private static native final int H5G_SAME_LOC();
    private static native final int H5G_TYPE();
    private static native final int H5G_UNKNOWN();
    private static native final int H5I_ATTR();
    private static native final int H5I_BADID();
    private static native final int H5I_DATASET();
    private static native final int H5I_DATASPACE();
    private static native final int H5I_DATATYPE();
    private static native final int H5I_FILE();
    private static native final int H5I_GENPROP_CLS();
    private static native final int H5I_GENPROP_LST();
    private static native final int H5I_GROUP();
    private static native final int H5I_INVALID_HID();
    private static native final int H5I_REFERENCE();
    private static native final int H5I_VFL();
    private static native final int H5P_DATASET_CREATE();
    private static native final int H5P_DATASET_CREATE_DEFAULT();
    private static native final int H5P_DATASET_XFER();
    private static native final int H5P_DATASET_XFER_DEFAULT();
    private static native final int H5P_DEFAULT();
    private static native final int H5P_FILE_ACCESS();
    private static native final int H5P_FILE_ACCESS_DEFAULT();
    private static native final int H5P_FILE_CREATE();
    private static native final int H5P_FILE_CREATE_DEFAULT();
    private static native final int H5P_NO_CLASS();
    private static native final int H5R_BADTYPE();
    private static native final int H5R_DATASET_REGION();
    private static native final int H5R_MAXTYPE();
    private static native final int H5R_OBJ_REF_BUF_SIZE();
    private static native final int H5R_OBJECT();
    private static native final int H5S_ALL();
    private static native final int H5S_MAX_RANK();
    private static native final int H5S_NO_CLASS();
    private static native final int H5S_SCALAR();
    private static native final int H5S_SEL_ALL();
    private static native final int H5S_SEL_ERROR();
    private static native final int H5S_SEL_HYPERSLABS();
    private static native final int H5S_SEL_N();
    private static native final int H5S_SEL_NONE();
    private static native final int H5S_SEL_POINTS();
    private static native final int H5S_SELECT_AND();
    private static native final int H5S_SELECT_APPEND();
    private static native final int H5S_SELECT_INVALID();
    private static native final int H5S_SELECT_NOOP();
    private static native final int H5S_SELECT_NOTA();
    private static native final int H5S_SELECT_NOTB();
    private static native final int H5S_SELECT_OR();
    private static native final int H5S_SELECT_PREPEND();
    private static native final int H5S_SELECT_SET();
    private static native final int H5S_SELECT_XOR();
    private static native final int H5S_SIMPLE();
    private static native final int H5S_UNLIMITED();
    private static native final int H5T_ALPHA_B16();
    private static native final int H5T_ALPHA_B32();
    private static native final int H5T_ALPHA_B64();
    private static native final int H5T_ALPHA_B8();
    private static native final int H5T_ALPHA_F32();
    private static native final int H5T_ALPHA_F64();
    private static native final int H5T_ALPHA_I16();
    private static native final int H5T_ALPHA_I32();
    private static native final int H5T_ALPHA_I64();
    private static native final int H5T_ALPHA_I8();
    private static native final int H5T_ALPHA_U16();
    private static native final int H5T_ALPHA_U32();
    private static native final int H5T_ALPHA_U64();
    private static native final int H5T_ALPHA_U8();
    private static native final int H5T_ARRAY();
    private static native final int H5T_BITFIELD();
    private static native final int H5T_BKG_NO();
    private static native final int H5T_BKG_YES();
    private static native final int H5T_C_S1();
    private static native final int H5T_COMPOUND();
    private static native final int H5T_CONV_CONV();
    private static native final int H5T_CONV_FREE();
    private static native final int H5T_CONV_INIT();
    private static native final int H5T_CSET_ASCII();
    private static native final int H5T_CSET_ERROR();
    private static native final int H5T_CSET_RESERVED_10();
    private static native final int H5T_CSET_RESERVED_11();
    private static native final int H5T_CSET_RESERVED_12();
    private static native final int H5T_CSET_RESERVED_13();
    private static native final int H5T_CSET_RESERVED_14();
    private static native final int H5T_CSET_RESERVED_15();
    private static native final int H5T_CSET_RESERVED_2();
    private static native final int H5T_CSET_RESERVED_3();
    private static native final int H5T_CSET_RESERVED_4();
    private static native final int H5T_CSET_RESERVED_5();
    private static native final int H5T_CSET_RESERVED_6();
    private static native final int H5T_CSET_RESERVED_7();
    private static native final int H5T_CSET_RESERVED_8();
    private static native final int H5T_CSET_RESERVED_9();
    private static native final int H5T_DIR_ASCEND();
    private static native final int H5T_DIR_DEFAULT();
    private static native final int H5T_DIR_DESCEND();
    private static native final int H5T_ENUM();
    private static native final int H5T_FLOAT();
    private static native final int H5T_FORTRAN_S1();
    private static native final int H5T_IEEE_F32BE();
    private static native final int H5T_IEEE_F32LE();
    private static native final int H5T_IEEE_F64BE();
    private static native final int H5T_IEEE_F64LE();
    private static native final int H5T_INTEGER();
    private static native final int H5T_INTEL_B16();
    private static native final int H5T_INTEL_B32();
    private static native final int H5T_INTEL_B64();
    private static native final int H5T_INTEL_B8();
    private static native final int H5T_INTEL_F32();
    private static native final int H5T_INTEL_F64();
    private static native final int H5T_INTEL_I16();
    private static native final int H5T_INTEL_I32();
    private static native final int H5T_INTEL_I64();
    private static native final int H5T_INTEL_I8();
    private static native final int H5T_INTEL_U16();
    private static native final int H5T_INTEL_U32();
    private static native final int H5T_INTEL_U64();
    private static native final int H5T_INTEL_U8();
    private static native final int H5T_MIPS_B16();
    private static native final int H5T_MIPS_B32();
    private static native final int H5T_MIPS_B64();
    private static native final int H5T_MIPS_B8();
    private static native final int H5T_MIPS_F32();
    private static native final int H5T_MIPS_F64();
    private static native final int H5T_MIPS_I16();
    private static native final int H5T_MIPS_I32();
    private static native final int H5T_MIPS_I64();
    private static native final int H5T_MIPS_I8();
    private static native final int H5T_MIPS_U16();
    private static native final int H5T_MIPS_U32();
    private static native final int H5T_MIPS_U64();
    private static native final int H5T_MIPS_U8();
    private static native final int H5T_NATIVE_B16();
    private static native final int H5T_NATIVE_B32();
    private static native final int H5T_NATIVE_B64();
    private static native final int H5T_NATIVE_B8();
    private static native final int H5T_NATIVE_CHAR();
    private static native final int H5T_NATIVE_DOUBLE();
    private static native final int H5T_NATIVE_FLOAT();
    private static native final int H5T_NATIVE_HADDR();
    private static native final int H5T_NATIVE_HBOOL();
    private static native final int H5T_NATIVE_HERR();
    private static native final int H5T_NATIVE_HSIZE();
    private static native final int H5T_NATIVE_HSSIZE();
    private static native final int H5T_NATIVE_INT();
    private static native final int H5T_NATIVE_INT_FAST16();
    private static native final int H5T_NATIVE_INT_FAST32();
    private static native final int H5T_NATIVE_INT_FAST64();
    private static native final int H5T_NATIVE_INT_FAST8();
    private static native final int H5T_NATIVE_INT_LEAST16();
    private static native final int H5T_NATIVE_INT_LEAST32();
    private static native final int H5T_NATIVE_INT_LEAST64();
    private static native final int H5T_NATIVE_INT_LEAST8();
    private static native final int H5T_NATIVE_INT16();
    private static native final int H5T_NATIVE_INT32();
    private static native final int H5T_NATIVE_INT64();
    private static native final int H5T_NATIVE_INT8();
    private static native final int H5T_NATIVE_LDOUBLE();
    private static native final int H5T_NATIVE_LLONG();
    private static native final int H5T_NATIVE_LONG();
    private static native final int H5T_NATIVE_OPAQUE();
    private static native final int H5T_NATIVE_SCHAR();
    private static native final int H5T_NATIVE_SHORT();
    private static native final int H5T_NATIVE_UCHAR();
    private static native final int H5T_NATIVE_UINT();
    private static native final int H5T_NATIVE_UINT_FAST16();
    private static native final int H5T_NATIVE_UINT_FAST32();
    private static native final int H5T_NATIVE_UINT_FAST64();
    private static native final int H5T_NATIVE_UINT_FAST8();
    private static native final int H5T_NATIVE_UINT_LEAST16();
    private static native final int H5T_NATIVE_UINT_LEAST32();
    private static native final int H5T_NATIVE_UINT_LEAST64();
    private static native final int H5T_NATIVE_UINT_LEAST8();
    private static native final int H5T_NATIVE_UINT16();
    private static native final int H5T_NATIVE_UINT32();
    private static native final int H5T_NATIVE_UINT64();
    private static native final int H5T_NATIVE_UINT8();
    private static native final int H5T_NATIVE_ULLONG();
    private static native final int H5T_NATIVE_ULONG();
    private static native final int H5T_NATIVE_USHORT();
    private static native final int H5T_NCLASSES();
    private static native final int H5T_NO_CLASS();
    private static native final int H5T_NORM_ERROR();
    private static native final int H5T_NORM_IMPLIED();
    private static native final int H5T_NORM_MSBSET();
    private static native final int H5T_NORM_NONE();
    private static native final int H5T_NPAD();
    private static native final int H5T_NSGN();
    private static native final int H5T_OPAQUE();
    private static native final int H5T_OPAQUE_TAG_MAX();
    private static native final int H5T_ORDER_BE();
    private static native final int H5T_ORDER_ERROR();
    private static native final int H5T_ORDER_LE();
    private static native final int H5T_ORDER_NONE();
    private static native final int H5T_ORDER_VAX();
    private static native final int H5T_PAD_BACKGROUND();
    private static native final int H5T_PAD_ERROR();
    private static native final int H5T_PAD_ONE();
    private static native final int H5T_PAD_ZERO();
    private static native final int H5T_PERS_DONTCARE();
    private static native final int H5T_PERS_HARD();
    private static native final int H5T_PERS_SOFT();
    private static native final int H5T_REFERENCE();
    private static native final int H5T_SGN_2();
    private static native final int H5T_SGN_ERROR();
    private static native final int H5T_SGN_NONE();
    private static native final int H5T_STD_B16BE();
    private static native final int H5T_STD_B16LE();
    private static native final int H5T_STD_B32BE();
    private static native final int H5T_STD_B32LE();
    private static native final int H5T_STD_B64BE();
    private static native final int H5T_STD_B64LE();
    private static native final int H5T_STD_B8BE();
    private static native final int H5T_STD_B8LE();
    private static native final int H5T_STD_I16BE();
    private static native final int H5T_STD_I16LE();
    private static native final int H5T_STD_I32BE();
    private static native final int H5T_STD_I32LE();
    private static native final int H5T_STD_I64BE();
    private static native final int H5T_STD_I64LE();
    private static native final int H5T_STD_I8BE();
    private static native final int H5T_STD_I8LE();
    private static native final int H5T_STD_REF_DSETREG();
    private static native final int H5T_STD_REF_OBJ();
    private static native final int H5T_STD_U16BE();
    private static native final int H5T_STD_U16LE();
    private static native final int H5T_STD_U32BE();
    private static native final int H5T_STD_U32LE();
    private static native final int H5T_STD_U64BE();
    private static native final int H5T_STD_U64LE();
    private static native final int H5T_STD_U8BE();
    private static native final int H5T_STD_U8LE();
    private static native final int H5T_STR_ERROR();
    private static native final int H5T_STR_NULLPAD();
    private static native final int H5T_STR_NULLTERM();
    private static native final int H5T_STR_RESERVED_10();
    private static native final int H5T_STR_RESERVED_11();
    private static native final int H5T_STR_RESERVED_12();
    private static native final int H5T_STR_RESERVED_13();
    private static native final int H5T_STR_RESERVED_14();
    private static native final int H5T_STR_RESERVED_15();
    private static native final int H5T_STR_RESERVED_3();
    private static native final int H5T_STR_RESERVED_4();
    private static native final int H5T_STR_RESERVED_5();
    private static native final int H5T_STR_RESERVED_6();
    private static native final int H5T_STR_RESERVED_7();
    private static native final int H5T_STR_RESERVED_8();
    private static native final int H5T_STR_RESERVED_9();
    private static native final int H5T_STR_SPACEPAD();
    private static native final int H5T_STRING();
    private static native final int H5T_TIME();
    private static native final int H5T_UNIX_D32BE();
    private static native final int H5T_UNIX_D32LE();
    private static native final int H5T_UNIX_D64BE();
    private static native final int H5T_UNIX_D64LE();
    private static native final int H5T_VARIABLE();
    private static native final int H5T_VLEN();
    private static native final int H5Z_CB_CONT();
    private static native final int H5Z_CB_ERROR();
    private static native final int H5Z_CB_FAIL();
    private static native final int H5Z_CB_NO();
    private static native final int H5Z_DISABLE_EDC();
    private static native final int H5Z_ENABLE_EDC();
    private static native final int H5Z_ERROR_EDC();
    private static native final int H5Z_FILTER_DEFLATE();
    private static native final int H5Z_FILTER_ERROR();
    private static native final int H5Z_FILTER_FLETCHER32();
    private static native final int H5Z_FILTER_MAX();
    private static native final int H5Z_FILTER_NONE();
    private static native final int H5Z_FILTER_RESERVED();
    private static native final int H5Z_FILTER_SHUFFLE();
    private static native final int H5Z_FILTER_SZIP();
    private static native final int H5Z_FLAG_DEFMASK();
    private static native final int H5Z_FLAG_INVMASK();
    private static native final int H5Z_FLAG_MANDATORY();
    private static native final int H5Z_FLAG_OPTIONAL();
    private static native final int H5Z_FLAG_REVERSE();
    private static native final int H5Z_FLAG_SKIP_EDC();
    private static native final int H5Z_MAX_NFILTERS();
    private static native final int H5Z_NO_EDC();
    private static native final int H5Z_FILTER_CONFIG_ENCODE_ENABLED();
    private static native final int H5Z_FILTER_CONFIG_DECODE_ENABLED();
    

}
