#ifndef _JMP_CONFIG_H
#define _JMP_CONFIG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_CONFIG_MSVC6_H
#include <config-msvc6.h>
#endif

#ifdef __MINGW32__
 #ifdef HAVE_WINDEF_H
 #  include <windef.h>
 #endif
 #ifdef HAVE_WINNT_H
 #  include <winnt.h>
 #endif
#endif

#ifdef _MSC_VER
 /* MSVC Tool Chain */
 #include <windows.h>
#endif

#ifdef __GNUC__
 #define INLINE inline
#else
 #define INLINE /* NOP */
#endif

#if (defined(ENABLE_NLS) && !defined(__MINGW32__))
#  include <libintl.h>
#  include <locale.h>
#  define _(x) gettext(x)
#else
#  define _(x) (x)
#endif

#undef JMPDEBUG
#undef JMPDEBUG_MONITOR

#ifdef HAVE_JVMTI_H
 #define SUPPORT_JVMTI
#endif

/* To test WIN32 like build under Linux undef HAVE_PTHREAD_H here */
//#undef HAVE_PTHREAD_H

/* With CYGWIN/MINGW installed with GCC 3.4.4 we get a warning
 *  emitted for malformed printf() statements.  Maybe other
 *  platforms are affected too with the same compiler version.
 */
#ifdef WIN32
 #define PRINTF_JINT_CAST (int)
#else
 #define PRINTF_JINT_CAST /*NOP*/
#endif

#if defined(HAVE_PTHREAD_H)
 #define SUPPORT_PTHREAD
 /* JVM monitors or pthread mutex ? */
 #define SUPPORT_PTHREAD_HASHLOCK

 #define PTHREAD_MUTEX_T(n)			pthread_mutex_t n
 #define PTHREAD_MUTEX_DESTROY(v)		pthread_mutex_destroy(& v)
 #define PTHREAD_MUTEX_INIT(v, a, n, r)		*(r) = pthread_mutex_init(& v, a)
 #define PTHREAD_MUTEX_LOCK(v)			pthread_mutex_lock(& v)
 #define PTHREAD_MUTEX_UNLOCK(v)		pthread_mutex_unlock(& v)
 
 #define PTHREAD_MUTEXATTR_T(n)			pthread_mutexattr_t n
 #define PTHREAD_MUTEXATTR_DESTROY(a)		pthread_mutexattr_destroy(& a)
 #define PTHREAD_MUTEXATTR_INIT(a)		pthread_mutexattr_init(& a)
 #define PTHREAD_MUTEXATTR_SETTYPE(a, t)	pthread_mutexattr_settype(& a, t)

 #define PTHREAD_COND_T(n)			pthread_cond_t n
 #define PTHREAD_COND_DESTROY(v)		pthread_cond_destroy(& v)
 #define PTHREAD_COND_INIT(v, a)		pthread_cond_init(& v, a)
 #define PTHREAD_COND_BROADCAST(v)		pthread_cond_broadcast(& v)
 #define PTHREAD_COND_TIMEDWAIT(v, m, w)	pthread_cond_timedwait(& v, & m, w)
#elif defined(WIN32)
#define SUPPORT_PTHREAD
 #define HAVE_WIN32COMPAT_H
#else
 #define PTHREAD_MUTEX_T(n)		JVMPI_RawMonitor n ## _monitor
  #define PTHREAD_MUTEX_DESTROY(v)	do {			\
		if (v ## _monitor != NULL) {			\
			jvmpi_delete_monitor (v ## _monitor);	\
			(v ## _monitor) = 0;			\
		}						\
	} while(0)
  #define PTHREAD_MUTEX_INIT(v, a, n, r)	do {			\
		JVMPI_RawMonitor _tmp_mon;				\
		_tmp_mon = jvmpi_create_monitor ((char*)n);		\
		if(_tmp_mon)						\
			*(r) = 0;					\
		else							\
			*(r) = -1;					\
		(v ## _monitor) = _tmp_mon;				\
	} while(0)
  #define PTHREAD_MUTEX_LOCK(v)		jvmpi_lock_monitor(v ## _monitor)
  #define PTHREAD_MUTEX_UNLOCK(v)	jvmpi_unlock_monitor(v ## _monitor)

 #define PTHREAD_MUTEXATTR_T(n)			/* NOP */
 #define PTHREAD_MUTEXATTR_DESTROY(a)		/* NOP */
 #define PTHREAD_MUTEXATTR_INIT(a)		/* NOP */
 #define PTHREAD_MUTEXATTR_SETTYPE(a, t)	/* NOP */

 #define PTHREAD_COND_T(n)			/* NOP */
  #define PTHREAD_COND_DESTROY(v)		/* NOP */
  #define PTHREAD_COND_INIT(v, a)		/* NOP */
  #define PTHREAD_COND_BROADCAST(v)		/* NOP */
  #define PTHREAD_COND_TIMEDWAIT(v, m, w)	sleep(1)

 /* The above macros should get your somewhere close to your
  *  platform working, with the only drawback being a
  *  buggy startup / shutdown sequence and upto a mandatory 1
  *  second delay on shutdown.
  */
 #warn "Your system does not appear to have pthreads or native thread support, so we might not be able to build"
#endif

#endif /* _JMP_CONFIG_H */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
