#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include <jmp.h>

#include <ui_gtk_gtkutils.h>
#include <ui_gtk_class_info.h>

#define BLEN 32
static char buf[BLEN];

static char* get_class_id (cls* c) {
    snprintf (buf, BLEN, "%p", cls_get_class_id (c));
    return buf;    
}

static char* get_super_class_name (cls* c) {
    cls* s = cls_get_super (c);
    if (s == NULL) 
	s = get_super_class (c);
    if (s != NULL)
	return cls_get_name (s);
    return _("<unknown>");
}

static char* get_n_interfaces (cls* c) {
    snprintf (buf, BLEN, "%d", c->n_interfaces);	/* WIN32 wants: %ld */
    return buf;
}

static char* get_n_statics (cls* c) {
    snprintf (buf, BLEN, "%d", c->n_statics);	/* WIN32 wants: %ld */
    return buf;
}

static char* get_n_instances (cls* c) {
    snprintf (buf, BLEN, "%d", c->n_instances);	/* WIN32 wants: %ld */
    return buf;
}

typedef void (*frame_adder)(int, void*, GtkWidget*);

static void add_fields_to_frame (int num, field* fields, GtkWidget* frametable) {
    int j = 0;
    for (j = 0; j < num; j++) {
	add_left_label_to_table (get_field_type (&fields[j]), frametable, j, 0);
	add_left_label_to_table (fields[j].field_name, frametable, j, 1);
    }
}

static void add_interfaces_to_frame (int num, cls** interfaces, GtkWidget* frametable) {
    int j = 0;
    for (j = 0; j < num; j++) {
	add_left_label_to_table (cls_get_name (interfaces[j]), frametable, j, 0);
    }    
}

static void add_frame_to_table (GtkWidget* table, int row, char* text, 
				frame_adder func, int num, void* data) {
    GtkWidget* frame = gtk_frame_new (text);
    GtkWidget* frametable = gtk_table_new (num, 1, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), frametable);
    gtk_table_set_row_spacings (GTK_TABLE (frametable), 2);
    gtk_table_set_col_spacings (GTK_TABLE (frametable), 10);
    gtk_table_attach (GTK_TABLE (table), frame,  0, 2, row, row + 1, 
		      GTK_FILL, 0, 0, 0);
    func (num, data, frametable);
}

/** method used to show a window with class info.. */
void show_class_info (cls* c) {
    GtkWidget* win;
    GtkWidget* table;

    gchar *labels[] = { _("Class"),
			_("Class id"),
			_("Super class"), 
			_("Source file"), 
			_("#Interfaces"),
			_("#Static vars"),
			_("#Instance vars"),
			NULL};
    
    char* ((*mp[])(cls* m)) = { cls_get_name,
				get_class_id,
				get_super_class_name, 
				cls_get_source_name,
				get_n_interfaces,
				get_n_statics,
				get_n_instances,
				NULL};
    

    win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_object_set_data (GTK_OBJECT (win), "win", win);
    gtk_window_set_title (GTK_WINDOW (win), _("Class info"));

    table = get_table (labels, (tablefunc*)mp, c);
    gtk_container_add (GTK_CONTAINER (win), table);
    
    add_frame_to_table (table, 7, _("Interfaces"), 
			(frame_adder)add_interfaces_to_frame, 
			c->n_interfaces, c->interfaces);
    add_frame_to_table (table, 8, _("Static vars"), 
			(frame_adder)add_fields_to_frame, 
			c->n_statics, c->statics);
    add_frame_to_table (table, 9, _("Instance vars"), 
			(frame_adder)add_fields_to_frame, 
			c->n_instances, c->instances);
    gtk_widget_show_all (win);
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
