#ifndef UI_GTK_INSTANCE_OWNERS_H__
#define UI_GTK_INSTANCE_OWNERS_H__

#include <hash.h>
#include <cls.h>

/** methods used to show a window with owners to objects of the given type.
 * @param objects the hash table of objects to look in.
 * @param c the class of objects to show instance owners for.
 */
void show_instance_owners (hashtab* objects, cls* c);

/** method used to show a window with the owners to the given object. 
 * @param objects the hash table of objects to look in.
 * @param obj the object to show instance owners for.
 */
void show_owner_for_object (hashtab* objects, obj* o);

/** method used to show owner statistics.
 * @param objects the hash table of objects to look in.
 * @param c the class of objects to show instance owners for.
 */
void show_owners_statistics (hashtab* objects, cls* c);

/** Show the owner for a given object. 
 * @param jid the id of the object to show owners for.
 */
void show_owner (jobjectID jid);

#endif /* UI_GTK_INSTANCE_OWNERS_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
