/* backup.h
 *
 * Copyright (C) 1999 by Jason Day
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __BACKUP_H__
#define __BACKUP_H__

#include <gtk/gtk.h>

#include "config.h"

#define MAX_DBNAME                 34  /* I got this number from struct DBInfo */
#define BACKUP_DIR_NAME            "Backup"
#define PERSISTENT_ARCH_DIR_NAME   "MainArchive"
#define MANIFEST                   ".manifest"
#define ACTIVE_DBM                 "active.dbm"
#define INACTIVE_DBM               "inactive.dbm"

#define SECONDS_PER_DAY     (60 * 60 * 24)
#define SECONDS_PER_WEEK    (SECONDS_PER_DAY * 7)
#define SECONDS_PER_MONTH   (SECONDS_PER_DAY * 30)

/* backup_when constants */
#define EVERY_SYNC          0
#define DAILY               1
#define WEEKLY              2
#define MONTHLY             3

/* button id constants */
#define BACKUP_NEW_BUTTON         100
#define EVERY_SYNC_BUTTON         101
#define DAILY_BUTTON              102
#define WEEKLY_BUTTON             103
#define MONTHLY_BUTTON            104
#define PERSISTENT_ARCHIVE_BUTTON 105

/* GDBM nolock support */
#if defined(HAVE_GDBM_NOLOCK) && !defined(FORCE_GDBM_LOCK)
#define LOCK_FLAG GDBM_NOLOCK
#else
#define LOCK_FLAG 0
#endif

int get_backup_file_name (const char *file, char *full_name, int max_size);
int get_archive_file_name (const char *arch, const char *file, char *full_name, int max_size);
int check_backup_dir (void);
int check_persistent_archive_dir (void);
int expire_archives (void);
int expire_archive (char *dir); 
int skip_backup (void);
int dbm_move_items (char *src_name, char *dest_name, GList *node);
void store_persistent_archive (const char *main_arch, const char *filename, gboolean replace);


#endif /* __BACKUP_H__ */
