import os
import datetime
from dateutil.tz import *
from dateutil.relativedelta import *
from dateutil.rrule import *
import vobject

from jppy import _jpilot, api
from jppy.utils import to_tzinfo
import legacy

from jpilot_utils import calendar_event_mixin

class Contact(_jpilot.Contact):
    pass

class addressBook(legacy.addressBook):
    _appInfoFunction      = _jpilot.w_read_ContactAppInfo
    _readDatabaseFunction = _jpilot.w_jp_read_ContactDB
    _database             = "ContactsDB-PAdd"
    _record_class         = Contact

class Event(_jpilot.Event, calendar_event_mixin):

    # TODO this should be able to be moved to the mixin
    _keys = ["dates"]

    def keys(self):
        return _jpilot.Event.keys(self) + self._keys

    def __getitem__(self, key):
        if key in self._keys:
            if hasattr(self, "_get_%s" % key):
                return getattr(self, "_get_%s" % key)()
            raise NotImplemented("Unable to get %s yet." % key)
        elif "begin" == key or "end" == key:
            return self.convertDatetimeFromPalm(_jpilot.Event.__getitem__(self, key))
        elif "exceptions" == key:
            palmExceptions = _jpilot.Event.__getitem__(self, key)
            tzExceptions = []
            for palmException in palmExceptions:
                tzExceptions.append(self.convertDatetimeFromPalm(palmException))
            return tzExceptions
        elif "timezone" == key:
            return self.gettimezone()
        else:
            return _jpilot.Event.__getitem__(self, key)

    def __setitem__(self, item, value):
        if item in self._keys:
            if hasattr(self, "_set_%s" % item):
                setattr(self, "_set_%s" % item, value)
            else:
                raise NotImplementedError("Unable to set %s yet." % item)
        else:
            if "begin" == item or "end" == item:
                value = convertDatetimeToPalm(value)
            elif "exceptions" == item:
                palmExceptions = []
                for exception in value:
                    palmExceptions.append(self.convertDatetimeToPalm(exception))
                value = palmExceptions
            elif "timezone" == item:
                # @todo if the timzone is being set, then change the times in
                # the palm object

                # dates to set: begin, end, exceptions
                raise NotImplementedError("Unable to set timezone yet.")

            _jpilot.Event.__setitem__(self, item, value)

    def gettimezone(self):
        '''
        Get the timezone for this calendar event, if no timezone exists in
        the palm, the local timezone is returned.
        '''
        timezone = _jpilot.Event.__getitem__(self, "timezone")
        if timezone:
            return to_tzinfo(timezone)
        else:
            return tzlocal()

class calendar(legacy.calendar):
    _appInfoFunction      = _jpilot.w_read_CalendarAppInfo
    _readDatabaseFunction = _jpilot.w_jp_read_CalendarDB
    _database             = "CalendarDB-PDat"
    _record_class         = Event    
